/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.navigator.internal.ui.workingsets.providers;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.ConfigureWorkingSetAction;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.ViewActionGroup;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.providers.DelegateShowProjectContentProvider;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.providers.DelegateWorkingSetContentProvider;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;

public class WorkingSetAwareContentProvider
implements ITreeContentProvider {
    public static final String CONTENT_EXTENSION_ID = "org.eclipse.wst.common.navigator.workingsets";
    DelegateShowProjectContentProvider contentProvider;
    static final String TAG_ROOT_MODE = "rootMode";
    private TreeViewer fViewer;
    private Object fInput;
    private WorkingSetModel fWorkingSetModel;
    private int fRootMode;
    private IMemento fMemento;

    public WorkingSetAwareContentProvider() {
        this.createWorkingSetModel();
        this.fRootMode = 2;
        this.setProviders();
    }

    public Object[] getChildren(Object parentElement) {
        return this.contentProvider.getChildren(parentElement);
    }

    public Object getParent(Object element) {
        return this.contentProvider.getParent(element);
    }

    public boolean hasChildren(Object element) {
        return this.contentProvider.hasChildren(element);
    }

    public Object[] getElements(Object inputElement) {
        return this.contentProvider.getElements(inputElement);
    }

    public void dispose() {
        this.contentProvider.dispose();
        if (this.fWorkingSetModel != null) {
            this.fWorkingSetModel.dispose();
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fViewer = (TreeViewer)viewer;
        this.fInput = newInput;
        this.contentProvider.inputChanged(viewer, oldInput, newInput);
    }

    public DelegateShowProjectContentProvider createContentProvider() {
        if (this.showProjects()) {
            return new DelegateShowProjectContentProvider();
        }
        return new DelegateWorkingSetContentProvider(this.fWorkingSetModel);
    }

    private void restoreRootMode(IMemento memento) {
        if (memento != null) {
            Integer value = memento.getInteger(TAG_ROOT_MODE);
            int n = this.fRootMode = value == null ? 1 : value;
            if (this.fRootMode != 1 && this.fRootMode != 2) {
                this.fRootMode = 1;
            }
        } else {
            this.fRootMode = 1;
        }
    }

    private void setProviders() {
        if (this.contentProvider != null) {
            if (this.fViewer != null) {
                this.contentProvider.inputChanged((Viewer)this.fViewer, this.fViewer.getInput(), null);
            }
            this.contentProvider.dispose();
        }
        this.contentProvider = this.createContentProvider();
        if (this.fViewer != null) {
            this.contentProvider.inputChanged((Viewer)this.fViewer, null, this.fViewer.getInput());
        }
    }

    public void restoreState(IMemento aMemento) {
        this.fMemento = aMemento;
        this.restoreRootMode(aMemento);
        if (this.fWorkingSetModel != null) {
            this.fWorkingSetModel.init(aMemento);
        }
    }

    public void saveState(IMemento aMemento) {
        aMemento.putInteger(TAG_ROOT_MODE, this.fRootMode);
        if (this.fWorkingSetModel != null) {
            this.fWorkingSetModel.saveState(aMemento);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rootModeChanged(int newMode) {
        this.fRootMode = newMode;
        ISelection selection = this.fViewer.getSelection();
        Object input = this.fViewer.getInput();
        boolean isRootInputChange = ResourcesPlugin.getWorkspace().getRoot().equals(input) || this.fWorkingSetModel != null && this.fWorkingSetModel.equals(input) || input instanceof IWorkingSet;
        try {
            this.fViewer.getControl().setRedraw(false);
            this.setProviders();
            this.fViewer.setSelection(selection, true);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.fViewer.getControl().setRedraw(true);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.fViewer.getControl().setRedraw(true);
        if (isRootInputChange && this.fWorkingSetModel.needsConfiguration()) {
            ConfigureWorkingSetAction action = new ConfigureWorkingSetAction(this.fViewer.getControl().getShell());
            action.setWorkingSetModel(this.fWorkingSetModel);
            action.run();
            this.fWorkingSetModel.configured();
        }
    }

    private void createWorkingSetModel() {
        Platform.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                WorkingSetAwareContentProvider.this.fWorkingSetModel = WorkingSetAwareContentProvider.this.fMemento != null ? new WorkingSetModel(WorkingSetAwareContentProvider.this.fMemento) : new WorkingSetModel();
            }

            public void handleException(Throwable exception) {
                WorkingSetAwareContentProvider.this.fWorkingSetModel = new WorkingSetModel();
            }
        });
    }

    public WorkingSetModel getWorkingSetModel() {
        return this.fWorkingSetModel;
    }

    public int getRootMode() {
        return this.fRootMode;
    }

    boolean showProjects() {
        return this.fRootMode == 1;
    }

    boolean showWorkingSets() {
        return this.fRootMode == 2;
    }

    private Object getDefaultRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public void workingSetModelChanged(PropertyChangeEvent event) {
        if (ViewActionGroup.MODE_CHANGED.equals(event.getProperty())) {
            this.rootModeChanged((Integer)event.getNewValue());
        } else {
            IWorkingSet cfr_ignored_0 = (IWorkingSet)event.getNewValue();
            String property = event.getProperty();
            if ("workingSetContentChange".equals(property) && this.fViewer != null) {
                this.fViewer.getControl().setRedraw(false);
                this.fViewer.refresh();
                this.fViewer.getControl().setRedraw(true);
            }
        }
    }
}

