/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.internal.text;

import java.io.IOException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.wst.html.ui.internal.text.JavaCodeReader;
import org.eclipse.wst.html.ui.internal.text.JavaHeuristicScanner;

class JavaPairMatcher
implements ICharacterPairMatcher {
    protected char[] fPairs;
    protected IDocument fDocument;
    protected int fOffset;
    protected int fStartPos;
    protected int fEndPos;
    protected int fAnchor;
    protected JavaCodeReader fReader = new JavaCodeReader();
    private boolean fHighlightAngularBrackets = false;

    public JavaPairMatcher(char[] pairs) {
        this.fPairs = pairs;
    }

    public IRegion match(IDocument document, int offset) {
        this.fOffset = offset;
        if (offset < 0 || offset >= document.getLength()) {
            return null;
        }
        this.fDocument = document;
        if (this.fDocument != null && this.matchPairsAt() && this.fStartPos != this.fEndPos) {
            return new Region(this.fStartPos, this.fEndPos - this.fStartPos + 1);
        }
        return null;
    }

    public int getAnchor() {
        return this.fAnchor;
    }

    public void dispose() {
        this.clear();
        this.fDocument = null;
        this.fReader = null;
    }

    public void clear() {
        if (this.fReader != null) {
            try {
                this.fReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected boolean matchPairsAt() {
        int pairIndex1 = this.fPairs.length;
        int pairIndex2 = this.fPairs.length;
        this.fStartPos = -1;
        this.fEndPos = -1;
        try {
            char prevChar = this.fDocument.getChar(Math.max(this.fOffset - 1, 0));
            int i = 0;
            while (i < this.fPairs.length) {
                if (prevChar == this.fPairs[i]) {
                    this.fStartPos = this.fOffset - 1;
                    pairIndex1 = i;
                }
                i += 2;
            }
            i = 1;
            while (i < this.fPairs.length) {
                if (prevChar == this.fPairs[i]) {
                    this.fEndPos = this.fOffset - 1;
                    pairIndex2 = i;
                }
                i += 2;
            }
            if (this.fEndPos > -1) {
                this.fAnchor = 0;
                this.fStartPos = this.searchForOpeningPeer(this.fEndPos, this.fPairs[pairIndex2 - 1], this.fPairs[pairIndex2], this.fDocument);
                if (this.fStartPos > -1) {
                    return true;
                }
                this.fEndPos = -1;
            } else if (this.fStartPos > -1) {
                this.fAnchor = 1;
                this.fEndPos = this.searchForClosingPeer(this.fStartPos, this.fPairs[pairIndex1], this.fPairs[pairIndex1 + 1], this.fDocument);
                if (this.fEndPos > -1) {
                    return true;
                }
                this.fStartPos = -1;
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (IOException iOException) {}
        return false;
    }

    protected int searchForClosingPeer(int offset, int openingPeer, int closingPeer, IDocument document) throws IOException {
        if (!(openingPeer != 60 || this.fHighlightAngularBrackets && this.isTypeParameterBracket(offset, document))) {
            return -1;
        }
        this.fReader.configureForwardReader(document, offset + 1, document.getLength(), true, true);
        int stack = 1;
        int c = this.fReader.read();
        while (c != -1) {
            if (c == openingPeer && c != closingPeer) {
                ++stack;
            } else if (c == closingPeer) {
                --stack;
            }
            if (stack == 0) {
                return this.fReader.getOffset();
            }
            c = this.fReader.read();
        }
        return -1;
    }

    protected int searchForOpeningPeer(int offset, int openingPeer, int closingPeer, IDocument document) throws IOException {
        if (openingPeer == 60 && !this.fHighlightAngularBrackets) {
            return -1;
        }
        this.fReader.configureBackwardReader(document, offset, true, true);
        int stack = 1;
        int c = this.fReader.read();
        while (c != -1) {
            if (c == closingPeer && c != openingPeer) {
                ++stack;
            } else if (c == openingPeer) {
                --stack;
            }
            if (stack == 0) {
                if (closingPeer == 62 && !this.isTypeParameterBracket(this.fReader.getOffset(), document)) {
                    return -1;
                }
                return this.fReader.getOffset();
            }
            c = this.fReader.read();
        }
        return -1;
    }

    private boolean isTypeParameterBracket(int offset, IDocument document) {
        try {
            String previous;
            IRegion line = document.getLineInformationOfOffset(offset);
            JavaHeuristicScanner scanner = new JavaHeuristicScanner(document);
            int prevToken = scanner.previousToken(offset - 1, line.getOffset());
            int prevTokenOffset = scanner.getPosition() + 1;
            String string = previous = prevToken == -1 ? null : document.get(prevTokenOffset, offset - prevTokenOffset).trim();
            if (prevToken == 1 || prevToken == 2 || prevToken == 7 || prevToken == 1022 || prevToken == 1019 || prevToken == 2000 && this.isTypeParameterIntroducer(previous) || prevToken == -1) {
                return true;
            }
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        return false;
    }

    private boolean isTypeParameterIntroducer(String identifier) {
        return identifier.length() > 0 && (Character.isUpperCase(identifier.charAt(0)) || identifier.startsWith("final") || identifier.startsWith("public") || identifier.startsWith("public") || identifier.startsWith("protected") || identifier.startsWith("private"));
    }
}

