/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.annotation.ui.internal.wizards;

import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jst.j2ee.ejb.annotation.internal.messages.IEJBAnnotationConstants;
import org.eclipse.jst.j2ee.ejb.annotation.internal.preferences.AnnotationPreferenceStore;
import org.eclipse.jst.j2ee.ejb.annotation.internal.provider.IAnnotationProvider;
import org.eclipse.jst.j2ee.ejb.annotation.internal.utility.AnnotationUtilities;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;

public class ChooseEjbTypeWizardPage
extends DataModelWizardPage {
    protected Button sessionType;
    protected Button messageDrivenType;
    protected Button containerManagedEntityType;

    protected ChooseEjbTypeWizardPage(IDataModel model, String pageName) {
        super(model, pageName);
        this.setDescription(IEJBAnnotationConstants.ADD_EJB_WIZARD_PAGE_DESC);
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"IEjbCommonDataModel.EJB_TYPE"};
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite aComposite = new Composite(parent, 0);
        aComposite.setLayout((Layout)new GridLayout());
        aComposite.setLayoutData((Object)new GridData(272));
        aComposite.setSize(aComposite.computeSize(-1, -1));
        aComposite.setFont(parent.getFont());
        this.createEjbTypeGroup(aComposite);
        this.createAnnotationProviderGroup(aComposite);
        this.addPreferenceLink(aComposite);
        this.setControl((Control)aComposite);
        return aComposite;
    }

    protected void createEjbTypeGroup(Composite parent) {
        Composite ejbTypeGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        ejbTypeGroup.setLayout((Layout)layout);
        ejbTypeGroup.setLayoutData((Object)new GridData(768));
        this.sessionType = new Button(ejbTypeGroup, 16);
        this.sessionType.setText("SessionBean");
        this.sessionType.setSelection(true);
        this.sessionType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ChooseEjbTypeWizardPage.this.sessionType.getSelection()) {
                    ChooseEjbTypeWizardPage.this.model.setProperty("IEjbCommonDataModel.EJB_TYPE", (Object)"SessionBean");
                    ChooseEjbTypeWizardPage.this.validateProvider();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.messageDrivenType = new Button(ejbTypeGroup, 16);
        this.messageDrivenType.setText("MessageDrivenBean");
        this.messageDrivenType.setSelection(false);
        this.messageDrivenType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ChooseEjbTypeWizardPage.this.messageDrivenType.getSelection()) {
                    ChooseEjbTypeWizardPage.this.model.setProperty("IEjbCommonDataModel.EJB_TYPE", (Object)"MessageDrivenBean");
                    ChooseEjbTypeWizardPage.this.validateProvider();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    protected void createAnnotationProviderGroup(Composite parent) {
        Composite annotationGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        annotationGroup.setLayout((Layout)layout);
        annotationGroup.setLayoutData((Object)new GridData(768));
        Label label = new Label(annotationGroup, 64);
        label.setText("Annotation Provider:");
        label.setToolTipText("Choose the annotation provider that will be used to create java classes and J2EE artifacts");
        String preferred = AnnotationPreferenceStore.getProperty((String)"ANNOTATIONPROVIDER");
        this.model.setProperty("IEjbCommonDataModel.ANNOTATIONPROVIDER", (Object)preferred);
        this.validateProvider();
        if (this.model != null) {
            this.model.setProperty("IEjbCommonDataModel.ANNOTATIONPROVIDER", (Object)preferred);
        }
    }

    public String getEJBType() {
        return this.model.getStringProperty("IEjbCommonDataModel.EJB_TYPE");
    }

    public boolean isPageComplete() {
        String provider = AnnotationPreferenceStore.getProperty((String)"ANNOTATIONPROVIDER");
        IAnnotationProvider annotationProvider = null;
        try {
            annotationProvider = AnnotationUtilities.findAnnotationProviderByName((String)provider);
        }
        catch (Exception exception) {
            return false;
        }
        return annotationProvider != null && annotationProvider.isValid();
    }

    private void addPreferenceLink(final Composite composite) {
        Link link = new Link(composite, 0);
        link.setLayoutData((Object)new GridData(4, 0, true, false, 3, 1));
        link.setText("You can change your provider <a>preferences</a>");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseEjbTypeWizardPage.this.showPreferencePage(composite);
                ChooseEjbTypeWizardPage.this.validateProvider();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    protected boolean showPreferencePage(Composite composite) {
        PreferenceManager manager = PlatformUI.getWorkbench().getPreferenceManager();
        IPreferenceNode node = manager.find("org.eclipse.jst.j2ee.ejb.annotations.xdoclet.preference");
        PreferenceManager manager2 = new PreferenceManager();
        manager2.addToRoot(node);
        final PreferenceDialog dialog = new PreferenceDialog(composite.getShell(), manager2);
        final boolean[] result = new boolean[1];
        BusyIndicator.showWhile((Display)composite.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                dialog.create();
                if (dialog.open() == 0) {
                    result[0] = true;
                }
            }
        });
        return result[0];
    }

    private void validateProvider() {
        String provider = AnnotationPreferenceStore.getProperty((String)"ANNOTATIONPROVIDER");
        this.model.setProperty("IEjbCommonDataModel.ANNOTATIONPROVIDER", (Object)provider);
        IAnnotationProvider annotationProvider = null;
        try {
            annotationProvider = AnnotationUtilities.findAnnotationProviderByName((String)provider);
        }
        catch (Exception exception) {}
        if (annotationProvider != null && annotationProvider.isValid()) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            this.setErrorMessage("Annotation provider definition is not valid, please check the preferences. ");
        }
        this.getContainer().updateMessage();
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }
}

