/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.engine;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.wst.ws.internal.explorer.platform.actions.Action;
import org.eclipse.wst.ws.internal.explorer.platform.actions.ShowPerspectiveAction;
import org.eclipse.wst.ws.internal.explorer.platform.engine.data.ActionDescriptor;
import org.eclipse.wst.ws.internal.explorer.platform.engine.data.ScenarioDescriptor;
import org.eclipse.wst.ws.internal.explorer.platform.engine.data.TransactionDescriptor;
import org.eclipse.wst.ws.internal.explorer.platform.engine.transformer.ITransformer;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;

public class ActionEngine {
    public static final byte MODE_DISABLED = 0;
    public static final byte MODE_STOP = 1;
    public static final byte MODE_RECORD = 2;
    public static final byte MODE_PLAY = 3;
    private Controller controller;
    private byte mode;
    private Vector actionDescriptors;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ActionEngine(Controller controller) {
        this.controller = controller;
        this.mode = 0;
        this.actionDescriptors = new Vector();
    }

    public void executeScenario(ScenarioDescriptor scenarioDescriptor) {
        TransactionDescriptor[] transactionDescriptors = scenarioDescriptor.getTransactionDescriptors();
        int i = 0;
        while (i < transactionDescriptors.length) {
            this.executeTransaction(transactionDescriptors[i]);
            ++i;
        }
    }

    public boolean executeTransaction(TransactionDescriptor transactionDescriptor) {
        boolean result = true;
        ActionDescriptor[] actionDescriptors = transactionDescriptor.getActionDescriptors();
        int i = 0;
        while (i < actionDescriptors.length) {
            if (result) {
                if (!this.executeAction(actionDescriptors[i])) {
                    result = false;
                }
            } else {
                actionDescriptors[i].setStatusId("unattempted");
            }
            ++i;
        }
        return result;
    }

    public boolean executeAction(ActionDescriptor actionDescriptor) {
        int attempts = actionDescriptor.getAttempts();
        int i = 0;
        while (i < attempts) {
            block10: {
                StringWriter sw;
                try {
                    Class<?> classAction = Class.forName(actionDescriptor.getId());
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.wst.ws.internal.explorer.platform.actions.Action");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (!clazz.isAssignableFrom(classAction)) break block10;
                    Action action = (Action)this.newInstance(classAction);
                    if (action != null) {
                        Hashtable properties = actionDescriptor.getProperties();
                        ITransformer[] transformers = action.getTransformers();
                        int j = 0;
                        while (j < transformers.length) {
                            properties = transformers[j].deNormalize(properties);
                            ++j;
                        }
                        action.setPropertyTable(properties);
                        boolean actionResult = action.run();
                        if (actionResult) {
                            actionDescriptor.setStatusId("passed");
                            return true;
                        }
                        break block10;
                    }
                    throw new ClassNotFoundException(actionDescriptor.getId());
                }
                catch (ClassNotFoundException cnfe) {
                    cnfe.printStackTrace();
                    sw = new StringWriter();
                    cnfe.printStackTrace(new PrintWriter(sw));
                    actionDescriptor.addStatus(sw.getBuffer().toString());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    sw = new StringWriter();
                    t.printStackTrace(new PrintWriter(sw));
                    actionDescriptor.addStatus(sw.getBuffer().toString());
                }
            }
            ++i;
        }
        actionDescriptor.setStatusId("failed");
        return false;
    }

    private ScenarioDescriptor newScenarioDescriptor() {
        return new ScenarioDescriptor();
    }

    private TransactionDescriptor newTransactionDescriptor() {
        return new TransactionDescriptor();
    }

    private ActionDescriptor newActionDescriptor(Action action) {
        ActionDescriptor actionDescriptor = new ActionDescriptor();
        actionDescriptor.setId(action.getClass().getName());
        Hashtable properties = new Hashtable(action.getPropertyTable());
        ITransformer[] transformers = action.getTransformers();
        int i = 0;
        while (i < transformers.length) {
            properties = transformers[i].normalize(properties);
            ++i;
        }
        actionDescriptor.setProperties(properties);
        return actionDescriptor;
    }

    private Object newInstance(Class c) {
        try {
            Class[] classArray = new Class[1];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Constructor constructor = c.getConstructor(classArray);
            return constructor.newInstance(this.controller);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (Throwable throwable) {}
        Object instance = null;
        try {
            Constructor constructor = c.getConstructor(new Class[0]);
            instance = constructor.newInstance(new Object[0]);
            Class[] classArray = new Class[1];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Method method = c.getMethod("setController", classArray);
            method.invoke(instance, this.controller);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (Throwable throwable) {}
        return instance;
    }

    public byte getMode() {
        return this.mode;
    }

    public void setMode(byte mode) {
        this.mode = mode;
        if (mode == 2) {
            this.actionDescriptors = new Vector();
            ShowPerspectiveAction showPerspectiveAction = new ShowPerspectiveAction(this.controller);
            showPerspectiveAction.addProperty("perspective", String.valueOf(this.controller.getCurrentPerspective().getPerspectiveId()));
            this.actionDescriptors.add(this.newActionDescriptor(showPerspectiveAction));
        }
    }

    public boolean executeAction(Action action) {
        if (this.mode == 2) {
            ActionDescriptor actionDescriptor = this.newActionDescriptor(action);
            this.actionDescriptors.add(actionDescriptor);
        }
        return action.run();
    }

    public ScenarioDescriptor getScenario() {
        ScenarioDescriptor scenarioDescriptor = this.newScenarioDescriptor();
        TransactionDescriptor transactionDescriptor = this.newTransactionDescriptor();
        ActionDescriptor[] actionDescriptorArray = this.actionDescriptors.toArray(new ActionDescriptor[0]);
        transactionDescriptor.setActionDescriptors(actionDescriptorArray);
        scenarioDescriptor.setTransactionDescriptors(new TransactionDescriptor[]{transactionDescriptor});
        return scenarioDescriptor;
    }
}

