/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.actions;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ExportResourcesAction;
import org.eclipse.ui.actions.ImportResourcesAction;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.common.navigator.internal.actions.CommonWizardRegistry;
import org.eclipse.wst.common.navigator.internal.actions.WizardActionGroup;
import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonActionProvider;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentService;
import org.eclipse.wst.common.navigator.internal.views.actions.CommonActionProvider;

public class PortingActionExtension
extends CommonActionProvider
implements ICommonActionProvider {
    private static final CommonWizardRegistry COMMON_WIZARD_REGISTRY = CommonWizardRegistry.getInstance();
    private static final String TYPE_IMPORT = "import";
    private static final String TYPE_EXPORT = "export";
    public static final String COMMON_NAVIGATOR_IMPORT_MENU = "common.import.menu";
    public static final String COMMON_NAVIGATOR_EXPORT_MENU = "common.export.menu";
    private static final Separator GROUP_IMPORT_SEPARATOR = new Separator("group.port");
    private ImportResourcesAction importAction;
    private ExportResourcesAction exportAction;
    private ActionContext actionContext;
    private NavigatorContentService contentService;
    private WizardActionGroup importWizardActionGroup;
    private WizardActionGroup exportWizardActionGroup;

    protected ImageDescriptor getImageDescriptor(String relativePath) {
        String iconPath = "icons/full/";
        try {
            AbstractUIPlugin plugin = (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
            URL installURL = plugin.getDescriptor().getInstallURL();
            URL url = new URL(installURL, String.valueOf(iconPath) + relativePath);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public void init(IViewPart aViewPart, StructuredViewer aViewer, NavigatorContentService aContentService) {
        this.contentService = aContentService;
        IWorkbenchWindow window = aViewPart.getViewSite() != null ? aViewPart.getViewSite().getWorkbenchWindow() : null;
        this.importAction = new ImportResourcesAction(window);
        this.exportAction = new ExportResourcesAction(window);
        this.importWizardActionGroup = new WizardActionGroup(window, "importWizards");
        this.exportWizardActionGroup = new WizardActionGroup(window, "exportWizards");
    }

    public void dispose() {
    }

    public void setActionContext(ActionContext aContext) {
        this.actionContext = aContext;
    }

    public boolean fillActionBars(IActionBars theActionBars) {
        theActionBars.setGlobalActionHandler(ActionFactory.IMPORT.getId(), (IAction)this.importAction);
        theActionBars.setGlobalActionHandler(ActionFactory.EXPORT.getId(), (IAction)this.exportAction);
        return true;
    }

    public boolean fillContextMenu(IMenuManager aMenu) {
        aMenu.appendToGroup("group.reorganize", (IContributionItem)GROUP_IMPORT_SEPARATOR);
        if (this.actionContext == null || this.actionContext.getSelection().isEmpty() || !(this.actionContext.getSelection() instanceof IStructuredSelection)) {
            this.addSimplePortingMenus(aMenu);
        } else {
            IStructuredSelection structuredSelection = (IStructuredSelection)this.actionContext.getSelection();
            if (structuredSelection.size() > 1) {
                this.addSimplePortingMenus(aMenu);
            } else {
                this.addFocusedPortingMenus(aMenu, structuredSelection.getFirstElement());
            }
        }
        return true;
    }

    private void addSimplePortingMenus(IMenuManager aMenu) {
        aMenu.appendToGroup("group.port", (IAction)this.importAction);
        aMenu.appendToGroup("group.port", (IAction)this.exportAction);
    }

    private void addFocusedPortingMenus(IMenuManager aMenu, Object anElement) {
        if (this.contentService != null) {
            this.addImportMenu(aMenu, anElement);
            this.addExportMenu(aMenu, anElement);
        } else {
            this.addSimplePortingMenus(aMenu);
        }
    }

    private void addImportMenu(IMenuManager aMenu, Object anElement) {
        String[] wizardDescriptorIds = COMMON_WIZARD_REGISTRY.getEnabledCommonWizardDescriptorIds(anElement, TYPE_IMPORT);
        if (wizardDescriptorIds.length == 0) {
            aMenu.appendToGroup("group.port", (IAction)this.importAction);
            return;
        }
        MenuManager submenu = new MenuManager(WorkbenchMessages.ImportResourcesAction_text, COMMON_NAVIGATOR_IMPORT_MENU);
        this.importWizardActionGroup.setWizardActionIds(wizardDescriptorIds);
        this.importWizardActionGroup.setContext(this.actionContext);
        this.importWizardActionGroup.fillContextMenu((IMenuManager)submenu);
        submenu.add((IContributionItem)new Separator("additions"));
        submenu.add((IContributionItem)new Separator());
        submenu.add((IAction)this.importAction);
        aMenu.appendToGroup("group.port", (IContributionItem)submenu);
    }

    private void addExportMenu(IMenuManager aMenu, Object anElement) {
        String[] wizardDescriptorIds = COMMON_WIZARD_REGISTRY.getEnabledCommonWizardDescriptorIds(anElement, TYPE_EXPORT);
        if (wizardDescriptorIds.length == 0) {
            aMenu.appendToGroup("group.port", (IAction)this.exportAction);
            return;
        }
        MenuManager submenu = new MenuManager(WorkbenchMessages.ExportResourcesAction_text, COMMON_NAVIGATOR_EXPORT_MENU);
        this.exportWizardActionGroup.setWizardActionIds(wizardDescriptorIds);
        this.exportWizardActionGroup.setContext(this.actionContext);
        this.exportWizardActionGroup.fillContextMenu((IMenuManager)submenu);
        submenu.add((IContributionItem)new Separator("additions"));
        submenu.add((IContributionItem)new Separator());
        submenu.add((IAction)this.exportAction);
        aMenu.appendToGroup("group.port", (IContributionItem)submenu);
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

