/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.AbstractJavaElementRenameChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class RenamePackageChange
extends AbstractJavaElementRenameChange {
    private Map fCompilationUnitStamps;

    public RenamePackageChange(IPackageFragment pack, String newName) {
        this(pack.getPath(), pack.getElementName(), newName, -1L, null);
        Assert.isTrue(!pack.isReadOnly(), "package must not be read only");
    }

    private RenamePackageChange(IPath resourcePath, String oldName, String newName, long stampToRestore, Map compilationUnitStamps) {
        super(resourcePath, oldName, newName, stampToRestore);
        this.fCompilationUnitStamps = compilationUnitStamps;
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        IJavaElement element = (IJavaElement)this.getModifiedElement();
        result.merge(this.isValid(2));
        if (result.hasFatalError()) {
            return result;
        }
        if (element != null && element.exists() && element instanceof IPackageFragment) {
            IPackageFragment pack = (IPackageFragment)element;
            ICompilationUnit[] units = pack.getCompilationUnits();
            if (units == null || units.length == 0) {
                return result;
            }
            pm.beginTask("", units.length);
            int i = 0;
            while (i < units.length) {
                pm.subTask(Messages.format(RefactoringCoreMessages.RenamePackageChange_checking_change, element.getElementName()));
                RenamePackageChange.checkIfModifiable(result, units[i], 3);
                pm.worked(1);
                ++i;
            }
            pm.done();
        }
        return result;
    }

    protected IPath createNewPath() {
        IPackageFragment oldPackage = this.getPackage();
        IPath oldPackageName = this.createPath(oldPackage.getElementName());
        IPath newPackageName = this.createPath(this.getNewName());
        return this.getResourcePath().removeLastSegments(oldPackageName.segmentCount()).append(newPackageName);
    }

    private IPath createPath(String packageName) {
        return new Path(packageName.replace('.', '/'));
    }

    public String getName() {
        return Messages.format(RefactoringCoreMessages.RenamePackageChange_name, new String[]{this.getOldName(), this.getNewName()});
    }

    protected Change createUndoChange(long stampToRestore) throws CoreException {
        IPackageFragment pack = this.getPackage();
        if (pack == null) {
            return new NullChange();
        }
        ICompilationUnit[] units = pack.getCompilationUnits();
        HashMap<IResource, Long> stamps = new HashMap<IResource, Long>();
        int i = 0;
        while (i < units.length) {
            IResource resource = units[i].getResource();
            long stamp = -1L;
            if (resource != null && (stamp = resource.getModificationStamp()) != -1L) {
                stamps.put(resource, new Long(stamp));
            }
            ++i;
        }
        return new RenamePackageChange(this.createNewPath(), this.getNewName(), this.getOldName(), stampToRestore, stamps);
    }

    protected void doRename(IProgressMonitor pm) throws CoreException {
        IPackageFragment pack = this.getPackage();
        if (pack != null) {
            IPackageFragment newPack;
            IPath newPath = this.createNewPath();
            pack.rename(this.getNewName(), false, pm);
            if (this.fCompilationUnitStamps != null && (newPack = (IPackageFragment)JavaCore.create((IFolder)ResourcesPlugin.getWorkspace().getRoot().getFolder(newPath))).exists()) {
                ICompilationUnit[] units = newPack.getCompilationUnits();
                int i = 0;
                while (i < units.length) {
                    Long stamp;
                    IResource resource = units[i].getResource();
                    if (resource != null && (stamp = (Long)this.fCompilationUnitStamps.get(resource)) != null) {
                        resource.revertModificationStamp(stamp.longValue());
                    }
                    ++i;
                }
            }
        }
    }

    private IPackageFragment getPackage() {
        return (IPackageFragment)this.getModifiedElement();
    }
}

