/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.generics;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.BindingKey;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.WildcardType;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.generics.InferTypeArgumentsConstraintCreator;
import org.eclipse.jdt.internal.corext.refactoring.generics.InferTypeArgumentsConstraintsSolver;
import org.eclipse.jdt.internal.corext.refactoring.generics.InferTypeArgumentsTCModel;
import org.eclipse.jdt.internal.corext.refactoring.generics.InferTypeArgumentsUpdate;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.EnumeratedTypeSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.TypeSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.CastVariable2;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.CollectionElementVariable2;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.ConstraintVariable2;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.TypeVariable2;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;

public class InferTypeArgumentsRefactoring
extends Refactoring {
    private static final boolean BUG_98165_core_wrong_source_range = true;
    private static final String REWRITTEN = "InferTypeArgumentsRefactoring.rewritten";
    private TextChangeManager fChangeManager;
    private final IJavaElement[] fElements;
    private InferTypeArgumentsTCModel fTCModel;
    private boolean fAssumeCloneReturnsSameType;
    private boolean fLeaveUnconstrainedRaw;

    private InferTypeArgumentsRefactoring(IJavaElement[] elements) {
        this.fElements = elements;
    }

    public static InferTypeArgumentsRefactoring create(IJavaElement[] elements) throws JavaModelException {
        if (RefactoringAvailabilityTester.isInferTypeArgumentsAvailable(elements)) {
            return new InferTypeArgumentsRefactoring(elements);
        }
        return null;
    }

    public String getName() {
        return RefactoringCoreMessages.InferTypeArgumentsRefactoring_name;
    }

    public void setAssumeCloneReturnsSameType(boolean assume) {
        this.fAssumeCloneReturnsSameType = assume;
    }

    public boolean getAssumeCloneReturnsSameType() {
        return this.fAssumeCloneReturnsSameType;
    }

    public void setLeaveUnconstrainedRaw(boolean raw) {
        this.fLeaveUnconstrainedRaw = raw;
    }

    public boolean getLeaveUnconstrainedRaw() {
        return this.fLeaveUnconstrainedRaw;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus result = this.check15();
        pm.done();
        return result;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus refactoringStatus;
        HashMap projectsToElements = this.getJavaElementsPerProject(this.fElements);
        pm.beginTask("", projectsToElements.size() + 2);
        final RefactoringStatus result = new RefactoringStatus();
        try {
            this.fTCModel = new InferTypeArgumentsTCModel();
            final InferTypeArgumentsConstraintCreator unitCollector = new InferTypeArgumentsConstraintCreator(this.fTCModel, this.fAssumeCloneReturnsSameType);
            Iterator iter = projectsToElements.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                IJavaProject project = (IJavaProject)entry.getKey();
                List javaElementsList = (List)entry.getValue();
                IJavaElement[] javaElements = javaElementsList.toArray(new IJavaElement[javaElementsList.size()]);
                List<ICompilationUnit> cus = Arrays.asList(JavaModelUtil.getAllCompilationUnits(javaElements));
                int batchSize = 150;
                int batches = (cus.size() - 1) / batchSize + 1;
                SubProgressMonitor projectMonitor = new SubProgressMonitor(pm, 1);
                projectMonitor.beginTask("", batches);
                projectMonitor.setTaskName(RefactoringCoreMessages.InferTypeArgumentsRefactoring_building);
                int i = 0;
                while (i < batches) {
                    List<ICompilationUnit> batch = cus.subList(i * batchSize, Math.min(cus.size(), (i + 1) * batchSize));
                    ICompilationUnit[] batchCus = batch.toArray(new ICompilationUnit[batch.size()]);
                    final SubProgressMonitor batchMonitor = new SubProgressMonitor((IProgressMonitor)projectMonitor, 1);
                    batchMonitor.subTask(RefactoringCoreMessages.InferTypeArgumentsRefactoring_calculating_dependencies);
                    ASTParser parser = ASTParser.newParser((int)3);
                    parser.setProject(project);
                    parser.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaElement)project));
                    parser.setResolveBindings(true);
                    parser.createASTs(batchCus, new String[0], new ASTRequestor(){

                        public void acceptAST(ICompilationUnit source, CompilationUnit ast) {
                            batchMonitor.subTask(source.getElementName());
                            ast.setProperty("org.eclipse.jdt.ui.refactoring.ast_source", (Object)source);
                            Platform.run((ISafeRunnable)new ISafeRunnable(this, ast, source, result, unitCollector){
                                final /* synthetic */ 1 this$1;
                                private final /* synthetic */ CompilationUnit val$ast;
                                private final /* synthetic */ ICompilationUnit val$source;
                                private final /* synthetic */ RefactoringStatus val$result;
                                private final /* synthetic */ InferTypeArgumentsConstraintCreator val$unitCollector;
                                {
                                    this.this$1 = var1_1;
                                    this.val$ast = compilationUnit;
                                    this.val$source = iCompilationUnit;
                                    this.val$result = refactoringStatus;
                                    this.val$unitCollector = inferTypeArgumentsConstraintCreator;
                                }

                                public void run() throws Exception {
                                    IProblem[] problems = this.val$ast.getProblems();
                                    int p = 0;
                                    while (p < problems.length) {
                                        if (problems[p].isError()) {
                                            String cuName = JavaElementLabels.getElementLabel((IJavaElement)this.val$source, 0x80000000L);
                                            String msg = MessageFormat.format(RefactoringCoreMessages.InferTypeArgumentsRefactoring_error_in_cu_skipped, cuName);
                                            this.val$result.addError(msg, JavaStatusContext.create(this.val$source, new SourceRange(problems[p])));
                                            return;
                                        }
                                        ++p;
                                    }
                                    this.val$ast.accept((ASTVisitor)this.val$unitCollector);
                                }

                                public void handleException(Throwable exception) {
                                    String cuName = JavaElementLabels.getElementLabel((IJavaElement)this.val$source, 0x80000000L);
                                    String msg = MessageFormat.format(RefactoringCoreMessages.InferTypeArgumentsRefactoring_internal_error, cuName);
                                    JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, msg, null));
                                    String msg2 = MessageFormat.format(RefactoringCoreMessages.InferTypeArgumentsRefactoring_error_skipped, cuName);
                                    this.val$result.addError(msg2, JavaStatusContext.create(this.val$source));
                                }
                            });
                            InferTypeArgumentsRefactoring.this.fTCModel.newCu();
                        }

                        public void acceptBinding(String bindingKey, IBinding binding) {
                        }
                    }, (IProgressMonitor)batchMonitor);
                    ++i;
                }
                projectMonitor.done();
                this.fTCModel.newCu();
            }
            pm.setTaskName(RefactoringCoreMessages.InferTypeArgumentsRefactoring_solving);
            InferTypeArgumentsConstraintsSolver solver = new InferTypeArgumentsConstraintsSolver(this.fTCModel);
            InferTypeArgumentsUpdate updates = solver.solveConstraints(new SubProgressMonitor(pm, 1));
            solver = null;
            this.fChangeManager = new TextChangeManager();
            this.rewriteDeclarations(updates, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            IFile[] filesToModify = ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits());
            result.merge(Checks.validateModifiesFiles(filesToModify, this.getValidationContext()));
            refactoringStatus = result;
            Object var19_20 = null;
        }
        catch (Throwable throwable) {
            Object var19_21 = null;
            pm.done();
            this.clearGlobalState();
            throw throwable;
        }
        pm.done();
        this.clearGlobalState();
        return refactoringStatus;
    }

    private void clearGlobalState() {
        TypeSet.resetCount();
        EnumeratedTypeSet.resetCount();
        this.fTCModel = null;
    }

    private HashMap getJavaElementsPerProject(IJavaElement[] elements) {
        HashMap<IJavaProject, ArrayList<IJavaElement>> result = new HashMap<IJavaProject, ArrayList<IJavaElement>>();
        int i = 0;
        while (i < this.fElements.length) {
            IJavaElement element = this.fElements[i];
            IJavaProject javaProject = element.getJavaProject();
            ArrayList<IJavaElement> javaElements = (ArrayList<IJavaElement>)result.get(javaProject);
            if (javaElements == null) {
                javaElements = new ArrayList<IJavaElement>();
                result.put(javaProject, javaElements);
            }
            javaElements.add(element);
            ++i;
        }
        return result;
    }

    private RefactoringStatus check15() throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        HashSet<IJavaProject> checkedProjects = new HashSet<IJavaProject>();
        int i = 0;
        while (i < this.fElements.length) {
            IJavaProject javaProject = this.fElements[i].getJavaProject();
            if (!checkedProjects.contains(javaProject)) {
                String message;
                if (!JavaModelUtil.is50OrHigher(javaProject)) {
                    message = Messages.format(RefactoringCoreMessages.InferTypeArgumentsRefactoring_not50, javaProject.getElementName());
                    result.addFatalError(message);
                } else if (!JavaModelUtil.is50OrHigherJRE(javaProject)) {
                    message = Messages.format(RefactoringCoreMessages.InferTypeArgumentsRefactoring_not50Library, javaProject.getElementName());
                    result.addFatalError(message);
                }
                checkedProjects.add(javaProject);
            }
            ++i;
        }
        return result;
    }

    private void rewriteDeclarations(InferTypeArgumentsUpdate update, IProgressMonitor pm) throws CoreException {
        HashMap updates = update.getUpdates();
        Set entrySet = updates.entrySet();
        pm.beginTask("", entrySet.size());
        pm.setTaskName(RefactoringCoreMessages.InferTypeArgumentsRefactoring_creatingChanges);
        Iterator iter = entrySet.iterator();
        while (iter.hasNext()) {
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            Map.Entry entry = iter.next();
            ICompilationUnit cu = (ICompilationUnit)entry.getKey();
            pm.worked(1);
            pm.subTask(cu.getElementName());
            CompilationUnitRewrite rewrite = new CompilationUnitRewrite(cu);
            rewrite.setResolveBindings(false);
            InferTypeArgumentsUpdate.CuUpdate cuUpdate = (InferTypeArgumentsUpdate.CuUpdate)entry.getValue();
            Iterator cvIter = cuUpdate.getDeclarations().iterator();
            while (cvIter.hasNext()) {
                ConstraintVariable2 cv = (ConstraintVariable2)cvIter.next();
                this.rewriteConstraintVariable(cv, rewrite);
            }
            Iterator castsIter = cuUpdate.getCastsToRemove().iterator();
            while (castsIter.hasNext()) {
                CastVariable2 castCv = (CastVariable2)castsIter.next();
                this.rewriteCastVariable(castCv, rewrite);
            }
            CompilationUnitChange change = rewrite.createChange();
            if (change == null) continue;
            this.fChangeManager.manage(cu, (TextChange)change);
        }
    }

    private void rewriteConstraintVariable(ConstraintVariable2 cv, CompilationUnitRewrite rewrite) {
        ConstraintVariable2 parentElement;
        if (cv instanceof CollectionElementVariable2 && (parentElement = ((CollectionElementVariable2)cv).getParentConstraintVariable()) instanceof TypeVariable2) {
            TypeVariable2 typeCv = (TypeVariable2)parentElement;
            this.rewriteTypeVariable(typeCv, rewrite);
        }
    }

    private void rewriteTypeVariable(TypeVariable2 typeCv, CompilationUnitRewrite rewrite) {
        ASTNode node = typeCv.getRange().getNode(rewrite.getRoot());
        if (node instanceof Name && node.getParent() instanceof Type) {
            Type originalType = (Type)node.getParent();
            Object rewritten = originalType.getProperty(REWRITTEN);
            if (rewritten == REWRITTEN) {
                return;
            }
            originalType.setProperty(REWRITTEN, (Object)REWRITTEN);
            ArrayList typeArgumentCvs = this.getTypeArgumentCvs(typeCv);
            Type[] typeArguments = this.getTypeArguments(originalType, typeArgumentCvs, rewrite);
            if (typeArguments == null) {
                return;
            }
            Type movingType = (Type)rewrite.getASTRewrite().createMoveTarget((ASTNode)originalType);
            ParameterizedType newType = rewrite.getAST().newParameterizedType(movingType);
            int i = 0;
            while (i < typeArguments.length) {
                newType.typeArguments().add(typeArguments[i]);
                ++i;
            }
            rewrite.getASTRewrite().replace((ASTNode)originalType, (ASTNode)newType, rewrite.createGroupDescription(RefactoringCoreMessages.InferTypeArgumentsRefactoring_addTypeArguments));
        }
    }

    private Type[] getTypeArguments(Type baseType, ArrayList typeArgumentCvs, CompilationUnitRewrite rewrite) {
        if (typeArgumentCvs.size() == 0) {
            return null;
        }
        Type[] typeArguments = new Type[typeArgumentCvs.size()];
        int i = 0;
        while (i < typeArgumentCvs.size()) {
            WildcardType typeArgument;
            CollectionElementVariable2 elementCv = (CollectionElementVariable2)typeArgumentCvs.get(i);
            TType chosenType = InferTypeArgumentsConstraintsSolver.getChosenType(elementCv);
            if (chosenType != null) {
                ArrayList nestedTypeArgumentCvs;
                if (chosenType.isWildcardType() && !this.unboundedWildcardAllowed(baseType)) {
                    return null;
                }
                if (chosenType.isParameterizedType()) {
                    chosenType = chosenType.getTypeDeclaration();
                }
                BindingKey bindingKey = new BindingKey(chosenType.getBindingKey());
                typeArgument = rewrite.getImportRewrite().addImportFromSignature(bindingKey.internalToSignature(), rewrite.getAST());
                Type[] nestedTypeArguments = this.getTypeArguments((Type)typeArgument, nestedTypeArgumentCvs = this.getTypeArgumentCvs(elementCv), rewrite);
                if (nestedTypeArguments != null) {
                    ParameterizedType parameterizedType = rewrite.getAST().newParameterizedType((Type)typeArgument);
                    int j = 0;
                    while (j < nestedTypeArguments.length) {
                        parameterizedType.typeArguments().add(nestedTypeArguments[j]);
                        ++j;
                    }
                    typeArgument = parameterizedType;
                }
            } else {
                if (this.fLeaveUnconstrainedRaw) {
                    return null;
                }
                if (this.unboundedWildcardAllowed(baseType)) {
                    typeArgument = rewrite.getAST().newWildcardType();
                } else {
                    String object = rewrite.getImportRewrite().addImport("java.lang.Object");
                    typeArgument = (Type)rewrite.getASTRewrite().createStringPlaceholder(object, 43);
                }
            }
            typeArguments[i] = typeArgument;
            ++i;
        }
        return typeArguments;
    }

    private ArrayList getTypeArgumentCvs(ConstraintVariable2 baseCv) {
        Map elementCvs = this.fTCModel.getElementVariables(baseCv);
        ArrayList<CollectionElementVariable2> typeArgumentCvs = new ArrayList<CollectionElementVariable2>();
        Iterator iter = elementCvs.values().iterator();
        while (iter.hasNext()) {
            CollectionElementVariable2 elementCv = (CollectionElementVariable2)iter.next();
            int index = elementCv.getDeclarationTypeVariableIndex();
            if (index == -1) continue;
            while (index >= typeArgumentCvs.size()) {
                typeArgumentCvs.add(null);
            }
            typeArgumentCvs.set(index, elementCv);
        }
        return typeArgumentCvs;
    }

    private boolean unboundedWildcardAllowed(Type originalType) {
        ASTNode parent = originalType.getParent();
        while (parent instanceof Type) {
            parent = parent.getParent();
        }
        if (parent instanceof ClassInstanceCreation) {
            return false;
        }
        if (parent instanceof AbstractTypeDeclaration) {
            return false;
        }
        return !(parent instanceof TypeLiteral);
    }

    private void rewriteCastVariable(CastVariable2 castCv, CompilationUnitRewrite rewrite) {
        ASTNode node = castCv.getRange().getNode(rewrite.getRoot());
        if (!(node instanceof CastExpression)) {
            return;
        }
        CastExpression castExpression = (CastExpression)node;
        Expression expression = castExpression.getExpression();
        Object nodeToReplace = castExpression.getParent() instanceof ParenthesizedExpression ? castExpression.getParent() : castExpression;
        Expression newExpression = (Expression)rewrite.getASTRewrite().createMoveTarget((ASTNode)expression);
        rewrite.getASTRewrite().replace((ASTNode)nodeToReplace, (ASTNode)newExpression, rewrite.createGroupDescription(RefactoringCoreMessages.InferTypeArgumentsRefactoring_removeCast));
        rewrite.getImportRemover().registerRemovedNode((ASTNode)nodeToReplace);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        DynamicValidationStateChange dynamicValidationStateChange;
        pm.beginTask("", 1);
        try {
            DynamicValidationStateChange result;
            dynamicValidationStateChange = result = new DynamicValidationStateChange(RefactoringCoreMessages.InferTypeArgumentsRefactoring_name, (Change[])this.fChangeManager.getAllChanges());
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return dynamicValidationStateChange;
    }
}

