/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;

public class TypeChangeCompletionProposal
extends LinkedCorrectionProposal {
    private IBinding fBinding;
    private CompilationUnit fAstRoot;
    private ITypeBinding fNewType;
    private boolean fOfferSuperTypeProposals;

    public TypeChangeCompletionProposal(ICompilationUnit targetCU, IBinding binding, CompilationUnit astRoot, ITypeBinding newType, boolean offerSuperTypeProposals, int relevance) {
        super("", targetCU, (ASTRewrite)null, relevance, JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif"));
        Assert.isTrue(binding != null && (binding.getKind() == 4 || binding.getKind() == 3) && Bindings.isDeclarationBinding(binding));
        this.fBinding = binding;
        this.fAstRoot = astRoot;
        this.fNewType = newType;
        this.fOfferSuperTypeProposals = offerSuperTypeProposals;
        String typeName = BindingLabelProvider.getBindingLabel((IBinding)newType, JavaElementLabels.ALL_DEFAULT);
        if (binding.getKind() == 3) {
            IVariableBinding varBinding = (IVariableBinding)binding;
            Object[] args = new String[]{varBinding.getName(), typeName};
            if (varBinding.isField()) {
                this.setDisplayName(Messages.format(CorrectionMessages.TypeChangeCompletionProposal_field_name, args));
            } else if (astRoot.findDeclaringNode(binding) instanceof SingleVariableDeclaration) {
                this.setDisplayName(Messages.format(CorrectionMessages.TypeChangeCompletionProposal_param_name, args));
            } else {
                this.setDisplayName(Messages.format(CorrectionMessages.TypeChangeCompletionProposal_variable_name, args));
            }
        } else {
            Object[] args = new String[]{binding.getName(), typeName};
            this.setDisplayName(Messages.format(CorrectionMessages.TypeChangeCompletionProposal_method_name, args));
        }
    }

    protected ASTRewrite getRewrite() throws CoreException {
        ASTNode boundNode = this.fAstRoot.findDeclaringNode(this.fBinding);
        ASTNode declNode = null;
        if (boundNode != null) {
            declNode = boundNode;
        } else {
            ASTParser astParser = ASTParser.newParser((int)3);
            astParser.setSource(this.getCompilationUnit());
            astParser.setResolveBindings(true);
            CompilationUnit newRoot = (CompilationUnit)astParser.createAST(null);
            declNode = newRoot.findDeclaringNode(this.fBinding.getKey());
        }
        if (declNode != null) {
            AST ast = declNode.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            Type type = this.getImportRewrite().addImport(this.fNewType, ast);
            if (declNode instanceof MethodDeclaration) {
                MethodDeclaration methodDecl = (MethodDeclaration)declNode;
                rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)MethodDeclaration.RETURN_TYPE2_PROPERTY, (Object)type, null);
                rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)MethodDeclaration.EXTRA_DIMENSIONS_PROPERTY, (Object)new Integer(0), null);
            } else if (declNode instanceof VariableDeclarationFragment) {
                VariableDeclarationStatement varDecl;
                VariableDeclarationFragment placeholder;
                ASTNode parent = declNode.getParent();
                if (parent instanceof FieldDeclaration) {
                    FieldDeclaration fieldDecl = (FieldDeclaration)parent;
                    if (fieldDecl.fragments().size() > 1 && fieldDecl.getParent() instanceof AbstractTypeDeclaration) {
                        placeholder = (VariableDeclarationFragment)rewrite.createMoveTarget(declNode);
                        FieldDeclaration newField = ast.newFieldDeclaration(placeholder);
                        newField.setType(type);
                        AbstractTypeDeclaration typeDecl = (AbstractTypeDeclaration)fieldDecl.getParent();
                        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)typeDecl, typeDecl.getBodyDeclarationsProperty());
                        if (fieldDecl.fragments().indexOf(declNode) == 0) {
                            listRewrite.insertBefore((ASTNode)newField, parent, null);
                        } else {
                            listRewrite.insertAfter((ASTNode)newField, parent, null);
                        }
                    } else {
                        rewrite.set((ASTNode)fieldDecl, (StructuralPropertyDescriptor)FieldDeclaration.TYPE_PROPERTY, (Object)type, null);
                        rewrite.set(declNode, (StructuralPropertyDescriptor)VariableDeclarationFragment.EXTRA_DIMENSIONS_PROPERTY, (Object)new Integer(0), null);
                    }
                } else if (parent instanceof VariableDeclarationStatement) {
                    varDecl = (VariableDeclarationStatement)parent;
                    if (varDecl.fragments().size() > 1 && varDecl.getParent() instanceof Block) {
                        placeholder = (VariableDeclarationFragment)rewrite.createMoveTarget(declNode);
                        VariableDeclarationStatement newStat = ast.newVariableDeclarationStatement(placeholder);
                        newStat.setType(type);
                        ListRewrite listRewrite = rewrite.getListRewrite(varDecl.getParent(), Block.STATEMENTS_PROPERTY);
                        if (varDecl.fragments().indexOf(declNode) == 0) {
                            listRewrite.insertBefore((ASTNode)newStat, parent, null);
                        } else {
                            listRewrite.insertAfter((ASTNode)newStat, parent, null);
                        }
                    } else {
                        rewrite.set((ASTNode)varDecl, (StructuralPropertyDescriptor)VariableDeclarationStatement.TYPE_PROPERTY, (Object)type, null);
                        rewrite.set(declNode, (StructuralPropertyDescriptor)VariableDeclarationFragment.EXTRA_DIMENSIONS_PROPERTY, (Object)new Integer(0), null);
                    }
                } else if (parent instanceof VariableDeclarationExpression) {
                    varDecl = (VariableDeclarationExpression)parent;
                    rewrite.set((ASTNode)varDecl, (StructuralPropertyDescriptor)VariableDeclarationExpression.TYPE_PROPERTY, (Object)type, null);
                    rewrite.set(declNode, (StructuralPropertyDescriptor)VariableDeclarationFragment.EXTRA_DIMENSIONS_PROPERTY, (Object)new Integer(0), null);
                }
            } else if (declNode instanceof SingleVariableDeclaration) {
                SingleVariableDeclaration variableDeclaration = (SingleVariableDeclaration)declNode;
                rewrite.set((ASTNode)variableDeclaration, (StructuralPropertyDescriptor)SingleVariableDeclaration.TYPE_PROPERTY, (Object)type, null);
                rewrite.set((ASTNode)variableDeclaration, (StructuralPropertyDescriptor)SingleVariableDeclaration.EXTRA_DIMENSIONS_PROPERTY, (Object)new Integer(0), null);
            }
            this.addLinkedPosition(rewrite.track((ASTNode)type), true, "type");
            if (this.fOfferSuperTypeProposals) {
                ITypeBinding[] typeProposals = ASTResolving.getRelaxingTypes(ast, this.fNewType);
                int i = 0;
                while (i < typeProposals.length) {
                    this.addLinkedPositionProposal("type", typeProposals[i]);
                    ++i;
                }
            }
            return rewrite;
        }
        return null;
    }
}

