/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.ExperimentalProposal;
import org.eclipse.jdt.internal.ui.text.java.GenericJavaTypeProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaMethodCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.ParameterGuessingProposal;
import org.eclipse.jdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.preference.IPreferenceStore;

public final class ExperimentalResultCollector
extends CompletionProposalCollector {
    public ExperimentalResultCollector(ICompilationUnit cu) {
        super(cu);
    }

    protected IJavaCompletionProposal createJavaCompletionProposal(CompletionProposal proposal) {
        if (proposal.getKind() == 6) {
            return this.createMethodReferenceProposal(proposal);
        }
        if (proposal.getKind() == 9) {
            return this.createTypeProposal(proposal);
        }
        return super.createJavaCompletionProposal(proposal);
    }

    private IJavaCompletionProposal createMethodReferenceProposal(CompletionProposal methodProposal) {
        String completion = String.valueOf(methodProposal.getCompletion());
        if (completion.length() == 0 || completion.length() == 1 && completion.charAt(0) == ')' || Signature.getParameterCount((char[])methodProposal.getSignature()) == 0) {
            return super.createJavaCompletionProposal(methodProposal);
        }
        IPreferenceStore preferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        JavaMethodCompletionProposal proposal = preferenceStore.getBoolean("content_assist_guess_method_arguments") ? new ParameterGuessingProposal(methodProposal, this.getCompilationUnit()) : new ExperimentalProposal(methodProposal, this.getCompilationUnit());
        return proposal;
    }

    private IJavaCompletionProposal createTypeProposal(CompletionProposal typeProposal) {
        ICompilationUnit cu = this.getCompilationUnit();
        if (cu == null) {
            return super.createJavaCompletionProposal(typeProposal);
        }
        IJavaProject project = cu.getJavaProject();
        if (!this.shouldProposeGenerics(project)) {
            return super.createJavaCompletionProposal(typeProposal);
        }
        char[] completion = typeProposal.getCompletion();
        if (completion.length == 0 || completion[completion.length - 1] == ';') {
            return super.createJavaCompletionProposal(typeProposal);
        }
        GenericJavaTypeProposal newProposal = new GenericJavaTypeProposal(typeProposal, this.getContext(), cu);
        return newProposal;
    }

    private final boolean shouldProposeGenerics(IJavaProject project) {
        String sourceVersion = project != null ? project.getOption("org.eclipse.jdt.core.compiler.source", true) : JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source");
        return sourceVersion != null && "1.5".compareTo(sourceVersion) <= 0;
    }
}

