/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.parsers.StandardParserConfiguration;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.eclipse.wst.wsdl.validation.internal.ControllerValidationInfo;
import org.eclipse.wst.wsdl.validation.internal.IValidationMessage;
import org.eclipse.wst.wsdl.validation.internal.IValidationReport;
import org.eclipse.wst.wsdl.validation.internal.IWSDLValidator;
import org.eclipse.wst.wsdl.validation.internal.ValidationInfoImpl;
import org.eclipse.wst.wsdl.validation.internal.ValidationMessageImpl;
import org.eclipse.wst.wsdl.validation.internal.ValidatorRegistry;
import org.eclipse.wst.wsdl.validation.internal.WSDLValidatorDelegate;
import org.eclipse.wst.wsdl.validation.internal.exception.ValidateWSDLException;
import org.eclipse.wst.wsdl.validation.internal.resolver.URIResolver;
import org.eclipse.wst.wsdl.validation.internal.util.MessageGenerator;
import org.eclipse.wst.wsdl.validation.internal.xml.AbstractXMLConformanceFactory;
import org.eclipse.wst.wsdl.validation.internal.xml.DefaultXMLValidator;
import org.eclipse.wst.wsdl.validation.internal.xml.IXMLValidator;
import org.eclipse.wst.wsdl.validation.internal.xml.LineNumberDOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class ValidationController {
    protected final String _ERROR_PROBLEM_WSDL_VALIDATOR = "_ERROR_PROBLEM_WSDL_VALIDATOR";
    protected final String _ERROR_NO_WSDL_VALIDATOR = "_ERROR_NO_WSDL_VALIDATOR";
    protected final String _ERROR_PROBLEM_EXT_VALIDATOR = "_ERROR_PROBLEM_EXT_VALIDATOR";
    protected ValidatorRegistry ver;
    protected ResourceBundle resourcebundle;
    protected MessageGenerator messagegenerator;
    protected URIResolver uriResolver;
    protected Hashtable attributes = new Hashtable();

    public ValidationController(ResourceBundle rb, URIResolver uriResolver) {
        this.resourcebundle = rb;
        this.messagegenerator = new MessageGenerator(this.resourcebundle);
        this.uriResolver = uriResolver;
        this.ver = ValidatorRegistry.getInstance();
    }

    public void setAttributes(Hashtable attributes) {
        this.attributes.putAll(attributes);
    }

    public IValidationReport validate(String uri, InputStream inputStream) {
        String wsdlns;
        Document wsdldoc;
        ByteArrayInputStream xmlValidateStream = null;
        ByteArrayInputStream wsdlValidateStream = null;
        if (inputStream != null) {
            String contents = this.createStringForInputStream(inputStream);
            xmlValidateStream = new ByteArrayInputStream(contents.getBytes());
            wsdlValidateStream = new ByteArrayInputStream(contents.getBytes());
        }
        ValidationInfoImpl valInfo = new ValidationInfoImpl(uri, this.messagegenerator);
        valInfo.setURIResolver(this.uriResolver);
        valInfo.setAttributes(this.attributes);
        if (this.validateXML(valInfo, xmlValidateStream) && this.validateWSDL(wsdldoc = this.getDocument(uri, wsdlValidateStream), valInfo, wsdlns = this.getWSDLNamespace(wsdldoc))) {
            this.validateExtensionValidators(wsdldoc, valInfo, wsdlns);
        }
        return valInfo;
    }

    protected boolean validateXML(ControllerValidationInfo valInfo, InputStream inputStream) {
        IXMLValidator xmlValidator = AbstractXMLConformanceFactory.getInstance().getXMLValidator();
        xmlValidator.setURIResolver(this.uriResolver);
        xmlValidator.setFile(valInfo.getFileURI());
        if (xmlValidator instanceof DefaultXMLValidator) {
            ((DefaultXMLValidator)xmlValidator).setInputStream(inputStream);
        }
        xmlValidator.run();
        if (xmlValidator.hasErrors()) {
            List errors = xmlValidator.getErrors();
            Iterator errorsIter = errors.iterator();
            while (errorsIter.hasNext()) {
                IValidationMessage valMes = (IValidationMessage)errorsIter.next();
                if (valMes instanceof ValidationMessageImpl && valInfo instanceof ValidationInfoImpl) {
                    String errorKey = ((ValidationMessageImpl)valMes).getErrorKey();
                    Object[] messageArgs = ((ValidationMessageImpl)valMes).getMessageArguments();
                    ((ValidationInfoImpl)valInfo).addError(valMes.getMessage(), valMes.getLine(), valMes.getColumn(), valMes.getURI(), errorKey, messageArgs);
                    continue;
                }
                valInfo.addError(valMes.getMessage(), valMes.getLine(), valMes.getColumn(), valMes.getURI());
            }
            return false;
        }
        return true;
    }

    protected boolean validateXML(ControllerValidationInfo valInfo) {
        return this.validateXML(valInfo, null);
    }

    protected boolean validateWSDL(Document wsdldoc, ControllerValidationInfo valInfo, String wsdlNamespace) {
        WSDLValidatorDelegate[] wsdlVals = this.ver.queryValidatorRegistry(wsdlNamespace, ValidatorRegistry.WSDL_VALIDATOR);
        if (wsdlVals != null) {
            int i = 0;
            while (i < wsdlVals.length) {
                WSDLValidatorDelegate wsdlvaldel = wsdlVals[i];
                IWSDLValidator wsdlVal = wsdlvaldel.getValidator();
                if (wsdlVal != null) {
                    try {
                        wsdlVal.validate(wsdldoc, valInfo);
                    }
                    catch (ValidateWSDLException validateWSDLException) {
                        valInfo.addError(this.messagegenerator.getString("_ERROR_PROBLEM_WSDL_VALIDATOR", wsdlNamespace), 1, 1, valInfo.getFileURI());
                    }
                } else {
                    valInfo.addError(this.messagegenerator.getString("_ERROR_NO_WSDL_VALIDATOR", wsdlNamespace), 1, 1, valInfo.getFileURI());
                }
                ++i;
            }
        } else {
            valInfo.addError(this.messagegenerator.getString("_ERROR_NO_WSDL_VALIDATOR", wsdlNamespace), 1, 1, valInfo.getFileURI());
        }
        valInfo.completeWSDLValidation();
        return valInfo.isWSDLValid();
    }

    protected void validateExtensionValidators(Document wsdldoc, ControllerValidationInfo valInfo, String wsdlNamespace) {
        WSDLValidatorDelegate[] extVals = this.ver.queryValidatorRegistry(wsdlNamespace, ValidatorRegistry.EXT_VALIDATOR);
        if (extVals != null) {
            int numvals = extVals.length;
            int i = 0;
            while (i < numvals) {
                WSDLValidatorDelegate extvaldel = extVals[i];
                IWSDLValidator extval = extvaldel.getValidator();
                if (extval != null) {
                    try {
                        extval.validate(wsdldoc, valInfo);
                    }
                    catch (Throwable throwable) {
                        valInfo.addWarning(this.messagegenerator.getString("_ERROR_PROBLEM_EXT_VALIDATOR", extvaldel.getValidatorClassName(), wsdlNamespace), 1, 1, valInfo.getFileURI());
                    }
                }
                ++i;
            }
        }
    }

    public void setResourceBundle(ResourceBundle rb) {
        this.resourcebundle = rb;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourcebundle;
    }

    private Document getDocument(String uri, InputStream inputStream) {
        try {
            StandardParserConfiguration configuration = new StandardParserConfiguration(){

                protected XMLErrorReporter createErrorReporter() {
                    return new XMLErrorReporter(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void reportError(String domain, String key, Object[] arguments, short severity) throws XNIException {
                            boolean reportError = true;
                            if (key.equals("PrematureEOF")) {
                                reportError = false;
                            }
                            if (reportError) {
                                super.reportError(domain, key, arguments, severity);
                            }
                        }
                    };
                }
            };
            InputSource inputSource = null;
            inputSource = inputStream != null ? new InputSource(inputStream) : new InputSource(uri);
            LineNumberDOMParser builder = new LineNumberDOMParser((XMLParserConfiguration)configuration);
            builder.parse(inputSource);
            Document doc = builder.getDocument();
            return doc;
        }
        catch (Throwable t) {
            System.out.println(t);
            return null;
        }
    }

    private String getWSDLNamespace(Document doc) {
        Element definitions;
        String wsdlns = null;
        if (doc != null && (definitions = doc.getDocumentElement()).getLocalName().equals("definitions")) {
            wsdlns = definitions.getNamespaceURI();
        }
        return wsdlns;
    }

    private final String createStringForInputStream(InputStream inputStream) {
        StringBuffer fileString = new StringBuffer();
        try {
            InputStreamReader inputReader = new InputStreamReader(inputStream);
            BufferedReader reader = new BufferedReader(inputReader);
            char[] chars = new char[1024];
            int numberRead = reader.read(chars);
            while (numberRead != -1) {
                fileString.append(chars, 0, numberRead);
                numberRead = reader.read(chars);
            }
        }
        catch (Exception exception) {}
        return fileString.toString();
    }
}

