/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.ui.ant;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.DTDLocation;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.ResourceLocation;
import org.apache.tools.ant.types.XMLCatalog;
import org.eclipse.wst.wsdl.validation.internal.IValidationMessage;
import org.eclipse.wst.wsdl.validation.internal.IValidationReport;
import org.eclipse.wst.wsdl.validation.internal.WSDLValidator;
import org.eclipse.wst.wsdl.validation.internal.WSDLValidatorDelegate;
import org.eclipse.wst.wsdl.validation.internal.resolver.URIResolverDelegate;
import org.eclipse.wst.wsdl.validation.internal.ui.ant.ExtensionValidator;
import org.eclipse.wst.wsdl.validation.internal.ui.ant.URIResolver;
import org.eclipse.wst.wsdl.validation.internal.ui.ant.XMLCatalogImpl;
import org.eclipse.wst.wsdl.validation.internal.util.MessageGenerator;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.WSDL11ValidatorDelegate;

public class WSDLValidate
extends Task {
    protected final String UI_PROPERTIES = "validatewsdlui";
    protected final String VALIDATOR_PROPERTIES = "validatewsdl";
    protected final String _ERROR_NO_FILE_SPECIFIED = "_ERROR_NO_FILE_SPECIFIED";
    protected final String _UI_INFORMATION_DELIMITER = "_UI_INFORMATION_DELIMITER";
    protected final String _UI_ACTION_VALIDATING_FILE = "_UI_ACTION_VALIDATING_FILE";
    protected final String _UI_ERROR_MARKER = "_UI_ERROR_MARKER";
    protected final String _UI_WARNING_MARKER = "_UI_WARNING_MARKER";
    protected final String _UI_VALID = "_UI_VALID";
    protected final String _UI_INVALID = "_UI_INVALID";
    protected final String _EXC_UNABLE_TO_VALIDATE_FILE = "_EXC_UNABLE_TO_VALIDATE_FILE";
    protected final String _EXC_WSDL_FAIL_ON_ERROR = "_EXC_WSDL_FAIL_ON_ERROR";
    protected final String FILE_PROTOCOL = "file:///";
    protected List filesets = new ArrayList();
    protected String file = null;
    protected Path classpath;
    protected String xsdDirectory = null;
    protected boolean failOnError = false;
    protected XMLCatalog globalXMLCatalog = new XMLCatalog();
    protected List wsdl11validators = new ArrayList();
    protected List extvalidators = new ArrayList();
    protected List extURIResolvers = new ArrayList();
    static /* synthetic */ Class class$0;

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void setSchemaDir(String dir) {
        this.xsdDirectory = dir;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public FileSet createFileset() {
        FileSet fileset = new FileSet();
        this.filesets.add(fileset);
        return fileset;
    }

    public void addConfiguredXMLCatalog(XMLCatalog catalog) {
        this.globalXMLCatalog.addConfiguredXMLCatalog(catalog);
    }

    public void addConfiguredExtensionValidator(ExtensionValidator extVal) {
        this.extvalidators.add(extVal);
    }

    public void addConfiguredWSDL11Validator(ExtensionValidator extVal) {
        this.wsdl11validators.add(extVal);
    }

    public DTDLocation createEntity() {
        DTDLocation dtdLoc = new DTDLocation();
        this.globalXMLCatalog.addEntity((ResourceLocation)dtdLoc);
        return dtdLoc;
    }

    public DTDLocation createDTD() {
        DTDLocation dtdLoc = new DTDLocation();
        this.globalXMLCatalog.addEntity((ResourceLocation)dtdLoc);
        return dtdLoc;
    }

    public URIResolver createURIResolver() {
        URIResolver urires = new URIResolver();
        this.extURIResolvers.add(urires.getClassName());
        return urires;
    }

    protected List getFileList() {
        ArrayList<String> files = new ArrayList<String>();
        if (this.file != null) {
            try {
                URL url = new URL(this.file);
                files.add(url.toExternalForm());
            }
            catch (Exception exception) {
                String absFile;
                File theFile = new File(this.file);
                if (!theFile.isAbsolute()) {
                    theFile = new File(this.getProject().getBaseDir(), this.file);
                }
                if (!(absFile = theFile.toString()).startsWith("file:")) {
                    absFile = "file:///" + absFile;
                }
                absFile = absFile.replace('\\', '/');
                files.add(absFile);
            }
        }
        Iterator fsIter = this.filesets.iterator();
        while (fsIter.hasNext()) {
            FileSet fileset = (FileSet)fsIter.next();
            DirectoryScanner ds = fileset.getDirectoryScanner(fileset.getProject());
            String basedir = String.valueOf(ds.getBasedir().toString()) + File.separator;
            String[] filelist = ds.getIncludedFiles();
            int numFiles = filelist.length;
            if (files == null || numFiles <= 0) continue;
            int i = 0;
            while (i < numFiles) {
                String absFile = "file:///" + basedir + filelist[i];
                absFile = absFile.replace('\\', '/');
                files.add(absFile);
                ++i;
            }
        }
        return files;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        MessageGenerator messGen = null;
        try {
            ResourceBundle uiRB = ResourceBundle.getBundle("validatewsdlui");
            messGen = new MessageGenerator(uiRB);
        }
        catch (MissingResourceException e) {
            throw new BuildException("Unable to open resource bundle. " + e);
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.wst.wsdl.validation.internal.ui.ant.XMLCatalogImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        org.eclipse.wst.wsdl.validation.internal.xml.XMLCatalog.setExtensionXMLCatalog(clazz.getName(), ((Object)((Object)this)).getClass().getClassLoader());
        XMLCatalogImpl xmlCatalog = (XMLCatalogImpl)org.eclipse.wst.wsdl.validation.internal.xml.XMLCatalog.getExtensionCatalogInstance();
        xmlCatalog.addXMLCatalog(this.globalXMLCatalog);
        WSDLValidator wsdlValidator = new WSDLValidator();
        Iterator resolversIter = this.extURIResolvers.iterator();
        while (true) {
            if (!resolversIter.hasNext()) break;
            String resolverClass = (String)resolversIter.next();
            wsdlValidator.addURIResolver(new URIResolverDelegate(resolverClass, ((Object)((Object)this)).getClass().getClassLoader()).getURIResolver());
        }
        List files = this.getFileList();
        Iterator wsdl11extIter = this.wsdl11validators.iterator();
        while (true) {
            if (!wsdl11extIter.hasNext()) break;
            ExtensionValidator extVal = (ExtensionValidator)wsdl11extIter.next();
            WSDL11ValidatorDelegate delegate = new WSDL11ValidatorDelegate(extVal.getClassName(), extVal.getResourceBundle());
            wsdlValidator.registerWSDL11Validator(extVal.getNamespace(), delegate);
        }
        Iterator extIter = this.extvalidators.iterator();
        while (true) {
            if (!extIter.hasNext()) {
                if (files != null && !files.isEmpty()) break;
                System.err.println(messGen.getString("_ERROR_NO_FILE_SPECIFIED"));
                return;
            }
            ExtensionValidator extVal = (ExtensionValidator)extIter.next();
            WSDLValidatorDelegate delegate = new WSDLValidatorDelegate(extVal.getClassName(), extVal.getResourceBundle());
            wsdlValidator.registerWSDLExtensionValidator(extVal.getNamespace(), delegate);
        }
        if (this.xsdDirectory != null) {
            org.eclipse.wst.wsdl.validation.internal.xml.XMLCatalog.addSchemaDir(this.xsdDirectory);
        }
        Iterator iFiles = files.iterator();
        String infoDelim = messGen.getString("_UI_INFORMATION_DELIMITER");
        String valid = messGen.getString("_UI_VALID");
        String invalid = messGen.getString("_UI_INVALID");
        String errormarker = messGen.getString("_UI_ERROR_MARKER");
        String warningmarker = messGen.getString("_UI_WARNING_MARKER");
        StringBuffer result = null;
        boolean notvalid = true;
        while (true) {
            Object var19_21;
            if (!iFiles.hasNext()) {
                org.eclipse.wst.wsdl.validation.internal.xml.XMLCatalog.reset();
                return;
            }
            result = new StringBuffer();
            notvalid = false;
            String filename = (String)iFiles.next();
            try {
                try {
                    result.append(infoDelim).append("\n");
                    result.append(messGen.getString("_UI_ACTION_VALIDATING_FILE", filename)).append(" - ");
                    IValidationReport valReport = wsdlValidator.validate(filename);
                    IValidationMessage[] messages = valReport.getValidationMessages();
                    if (!valReport.hasErrors()) {
                        result.append(valid);
                    } else {
                        result.append(invalid);
                        notvalid = true;
                    }
                    result.append("\n").append(infoDelim).append("\n");
                    result.append(this.reportMessages(messages, errormarker, warningmarker));
                    System.out.println(result.toString());
                }
                catch (Exception e) {
                    System.err.println(messGen.getString("_EXC_UNABLE_TO_VALIDATE_FILE", filename, e));
                }
            }
            catch (Throwable throwable) {
                var19_21 = null;
                if (notvalid && this.failOnError) {
                    throw new BuildException(messGen.getString("_EXC_WSDL_FAIL_ON_ERROR"));
                }
                throw throwable;
            }
            {
                var19_21 = null;
                if (!notvalid || !this.failOnError) continue;
            }
            break;
        }
        throw new BuildException(messGen.getString("_EXC_WSDL_FAIL_ON_ERROR"));
    }

    protected String reportMessages(IValidationMessage[] messages, String errormarker, String warningmarker) {
        StringBuffer returnBuffer = new StringBuffer();
        if (messages == null) {
            return returnBuffer.toString();
        }
        String prefix = null;
        int numMessages = messages.length;
        int i = 0;
        while (i < numMessages) {
            IValidationMessage message = messages[i];
            prefix = message.getSeverity() == 0 ? errormarker : (message.getSeverity() == 1 ? warningmarker : "");
            prefix = message.getSeverity() == 0 ? errormarker : (message.getSeverity() == 1 ? warningmarker : "");
            prefix = message.getSeverity() == 0 ? errormarker : (message.getSeverity() == 1 ? warningmarker : "");
            prefix = message.getSeverity() == 0 ? errormarker : (message.getSeverity() == 1 ? warningmarker : "");
            returnBuffer.append(prefix).append(" ").append(message.getLine()).append(":").append(message.getColumn()).append(":").append(message.getMessage()).append("\n");
            ++i;
        }
        return returnBuffer.toString();
    }
}

