/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.ui.text;

import com.ibm.wsdl.util.StringUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.wst.wsdl.validation.internal.IValidationMessage;
import org.eclipse.wst.wsdl.validation.internal.IValidationReport;
import org.eclipse.wst.wsdl.validation.internal.WSDLValidator;
import org.eclipse.wst.wsdl.validation.internal.WSDLValidatorDelegate;
import org.eclipse.wst.wsdl.validation.internal.resolver.IExtensibleURIResolver;
import org.eclipse.wst.wsdl.validation.internal.resolver.URIResolverDelegate;
import org.eclipse.wst.wsdl.validation.internal.util.MessageGenerator;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.WSDL11ValidatorDelegate;
import org.eclipse.wst.wsdl.validation.internal.xml.XMLCatalog;
import org.eclipse.wst.wsdl.validation.internal.xml.XMLCatalogEntityHolder;

public class WSDLValidate {
    private final String FILE_PREFIX = "file:///";
    private static final String VALIDATOR_PROPERTIES = "validatewsdl";
    private static final String UI_PROPERTIES = "validatewsdlui";
    private static final String _ERROR_WRONG_ARGUMENTS = "_ERROR_WRONG_ARGUMENTS";
    private static final String _UI_INFORMATION_DELIMITER = "_UI_INFORMATION_DELIMITER";
    private static final String _UI_ACTION_VALIDATING_FILE = "_UI_ACTION_VALIDATING_FILE";
    private static final String _UI_VALID = "_UI_VALID";
    private static final String _UI_INVALID = "_UI_INVALID";
    private static final String _UI_ERROR_MARKER = "_UI_ERROR_MARKER";
    private static final String _UI_WARNING_MARKER = "_UI_WARNING_MARKER";
    private static final String _ERROR_UNABLE_TO_LOAD_EXT_VALIDATOR = "_ERROR_UNABLE_TO_LOAD_EXT_VALIDATOR";
    private static final String PARAM_WSDL11VAL = "-wsdl11v";
    private static final String PARAM_EXTVAL = "-extv";
    private static final String PARAM_SCHEMADIR = "-schemaDir";
    private static final String PARAM_SCHEMA = "-schema";
    private static final String PARAM_URIRESOLVER = "-uriresolver";
    private static final String STRING_EMPTY = "";
    private static final String STRING_SPACE = " ";
    private static final String STRING_DASH = "-";
    protected ResourceBundle resourceBundle;
    protected List errors = null;
    protected List warnings = null;
    protected WSDLValidator wsdlValidator = new WSDLValidator();

    public void addURIResolver(IExtensibleURIResolver uriResolver) {
        this.wsdlValidator.addURIResolver(uriResolver);
    }

    protected IValidationReport validateFile(String directory, String filename, ResourceBundle validatorRB) throws Exception {
        String filelocation = null;
        try {
            URL test = StringUtils.getURL((URL)new URL("file:///" + directory + "/"), (String)filename);
            filelocation = test.toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            throw new Exception("Unable to resolve WSDL file location");
        }
        IValidationReport valReport = this.wsdlValidator.validate(filelocation);
        return valReport;
    }

    protected String getMessages(IValidationMessage[] messages, String errormarker, String warningmarker) {
        StringBuffer outputBuffer = new StringBuffer();
        if (messages != null) {
            int numMessages = messages.length;
            String marker = null;
            int i = 0;
            while (i < numMessages) {
                IValidationMessage message = messages[i];
                int severity = message.getSeverity();
                marker = severity == 0 ? errormarker : (severity == 1 ? warningmarker : STRING_EMPTY);
                outputBuffer.append(marker).append(STRING_SPACE).append(message.getLine()).append(":").append(message.getColumn()).append(STRING_SPACE).append(message.getMessage()).append("\n");
                ++i;
            }
        }
        return outputBuffer.toString();
    }

    public static void main(String[] args) {
        Vector<String> wsdlFiles = new Vector<String>();
        MessageGenerator messGen = null;
        ResourceBundle validatorRB = null;
        try {
            ResourceBundle uiRB = ResourceBundle.getBundle(UI_PROPERTIES);
            messGen = new MessageGenerator(uiRB);
            validatorRB = ResourceBundle.getBundle(VALIDATOR_PROPERTIES);
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("Validation failed: Unable to load the properties file.");
            return;
        }
        if (args.length < 1) {
            System.out.println(messGen.getString(_ERROR_WRONG_ARGUMENTS));
            return;
        }
        int argslength = args.length;
        WSDLValidate wsdlValidator = new WSDLValidate();
        int i = 0;
        while (i < argslength) {
            String param = args[i];
            if (param.equalsIgnoreCase(PARAM_WSDL11VAL) || param.equalsIgnoreCase(PARAM_EXTVAL)) {
                String validatorClass;
                if (!(validatorClass = args[++i]).startsWith(STRING_DASH)) {
                    String namespace;
                    if (!(namespace = args[++i]).startsWith(STRING_DASH)) {
                        Object delegate;
                        String propertiesFile;
                        if ((propertiesFile = args[++i]).startsWith(STRING_DASH)) {
                            propertiesFile = null;
                            --i;
                        }
                        if (param.equalsIgnoreCase(PARAM_WSDL11VAL)) {
                            delegate = new WSDL11ValidatorDelegate(validatorClass, propertiesFile);
                            wsdlValidator.wsdlValidator.registerWSDL11Validator(namespace, (WSDL11ValidatorDelegate)delegate);
                        } else if (param.equalsIgnoreCase(PARAM_EXTVAL)) {
                            delegate = new WSDLValidatorDelegate(validatorClass, propertiesFile);
                            wsdlValidator.wsdlValidator.registerWSDLExtensionValidator(namespace, (WSDLValidatorDelegate)delegate);
                        }
                    } else {
                        namespace = null;
                        --i;
                    }
                } else {
                    validatorClass = null;
                    --i;
                }
            } else if (param.equalsIgnoreCase(PARAM_SCHEMADIR)) {
                String xsdDir = args[++i];
                XMLCatalog.addSchemaDir(xsdDir);
            } else if (param.equalsIgnoreCase(PARAM_SCHEMA)) {
                String publicid = args[++i];
                String systemid = args[++i];
                XMLCatalog.addEntity(new XMLCatalogEntityHolder(publicid, systemid));
            } else if (param.equalsIgnoreCase(PARAM_URIRESOLVER)) {
                String resolverClass = args[++i];
                wsdlValidator.addURIResolver(new URIResolverDelegate(resolverClass, null).getURIResolver());
            } else if (!param.startsWith(STRING_DASH)) {
                wsdlFiles.add(param);
            }
            ++i;
        }
        StringBuffer outputBuffer = null;
        String infoDelim = messGen.getString(_UI_INFORMATION_DELIMITER);
        String valid = messGen.getString(_UI_VALID);
        String invalid = messGen.getString(_UI_INVALID);
        String errormarker = messGen.getString(_UI_ERROR_MARKER);
        String warningmarker = messGen.getString(_UI_WARNING_MARKER);
        Iterator filesIter = wsdlFiles.iterator();
        while (filesIter.hasNext()) {
            outputBuffer = new StringBuffer();
            String wsdlFile = (String)filesIter.next();
            try {
                IValidationReport valReport = wsdlValidator.validateFile(System.getProperty("user.dir"), wsdlFile, validatorRB);
                outputBuffer.append(infoDelim).append("\n");
                outputBuffer.append(messGen.getString(_UI_ACTION_VALIDATING_FILE, wsdlFile)).append(" - ");
                if (!valReport.hasErrors()) {
                    outputBuffer.append(valid);
                } else {
                    outputBuffer.append(invalid);
                }
                outputBuffer.append("\n").append(infoDelim).append("\n");
                outputBuffer.append(wsdlValidator.getMessages(valReport.getValidationMessages(), errormarker, warningmarker));
                System.out.println(outputBuffer.toString());
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }
}

