/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.wsdl11.xsd;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.apache.xerces.parsers.XMLGrammarPreparser;
import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.grammars.XSGrammar;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xs.XSModel;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.xsd.InlineXSDResolver;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.xsd.ValidateErrorHandler;

public class XSDValidator {
    protected final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected final String CONTINUE_AFTER_FATAL_ERROR_ID = "http://apache.org/xml/features/continue-after-fatal-error";
    protected final String HONOUR_ALL_SCHEMA_LOCATIONS_FEATURE_ID = "http://apache.org/xml/features/honour-all-schemaLocations";
    protected final String FILE_PREFIX = "file:";
    protected final String XMLNS = "xmlns";
    protected final String TARGETNAMESPACE = "targetNamespace";
    protected final String NAMESPACE = "namespace";
    protected final String IMPORT = "import";
    protected final String SCHEMALOCATION = "schemaLocation";
    protected final String TYPE = "type";
    protected final String[] ignoreNamespaces = new String[]{"http://www.w3.org/2001/XMLSchema", "http://www.w3.org/1999/XMLSchema"};
    protected XSModel xsModel = null;
    protected boolean isValidXSD = false;
    protected List errors = null;
    protected String filelocation;

    public void validateInlineSchema(String schema, String targetNamespace, String fileloc) {
        this.validateInlineSchema(schema, targetNamespace, fileloc, null, null);
    }

    public void validateInlineSchema(String schema, String targetNamespace, String fileloc, XMLEntityResolver entityResolverChain, XMLEntityResolver inlineSchemaEntityResolver) {
        this.filelocation = fileloc;
        this.validateXSD(schema, true, entityResolverChain, targetNamespace, inlineSchemaEntityResolver);
    }

    public void validate(String uri, XMLEntityResolver entityResolver) {
        this.validateXSD(uri, false, entityResolver, null, null);
    }

    protected void validateXSD(String schema, boolean inlineXSD, XMLEntityResolver entityResolver, String targetNamespace, XMLEntityResolver inlineSchemaEntityResolver) {
        ValidateErrorHandler errorHandler = new ValidateErrorHandler();
        errorHandler.getErrorMessages().clear();
        try {
            XMLGrammarPreparser grammarPreparser = new XMLGrammarPreparser();
            grammarPreparser.registerPreparser("http://www.w3.org/2001/XMLSchema", null);
            XMLGrammarPoolImpl grammarPool = new XMLGrammarPoolImpl();
            grammarPreparser.setGrammarPool((XMLGrammarPool)grammarPool);
            grammarPreparser.setErrorHandler((XMLErrorHandler)errorHandler);
            if (entityResolver != null) {
                grammarPreparser.setEntityResolver(entityResolver);
            }
            try {
                XMLInputSource is = null;
                if (inlineXSD) {
                    StringReader reader = new StringReader(schema);
                    is = new XMLInputSource(null, this.filelocation, this.filelocation, (Reader)reader, null);
                    ((InlineXSDResolver)inlineSchemaEntityResolver).addReferringSchema(is, targetNamespace);
                } else {
                    is = new XMLInputSource(null, schema, schema);
                }
                grammarPreparser.getLoader("http://www.w3.org/2001/XMLSchema");
                XSGrammar grammar = (XSGrammar)grammarPreparser.preparseGrammar("http://www.w3.org/2001/XMLSchema", is);
                this.xsModel = grammar.toXSModel();
            }
            catch (Exception e) {
                System.out.println(e);
            }
            this.errors = errorHandler.getErrorMessages();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        if (this.errors.isEmpty()) {
            this.isValidXSD = true;
        }
    }

    public XSModel getXSModel() {
        return this.xsModel;
    }

    public boolean isValid() {
        return this.isValidXSD;
    }

    public List getErrors() {
        return this.errors;
    }
}

