/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import org.eclipse.compare.CompareViewerPane;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.SWTUtils;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.synchronize.SynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizePage;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizePageSite;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPageBookViewPage;

public final class ParticipantPagePane {
    private ISynchronizeParticipant participant;
    private ISynchronizePageConfiguration pageConfiguration;
    private Image titleImage;
    private Shell shell;
    private boolean isModal;
    private CompareViewerPane fEditionPane;
    private Viewer viewer;
    private IActionBars actionBars;
    private IPageBookViewPage fPage;

    public ParticipantPagePane(Shell shell, boolean isModal, ISynchronizePageConfiguration pageConfiguration, ISynchronizeParticipant participant) {
        this.isModal = isModal;
        this.shell = shell;
        this.participant = participant;
        this.pageConfiguration = pageConfiguration;
    }

    public void dispose() {
        if (this.titleImage != null) {
            this.titleImage.dispose();
        }
        if (this.fPage != null) {
            this.fPage.dispose();
        }
    }

    public Image getTitleImage() {
        if (this.titleImage == null) {
            this.titleImage = this.participant.getImageDescriptor().createImage();
        }
        return this.titleImage;
    }

    public String getTitle() {
        return this.participant.getName();
    }

    public Control createPartControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        top.setLayout((Layout)layout);
        this.shell = parent.getShell();
        this.fEditionPane = new CompareViewerPane(top, 0x800800);
        this.fEditionPane.setText(TeamUIMessages.ParticipantPageSaveablePart_0);
        this.fEditionPane.setLayoutData((Object)SWTUtils.createHVFillGridData());
        this.fPage = this.participant.createPage(this.pageConfiguration);
        ((SynchronizePageConfiguration)this.pageConfiguration).setSite(new CompareViewerPaneSite());
        ToolBarManager tbm = CompareViewerPane.getToolBarManager((Composite)this.fEditionPane);
        this.createActionBars((IToolBarManager)tbm);
        try {
            ((ISynchronizePage)this.fPage).init(this.pageConfiguration.getSite());
        }
        catch (PartInitException e1) {
            TeamUIPlugin.log(4, TeamUIMessages.ParticipantPagePane_0, e1);
        }
        this.fPage.createControl((Composite)this.fEditionPane);
        this.fPage.setActionBars(this.getActionBars());
        this.fEditionPane.setContent(this.fPage.getControl());
        tbm.update(true);
        return top;
    }

    private void createActionBars(final IToolBarManager toolbar) {
        if (this.actionBars == null) {
            this.actionBars = new IActionBars(){

                public void clearGlobalActionHandlers() {
                }

                public IAction getGlobalActionHandler(String actionId) {
                    return null;
                }

                public IMenuManager getMenuManager() {
                    return null;
                }

                public IStatusLineManager getStatusLineManager() {
                    return null;
                }

                public IToolBarManager getToolBarManager() {
                    return toolbar;
                }

                public void setGlobalActionHandler(String actionId, IAction action) {
                }

                public void updateActionBars() {
                }
            };
        }
    }

    private IActionBars getActionBars() {
        return this.actionBars;
    }

    public ISynchronizePageConfiguration getPageConfiguration() {
        return this.pageConfiguration;
    }

    public ISynchronizeParticipant getParticipant() {
        return this.participant;
    }

    class CompareViewerPaneSite
    implements ISynchronizePageSite {
        ISelectionProvider selectionProvider;

        CompareViewerPaneSite() {
        }

        public IWorkbenchPage getPage() {
            return null;
        }

        public ISelectionProvider getSelectionProvider() {
            if (this.selectionProvider != null) {
                return this.selectionProvider;
            }
            return ParticipantPagePane.this.viewer;
        }

        public Shell getShell() {
            return ParticipantPagePane.this.shell;
        }

        public IWorkbenchWindow getWorkbenchWindow() {
            return null;
        }

        public void setSelectionProvider(ISelectionProvider provider) {
            this.selectionProvider = provider;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public IWorkbenchSite getWorkbenchSite() {
            return null;
        }

        public IWorkbenchPart getPart() {
            return null;
        }

        public IKeyBindingService getKeyBindingService() {
            return null;
        }

        public void setFocus() {
        }

        public IDialogSettings getPageSettings() {
            return null;
        }

        public IActionBars getActionBars() {
            return ParticipantPagePane.this.getActionBars();
        }

        public boolean isModal() {
            return ParticipantPagePane.this.isModal;
        }
    }
}

