/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.wst.common.componentcore.internal.ComponentcorePackage;
import org.eclipse.wst.common.componentcore.internal.ModuleMigratorManager;
import org.eclipse.wst.common.componentcore.internal.ModulecorePlugin;
import org.eclipse.wst.common.componentcore.internal.ProjectComponents;
import org.eclipse.wst.common.componentcore.internal.impl.WTPModulesResource;
import org.eclipse.wst.common.componentcore.internal.impl.WTPModulesResourceFactory;
import org.eclipse.wst.common.internal.emf.resource.ReferencedResource;
import org.eclipse.wst.common.internal.emfworkbench.EMFWorkbenchContext;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModel;
import org.osgi.framework.Bundle;

public class ModuleStructuralModel
extends EditModel
implements IAdaptable {
    public static final String MODULE_CORE_ID = "moduleCoreId";
    private boolean multiComps;

    public ModuleStructuralModel(String editModelID, EMFWorkbenchContext context, boolean readOnly) {
        super(editModelID, context, readOnly);
    }

    protected void release(ReferencedResource aResource) {
        if (this.isReadOnly() && aResource.getReadCount() != 0) {
            aResource.releaseFromRead();
        } else {
            aResource.releaseFromWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeResource(Resource aResource) {
        if (aResource != null) {
            Resource resource = aResource;
            synchronized (resource) {
                aResource.eAdapters().remove((Object)this.resourceAdapter);
                return this.getResources().remove(aResource);
            }
        }
        return false;
    }

    public synchronized EObject getPrimaryRootObject() {
        try {
            this.prepareProjectModulesIfNecessary();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        EObject modelRoot = super.getPrimaryRootObject();
        return modelRoot;
    }

    public WTPModulesResource makeWTPModulesResource() {
        return (WTPModulesResource)this.createResource(WTPModulesResourceFactory.WTP_MODULES_URI_OBJ);
    }

    public Resource prepareProjectModulesIfNecessary() throws CoreException {
        ModuleMigratorManager manager = ModuleMigratorManager.getManager();
        Object res = (XMIResource)this.getPrimaryResource();
        if (this.resNeedsMigrating((XMIResource)res)) {
            try {
                if (!manager.isMigrating()) {
                    manager.migrateOldMetaData(this.getProject(), this.multiComps);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            res = (XMIResource)this.getPrimaryResource();
        }
        if (res == null) {
            res = this.makeWTPModulesResource();
        }
        try {
            this.addProjectModulesIfNecessary((XMIResource)res);
        }
        catch (IOException e) {
            Platform.getLog((Bundle)ModulecorePlugin.getDefault().getBundle()).log((IStatus)new Status(4, "org.eclipse.wst.common.modulecore", 4, e.getMessage(), (Throwable)e));
        }
        return res;
    }

    private boolean resNeedsMigrating(XMIResource res) throws CoreException {
        ProjectComponents components;
        boolean needsMigrating;
        this.multiComps = false;
        if (this.project == null) {
            return false;
        }
        boolean bl = needsMigrating = !this.project.hasNature("org.eclipse.wst.common.project.facet.core.nature") || res != null && !res.isLoaded();
        if (!needsMigrating && res != null && ((WTPModulesResource)res).getRootObject() != null && (components = (ProjectComponents)((WTPModulesResource)res).getRootObject()).getComponents() != null) {
            this.multiComps = components.getComponents().size() > 1;
            return this.multiComps;
        }
        return needsMigrating;
    }

    public Object getAdapter(Class anAdapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, anAdapter);
    }

    protected void addProjectModulesIfNecessary(XMIResource aResource) throws IOException {
        if (aResource != null && aResource.getContents().isEmpty()) {
            ProjectComponents projectModules = ComponentcorePackage.eINSTANCE.getComponentcoreFactory().createProjectComponents();
            projectModules.setProjectName(this.project.getName());
            aResource.getContents().add((Object)projectModules);
            aResource.setID((EObject)projectModules, MODULE_CORE_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Resource getAndLoadLocalResource(URI aUri) {
        Resource resource = this.getLocalResource(aUri);
        if (resource != null) {
            Resource resource2 = resource;
            synchronized (resource2) {
                if (!resource.isLoaded()) {
                    try {
                        resource.load(Collections.EMPTY_MAP);
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return resource;
    }
}

