/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jem.util.emf.workbench.ResourceSetWorkbenchSynchronizer;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.internal.impl.PlatformURLModuleConnection;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.internal.emfworkbench.CompatibilityWorkbenchURIConverterImpl;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public class ComponentCoreURIConverter
extends CompatibilityWorkbenchURIConverterImpl {
    private IProject containingProject;
    private IFolder archiveRoot;

    public ComponentCoreURIConverter() {
    }

    public ComponentCoreURIConverter(IProject aContainingProject) {
        this.containingProject = aContainingProject;
    }

    public ComponentCoreURIConverter(IProject aContainingProject, ResourceSetWorkbenchSynchronizer aSynchronizer) {
        super((IContainer)aContainingProject, aSynchronizer);
        this.containingProject = aContainingProject;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IVirtualComponent findComponent(IResource res) {
        block8: {
            StructureEdit moduleCore = null;
            WorkbenchComponent module = null;
            try {
                try {
                    moduleCore = StructureEdit.getStructureEditForRead(this.containingProject);
                    ComponentResource[] resources = moduleCore.findResourcesBySourcePath(res.getFullPath(), 2);
                    int i = 0;
                    while (i < resources.length && (module = resources[i].getComponent()) == null) {
                        ++i;
                    }
                }
                catch (UnresolveableURIException unresolveableURIException) {}
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (moduleCore != null) {
                    moduleCore.dispose();
                }
                throw throwable;
            }
            {
                Object var6_8 = null;
                if (moduleCore != null) {
                    moduleCore.dispose();
                }
                if (module == null) break block8;
            }
            return ComponentCore.createComponent(this.containingProject);
        }
        return null;
    }

    public URI normalize(URI aURI) {
        URI normalizedURI = null;
        if ("module".equals(aURI.scheme())) {
            try {
                normalizedURI = PlatformURLModuleConnection.resolve(aURI);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        } else {
            normalizedURI = super.normalize(aURI);
        }
        if (normalizedURI == null) {
            normalizedURI = this.newPlatformURI(aURI);
        } else if (normalizedURI.scheme() == null || normalizedURI.scheme().length() == 0) {
            normalizedURI = URI.createPlatformResourceURI((String)this.getInputContainer().getFullPath().append(normalizedURI.toString()).toString());
        }
        return normalizedURI;
    }

    private URI newPlatformURI(URI aNewURI) {
        try {
            StructureEdit.getDeployedName(aNewURI);
            IVirtualComponent component = ComponentCore.createComponent(this.containingProject);
            URI deployPathSegment = ModuleURIUtil.trimToDeployPathSegment(aNewURI);
            IVirtualFolder rootFolder = component.getRootFolder();
            IVirtualFile newFile = rootFolder.getFile((IPath)new Path(deployPathSegment.path()));
            return URI.createPlatformResourceURI((String)newFile.getWorkspaceRelativePath().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public URI deNormalize(URI uri) {
        IFile aFile;
        if (WorkbenchResourceHelperBase.isPlatformResourceURI((URI)uri) && (aFile = WorkbenchResourceHelper.getPlatformFile((URI)uri)) != null) {
            IVirtualComponent component = this.findComponent((IResource)aFile);
            if (component != null) {
                IProject fileProject = aFile.getProject();
                if (this.resourceSetSynchronizer.getProject() == fileProject) {
                    return this.getArchiveRelativeURI(aFile, component.getRootFolder().getUnderlyingFolder());
                }
            } else {
                return super.deNormalize(uri);
            }
        }
        return uri;
    }

    protected URI getContainerRelativeURI(IFile aFile) {
        IPath path = WorkbenchResourceHelperBase.getPathFromContainers((List)this.inputContainers, (IPath)aFile.getFullPath());
        if (path != null) {
            return URI.createURI((String)path.toString());
        }
        return null;
    }

    protected URI getArchiveRelativeURI(IFile aFile, IContainer aContainer) {
        IPath path = WorkbenchResourceHelperBase.getPathFromContainers(Collections.singletonList(aContainer), (IPath)aFile.getFullPath());
        if (path != null) {
            return URI.createURI((String)path.toString());
        }
        return null;
    }
}

