/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.operation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class CreateReferenceComponentsOp
extends AbstractDataModelOperation {
    public CreateReferenceComponentsOp(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.addReferencedComponents(monitor);
        this.addProjectReferences();
        return OK_STATUS;
    }

    protected void addProjectReferences() {
        IVirtualComponent sourceComp = (IVirtualComponent)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT");
        List modList = (List)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
        ArrayList<IProject> targetprojectList = new ArrayList<IProject>();
        int i = 0;
        while (i < modList.size()) {
            IVirtualComponent IVirtualComponent2 = (IVirtualComponent)modList.get(i);
            IProject targetProject = IVirtualComponent2.getProject();
            targetprojectList.add(targetProject);
            ++i;
        }
        try {
            ProjectUtilities.addReferenceProjects((IProject)sourceComp.getProject(), targetprojectList);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected void addReferencedComponents(IProgressMonitor monitor) {
        IVirtualComponent sourceComp = (IVirtualComponent)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT");
        ArrayList<IVirtualReference> vlist = new ArrayList<IVirtualReference>();
        List modList = (List)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
        int i = 0;
        while (i < modList.size()) {
            IVirtualComponent comp = (IVirtualComponent)modList.get(i);
            if (!this.srcComponentContainsReference(sourceComp, comp)) {
                IVirtualReference ref = ComponentCore.createReference(sourceComp, comp);
                String deployPath = this.model.getStringProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH");
                if (deployPath != null && deployPath.length() > 0) {
                    ref.setRuntimePath((IPath)new Path(deployPath));
                }
                vlist.add(ref);
            }
            ++i;
        }
        IVirtualReference[] refs = vlist.toArray(new IVirtualReference[vlist.size()]);
        sourceComp.addReferences(refs);
    }

    private boolean srcComponentContainsReference(IVirtualComponent sourceComp, IVirtualComponent comp) {
        IVirtualReference[] existingReferences = sourceComp.getReferences();
        int i = 0;
        while (i < existingReferences.length) {
            if (existingReferences[i].getReferencedComponent().getProject().equals((Object)comp.getProject())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }
}

