/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.text.Position;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;
import org.eclipse.wst.sse.ui.internal.StructuredMarkerAnnotation;

public class StructuredResourceMarkerAnnotationModel
extends ResourceMarkerAnnotationModel {
    public static final String SECONDARY_ID_KEY = "org.eclipse.wst.sse.ui.extensions.breakpoint.path";
    protected IResource fMarkerResource;
    protected String fSecondaryMarkerAttributeValue;

    public StructuredResourceMarkerAnnotationModel(IResource resource) {
        super(resource);
        this.fMarkerResource = resource;
    }

    public StructuredResourceMarkerAnnotationModel(IResource resource, String secondaryID) {
        super(resource);
        this.fMarkerResource = resource;
        this.fSecondaryMarkerAttributeValue = secondaryID;
    }

    protected MarkerAnnotation createMarkerAnnotation(IMarker marker) {
        if (MarkerUtilities.isMarkerType((IMarker)marker, (String)IBreakpoint.BREAKPOINT_MARKER) || MarkerUtilities.isMarkerType((IMarker)marker, (String)"org.eclipse.core.resources.problemmarker")) {
            return new StructuredMarkerAnnotation(marker);
        }
        return super.createMarkerAnnotation(marker);
    }

    public Position getMarkerPosition(IMarker marker) {
        Position pos = super.getMarkerPosition(marker);
        if (pos == null || pos.getLength() == 0) {
            pos = this.createPositionFromMarker(marker);
        }
        return pos;
    }

    protected boolean isAcceptable(IMarker marker) {
        try {
            Object attr = marker.getAttribute("hidden");
            if (attr != null && ((Boolean)attr).equals(Boolean.TRUE)) {
                return false;
            }
        }
        catch (CoreException coreException) {}
        if (this.fSecondaryMarkerAttributeValue == null) {
            return super.isAcceptable(marker);
        }
        String markerSecondaryMarkerAttributeValue = marker.getAttribute(SECONDARY_ID_KEY, "");
        boolean isSameFile = this.fSecondaryMarkerAttributeValue.equalsIgnoreCase(markerSecondaryMarkerAttributeValue);
        return super.isAcceptable(marker) && isSameFile;
    }
}

