/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.selection;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.eclipse.wst.sse.ui.internal.selection.SelectionHistory;

public abstract class StructuredSelectActionDelegate
implements IEditorActionDelegate,
IActionDelegate2,
IViewActionDelegate {
    private IEditorPart fEditor;
    private SelectionHistory fHistory;
    static /* synthetic */ Class class$0;

    public void dispose() {
        this.fEditor = null;
        this.fHistory = null;
    }

    public void init(IViewPart view) {
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IAction action) {
        if (!(this.fEditor instanceof ITextEditor)) return;
        ITextEditor textEditor = (ITextEditor)this.fEditor;
        ISelection selection = textEditor.getSelectionProvider().getSelection();
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        if (!(selection instanceof ITextSelection)) return;
        if (document == null) return;
        ITextSelection textSelection = (ITextSelection)selection;
        if (textSelection.getLength() >= document.getLength()) return;
        IndexedRegion cursorIndexedRegion = this.getCursorIndexedRegion(document, textSelection);
        Region newSelectionRegion = this.getNewSelectionRegion(cursorIndexedRegion, textSelection);
        if (newSelectionRegion == null) return;
        this.fHistory.remember((IRegion)new Region(textSelection.getOffset(), textSelection.getLength()));
        try {
            this.fHistory.ignoreSelectionChanges();
            textEditor.selectAndReveal(newSelectionRegion.getOffset(), newSelectionRegion.getLength());
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.fHistory.listenToSelectionChanges();
            throw throwable;
        }
        {
            Object var8_10 = null;
            this.fHistory.listenToSelectionChanges();
            return;
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.fEditor = targetEditor;
        if (this.fEditor != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.sse.ui.internal.selection.SelectionHistory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.fHistory = (SelectionHistory)this.fEditor.getAdapter((Class)clazz);
        } else {
            this.fHistory = null;
        }
    }

    protected abstract IndexedRegion getCursorIndexedRegion(IDocument var1, ITextSelection var2);

    protected abstract Region getNewSelectionRegion(IndexedRegion var1, ITextSelection var2);

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IndexedRegion getIndexedRegion(IDocument document, int offset) {
        IndexedRegion indexedRegion = null;
        int lastOffset = offset;
        IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForRead(document);
        if (model == null) return indexedRegion;
        try {
            indexedRegion = model.getIndexedRegion(lastOffset);
            while (indexedRegion == null && lastOffset >= 0) {
                indexedRegion = model.getIndexedRegion(--lastOffset);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            model.releaseFromRead();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        model.releaseFromRead();
        return indexedRegion;
    }
}

