/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.util;

import java.util.StringTokenizer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class EditorUtility {
    private static String appendModifierString(String modifierString, int modifier) {
        if (modifierString == null) {
            modifierString = "";
        }
        String newModifierString = Action.findModifierString((int)modifier);
        if (modifierString.length() == 0) {
            return newModifierString;
        }
        return String.valueOf(modifierString) + " + " + newModifierString;
    }

    public static int computeStateMask(String modifiers) {
        if (modifiers == null) {
            return -1;
        }
        if (modifiers.length() == 0) {
            return 0;
        }
        int stateMask = 0;
        StringTokenizer modifierTokenizer = new StringTokenizer(modifiers, ",;.:+-* ");
        while (modifierTokenizer.hasMoreTokens()) {
            int modifier = EditorUtility.findLocalizedModifier(modifierTokenizer.nextToken());
            if (modifier == 0 || (stateMask & modifier) == modifier) {
                return -1;
            }
            stateMask |= modifier;
        }
        return stateMask;
    }

    public static int findLocalizedModifier(String token) {
        if (token == null) {
            return 0;
        }
        if (token.equalsIgnoreCase(Action.findModifierString((int)262144))) {
            return 262144;
        }
        if (token.equalsIgnoreCase(Action.findModifierString((int)131072))) {
            return 131072;
        }
        if (token.equalsIgnoreCase(Action.findModifierString((int)65536))) {
            return 65536;
        }
        if (token.equalsIgnoreCase(Action.findModifierString((int)0x400000))) {
            return 0x400000;
        }
        return 0;
    }

    public static Color getColor(RGB rgb) {
        if (rgb == null) {
            return null;
        }
        Color color = JFaceResources.getColorRegistry().get(rgb.toString());
        if (color == null) {
            JFaceResources.getColorRegistry().put(rgb.toString(), rgb);
            color = JFaceResources.getColorRegistry().get(rgb.toString());
        }
        return color;
    }

    public static String getModifierString(int stateMask) {
        String modifierString = "";
        if ((stateMask & 0x40000) == 262144) {
            modifierString = EditorUtility.appendModifierString(modifierString, 262144);
        }
        if ((stateMask & 0x10000) == 65536) {
            modifierString = EditorUtility.appendModifierString(modifierString, 65536);
        }
        if ((stateMask & 0x20000) == 131072) {
            modifierString = EditorUtility.appendModifierString(modifierString, 131072);
        }
        if ((stateMask & 0x400000) == 0x400000) {
            modifierString = EditorUtility.appendModifierString(modifierString, 0x400000);
        }
        return modifierString;
    }
}

