/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.graph.editpolicies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.SelectionHandlesEditPolicy;
import org.eclipse.gef.handles.MoveHandle;
import org.eclipse.gef.handles.MoveHandleLocator;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.wst.wsdl.ui.internal.graph.editparts.IFeedbackHandler;
import org.eclipse.wst.wsdl.ui.internal.graph.editparts.WSDLTreeNodeEditPart;
import org.eclipse.wst.wsdl.ui.internal.graph.editpolicies.WSDLDragAndDropCommand;

public class WSDLSelectionHandlesEditPolicyImpl
extends SelectionHandlesEditPolicy {
    protected IFigure feedback;
    protected Rectangle originalLocation;
    protected WSDLDragAndDropCommand dragAndDropCommand;

    protected List createSelectionHandles() {
        ArrayList<MoveHandle> list = new ArrayList<MoveHandle>();
        EditPart editPart = this.getHost();
        if (editPart instanceof GraphicalEditPart) {
            GraphicalEditPart graphicalEditPart = (GraphicalEditPart)editPart;
            IFigure figure = graphicalEditPart instanceof WSDLTreeNodeEditPart ? ((WSDLTreeNodeEditPart)graphicalEditPart).getSelectionFigure() : graphicalEditPart.getFigure();
            MoveHandleLocator loc = new MoveHandleLocator(figure);
            MoveHandle moveHandle = new MoveHandle(graphicalEditPart, (Locator)loc);
            list.add(moveHandle);
        }
        return list;
    }

    public boolean understandsRequest(Request request) {
        boolean result = false;
        result = "move".equals(request.getType()) ? false : super.understandsRequest(request);
        return result;
    }

    public Command getCommand(Request request) {
        return null;
    }

    public void setDragAndDropCommand(WSDLDragAndDropCommand dragAndDropCommand) {
        this.dragAndDropCommand = dragAndDropCommand;
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"move children");
        req.setEditParts(this.getHost());
        req.setMoveDelta(request.getMoveDelta());
        req.setSizeDelta(request.getSizeDelta());
        req.setLocation(request.getLocation());
        return this.getHost().getParent().getCommand((Request)req);
    }

    public void showSourceFeedback(Request request) {
        this.eraseChangeBoundsFeedback(null);
        if (this.dragAndDropCommand != null && this.dragAndDropCommand.canExecute()) {
            if ("move".equals(request.getType()) || "add children".equals(request.getType())) {
                this.showMoveChangeBoundsFeedback((ChangeBoundsRequest)request);
            } else if ("clone".equals(request.getType())) {
                this.showCopyChangeBoundsFeedback((ChangeBoundsRequest)request);
            }
        }
    }

    protected void showMoveChangeBoundsFeedback(ChangeBoundsRequest request) {
        if (this.dragAndDropCommand != null && this.dragAndDropCommand.getFeedbackFigure() != null) {
            this.feedback = this.dragAndDropCommand.getFeedbackFigure();
            this.addFeedback(this.feedback);
        }
    }

    protected void showCopyChangeBoundsFeedback(ChangeBoundsRequest request) {
    }

    public void deactivate() {
        if (this.feedback != null) {
            this.removeFeedback(this.feedback);
            this.feedback = null;
        }
        this.hideFocus();
        super.deactivate();
    }

    protected void eraseChangeBoundsFeedback(ChangeBoundsRequest request) {
        if (this.feedback != null) {
            this.removeFeedback(this.feedback);
        }
        this.feedback = null;
        this.originalLocation = null;
    }

    public void eraseSourceFeedback(Request request) {
        if ("move".equals(request.getType()) || "add children".equals(request.getType())) {
            this.eraseChangeBoundsFeedback((ChangeBoundsRequest)request);
        }
    }

    protected void hideSelection() {
        EditPart editPart = this.getHost();
        if (editPart instanceof IFeedbackHandler) {
            ((IFeedbackHandler)editPart).removeFeedback();
        }
    }

    protected void showSelection() {
        EditPart editPart = this.getHost();
        if (editPart instanceof IFeedbackHandler) {
            ((IFeedbackHandler)editPart).addFeedback();
        }
    }
}

