/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.properties.section;

import javax.xml.namespace.QName;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.ui.properties.internal.provisional.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.BindingFault;
import org.eclipse.wst.wsdl.BindingInput;
import org.eclipse.wst.wsdl.BindingOperation;
import org.eclipse.wst.wsdl.BindingOutput;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.MessageReference;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.Service;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.actions.SmartRenameAction;
import org.eclipse.wst.wsdl.ui.internal.properties.section.AbstractSection;

public class NameSection
extends AbstractSection {
    Text nameText;

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.nameText = this.getWidgetFactory().createText(this.composite, "");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 100);
        data.right = new FormAttachment(100, -this.rightMarginSpace - 5);
        data.top = new FormAttachment(0, 0);
        this.nameText.setLayoutData((Object)data);
        CLabel nameLabel = this.getWidgetFactory().createCLabel(this.composite, String.valueOf(WSDLEditorPlugin.getWSDLString("_UI_LABEL_NAME")) + ":");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.nameText, -5);
        data.top = new FormAttachment((Control)this.nameText, 0, 0x1000000);
        nameLabel.setLayoutData((Object)data);
        this.nameText.addListener(24, (Listener)this);
    }

    public void refresh() {
        super.refresh();
        if (this.nameText.isFocusControl()) {
            return;
        }
        this.setListenerEnabled(false);
        this.nameText.setText("");
        if (this.getElement() != null && this.getElement().getElement() != null) {
            String name = this.getElement().getElement().getAttribute("name");
            if (name == null) {
                name = "";
            }
            this.nameText.setText(name);
        }
        this.setListenerEnabled(true);
    }

    public boolean shouldUseExtraSpace() {
        return false;
    }

    public void doHandleEvent(Event event) {
        if (event.widget == this.nameText && !this.nameText.isDisposed()) {
            String newValue = this.nameText.getText();
            WSDLElement wsdlElement = this.getElement();
            if (wsdlElement instanceof Definition) {
                Definition definition = (Definition)wsdlElement;
                String uri = "";
                if (definition.getQName() != null) {
                    uri = definition.getQName().getNamespaceURI();
                }
                definition.setQName(new QName(uri, newValue));
            } else if (wsdlElement instanceof Service) {
                Service service = (Service)wsdlElement;
                String uri = service.getQName().getNamespaceURI();
                service.setQName(new QName(uri, newValue));
            } else if (wsdlElement instanceof Port) {
                new SmartRenameAction(wsdlElement, newValue).run();
            } else if (wsdlElement instanceof Binding) {
                Binding binding = (Binding)wsdlElement;
                String uri = binding.getQName().getNamespaceURI();
                binding.setQName(new QName(uri, newValue));
            } else if (wsdlElement instanceof BindingOperation) {
                ((BindingOperation)wsdlElement).setName(newValue);
            } else if (wsdlElement instanceof BindingInput) {
                if (((BindingInput)wsdlElement).getName() == null && newValue.equals("")) {
                    return;
                }
                ((BindingInput)wsdlElement).setName(newValue);
            } else if (wsdlElement instanceof BindingOutput) {
                if (((BindingOutput)wsdlElement).getName() == null && newValue.equals("")) {
                    return;
                }
                ((BindingOutput)wsdlElement).setName(newValue);
            } else if (wsdlElement instanceof BindingFault) {
                ((BindingFault)wsdlElement).setName(newValue);
            } else if (wsdlElement instanceof PortType) {
                PortType portType = (PortType)wsdlElement;
                String uri = portType.getQName().getNamespaceURI();
                portType.setQName(new QName(uri, newValue));
            } else if (wsdlElement instanceof Operation) {
                new SmartRenameAction(wsdlElement, newValue).run();
            } else if (wsdlElement instanceof MessageReference) {
                if (((MessageReference)wsdlElement).getName() == null && newValue.equals("")) {
                    return;
                }
                new SmartRenameAction(wsdlElement, newValue).run();
            } else if (wsdlElement instanceof Message) {
                new SmartRenameAction(wsdlElement, newValue).run();
            } else if (wsdlElement instanceof Part) {
                new SmartRenameAction(wsdlElement, newValue).run();
            }
        }
    }
}

