/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.validation;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.wsdl.validation.internal.IValidationMessage;
import org.eclipse.wst.wsdl.validation.internal.IValidationReport;
import org.eclipse.wst.wsdl.validation.internal.ValidationMessageImpl;
import org.eclipse.wst.wsdl.validation.internal.eclipse.WSDLValidator;
import org.eclipse.wst.wsdl.validation.internal.xml.XMLMessageInfoHelper;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationMessage;
import org.eclipse.wst.xml.ui.internal.validation.core.ValidateAction;

public class ValidateWSDLAction
extends ValidateAction {
    private final String FILE_PROTOCOL = "file:///";
    private InputStream inputStream = null;
    private static ResourceBundle wsdlActionRB = ResourceBundle.getBundle("org.eclipse.wst.wsdl.ui.internal.validation.validatewsdlui");

    public ValidateWSDLAction(IFile file, boolean showDialog) {
        super(file, showDialog);
    }

    protected void validate(final IFile file) {
        final ValidationOutcome validationOutcome = new ValidationOutcome();
        IWorkspaceRunnable op = new IWorkspaceRunnable(){

            public void run(IProgressMonitor progressMonitor) throws CoreException {
                WSDLValidator wsdlValidator = WSDLValidator.getInstance();
                ValidateWSDLAction.this.clearMarkers(file);
                IValidationReport valReport = null;
                String location = null;
                try {
                    location = file.getLocation().toFile().getCanonicalFile().getAbsolutePath();
                }
                catch (IOException iOException) {
                    location = file.getLocation().toString();
                }
                location = location.replace('\\', '/');
                valReport = location.startsWith("/") ? wsdlValidator.validate("file:///" + location.substring(1), ValidateWSDLAction.this.inputStream) : wsdlValidator.validate("file:///" + location, ValidateWSDLAction.this.inputStream);
                validationOutcome.isWSDLValid = valReport.isWSDLValid();
                validationOutcome.isValid = !valReport.hasErrors();
                validationOutcome.hasMessages = valReport.getValidationMessages().length != 0;
                ValidateWSDLAction.this.createMarkers(file, ValidateWSDLAction.this.convertValidationMessages(valReport.getValidationMessages()));
                file.setSessionProperty(ValidationMessage.ERROR_MESSAGE_MAP_QUALIFIED_NAME, (Object)ValidateWSDLAction.this.convertNestedValidationMessages(valReport.getNestedMessages()));
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(op, null);
            if (this.showDialog) {
                this.showDialog(validationOutcome);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ValidationMessage[] convertValidationMessages(IValidationMessage[] messages) {
        int numMessages = messages.length;
        ValidationMessage[] convertedMessages = new ValidationMessage[numMessages];
        int i = 0;
        while (i < numMessages) {
            IValidationMessage mess = messages[i];
            ValidationMessage convertMess = null;
            if (mess instanceof ValidationMessageImpl) {
                String errorKey = ((ValidationMessageImpl)mess).getErrorKey();
                Object[] messageArgs = ((ValidationMessageImpl)mess).getMessageArguments();
                convertMess = new ValidationMessage(mess.getMessage(), mess.getLine(), mess.getColumn(), mess.getURI(), errorKey, messageArgs);
            } else {
                convertMess = new ValidationMessage(mess.getMessage(), mess.getLine(), mess.getColumn(), mess.getURI());
            }
            if (mess.getSeverity() == 1) {
                convertMess.setSeverity(ValidationMessage.SEV_LOW);
            } else {
                convertMess.setSeverity(ValidationMessage.SEV_HIGH);
            }
            List nestedMessages = mess.getNestedMessages();
            if (nestedMessages != null && !nestedMessages.isEmpty()) {
                Iterator nestedIter = nestedMessages.iterator();
                while (nestedIter.hasNext()) {
                    IValidationMessage nestedMess = (IValidationMessage)nestedIter.next();
                    ValidationMessage convertNestedMess = new ValidationMessage(nestedMess.getMessage(), nestedMess.getLine(), nestedMess.getColumn(), nestedMess.getURI());
                    if (nestedMess.getSeverity() == 1) {
                        convertNestedMess.setSeverity(ValidationMessage.SEV_LOW);
                    } else {
                        convertNestedMess.setSeverity(ValidationMessage.SEV_HIGH);
                    }
                    convertMess.addNestedMessage(convertNestedMess);
                }
            }
            convertedMessages[i] = convertMess;
            ++i;
        }
        return convertedMessages;
    }

    private HashMap convertNestedValidationMessages(HashMap nestedMessages) {
        HashMap<String, ValidationMessage> convertedMap = new HashMap<String, ValidationMessage>();
        Set keySet = nestedMessages.keySet();
        Iterator keysIter = keySet.iterator();
        while (keysIter.hasNext()) {
            String key = (String)keysIter.next();
            IValidationMessage message = (IValidationMessage)nestedMessages.get(key);
            ValidationMessage[] convertedMessage = this.convertValidationMessages(new IValidationMessage[]{message});
            convertedMap.put(key, convertedMessage[0]);
        }
        return convertedMap;
    }

    public void showDialog(ValidationOutcome validationOutcome) {
        if (validationOutcome.isValid) {
            if (validationOutcome.hasMessages) {
                this.showProblemsView();
                String title = wsdlActionRB.getString("_VALIDATION_SUCCEEDED");
                String message = wsdlActionRB.getString("_UI_THE_WSDL_FILE_IS_VALID_WITH_WARNINGS");
                MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)title, (String)message);
            } else {
                String title = wsdlActionRB.getString("_VALIDATION_SUCCEEDED");
                String message = wsdlActionRB.getString("_UI_THE_WSDL_FILE_IS_VALID");
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)title, (String)message);
            }
        } else {
            String message;
            String title;
            if (validationOutcome.isWSDLValid) {
                title = wsdlActionRB.getString("_VALIDATION_FAILED");
                message = wsdlActionRB.getString("_UI_THE_WSDL_FILE_IS_VALID_WSDL11");
            } else {
                title = wsdlActionRB.getString("_VALIDATION_FAILED");
                message = wsdlActionRB.getString("_UI_THE_WSDL_FILE_IS_NOT_VALID");
            }
            this.showProblemsView();
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)title, (String)message);
        }
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    protected void addInfoToMessage(ValidationMessage valMess, IMessage message) {
        if (valMess.getKey() != null) {
            XMLMessageInfoHelper helper = new XMLMessageInfoHelper();
            String[] squiggleInfo = helper.createMessageInfo(valMess.getKey(), valMess.getMessageArguments());
            message.setAttribute("columnNumber", (Object)new Integer(valMess.getColumnNumber()));
            message.setAttribute("squiggleSelectionStrategy", (Object)squiggleInfo[0]);
            message.setAttribute("squiggleNameOrValue", (Object)squiggleInfo[1]);
        }
    }

    protected class ValidationOutcome {
        public boolean isValid = true;
        public boolean isWSDLValid = true;
        public boolean hasMessages = false;
    }
}

