/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.validation;

import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.wsdl.ui.internal.validation.ValidateWSDLAction;

public class Validator
implements IValidator {
    protected void validate(IFile file, InputStream inputStream, IReporter reporter) {
        ValidateWSDLAction validateAction = new ValidateWSDLAction(file, false);
        validateAction.setValidator(this);
        validateAction.setReporter(reporter);
        validateAction.setInputStream(inputStream);
        validateAction.run();
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        String[] changedFiles = helper.getURIs();
        if (changedFiles != null && changedFiles.length > 0) {
            InputStream streamToValidate = (InputStream)helper.loadModel("inputStream");
            if (streamToValidate != null) {
                String fileName = changedFiles[0];
                Object[] parms = new Object[]{fileName};
                IFile file = (IFile)helper.loadModel("getFile", parms);
                this.validate(file, streamToValidate, reporter);
            } else {
                int i = 0;
                while (i < changedFiles.length) {
                    Object[] parms;
                    IFile file;
                    String fileName = changedFiles[i];
                    if (fileName != null && (file = (IFile)helper.loadModel("getFile", parms = new Object[]{fileName})) != null) {
                        this.validateIfNeeded(file, helper, reporter);
                    }
                    ++i;
                }
            }
        } else {
            Object[] parms = new Object[]{this.getClass().getName()};
            Collection files = (Collection)helper.loadModel("getAllFiles", parms);
            Iterator iter = files.iterator();
            while (iter.hasNext()) {
                IFile file = (IFile)iter.next();
                this.validateIfNeeded(file, helper, reporter);
            }
        }
    }

    protected void validate(IFile file, IReporter reporter, int ruleGroup) {
        ValidateWSDLAction validateAction = new ValidateWSDLAction(file, false);
        validateAction.setValidator(this);
        validateAction.run();
    }

    protected void validateIfNeeded(IFile file, Object model, IValidationContext helper, IReporter reporter) {
        if (model == null) {
            this.validateIfNeeded(file, helper, reporter);
        }
    }

    protected IFile getFile(Object object) {
        Object file;
        List fileModelPair;
        IFile result = null;
        if (object instanceof List && (fileModelPair = (List)object).size() > 0 && (file = fileModelPair.get(0)) instanceof IFile) {
            result = (IFile)file;
        }
        return result;
    }

    protected void validateIfNeeded(IFile file, IValidationContext helper, IReporter reporter) {
        Integer ruleGroupInt = (Integer)helper.loadModel("PASS_LEVEL", null);
        int ruleGroup = ruleGroupInt == null ? 3 : ruleGroupInt;
        this.validate(file, reporter, ruleGroup);
    }

    public void cleanup(IReporter reporter) {
    }
}

