/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.sqleditor.internal;

import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.wst.rdb.connection.internal.ui.wizards.ConnectionSelectionWizard;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.sqleditor.internal.ISQLEditorInput;
import org.eclipse.wst.rdb.sqleditor.internal.SQLEditorDocumentSetupParticipant;
import org.eclipse.wst.rdb.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.wst.rdb.sqleditor.internal.SQLEditorResources;
import org.eclipse.wst.rdb.sqleditor.internal.actions.SQLConnectAction;
import org.eclipse.wst.rdb.sqleditor.internal.actions.SQLDisconnectAction;
import org.eclipse.wst.rdb.sqleditor.internal.actions.SQLRunAction;
import org.eclipse.wst.rdb.sqleditor.internal.actions.SQLSetStatementTerminatorAction;
import org.eclipse.wst.rdb.sqleditor.internal.editor.SQLEditorContentOutlinePage;
import org.eclipse.wst.rdb.sqleditor.internal.editor.SQLSourceViewer;
import org.eclipse.wst.rdb.sqleditor.internal.editor.SQLSourceViewerConfiguration;
import org.eclipse.wst.rdb.sqleditor.internal.sql.ISQLDBProposalsService;
import org.eclipse.wst.rdb.sqleditor.internal.sql.SQLCodeScanner;
import org.eclipse.wst.rdb.sqleditor.internal.sql.SQLDBProposalsService;
import org.eclipse.wst.rdb.sqleditor.internal.utils.SQLColorProvider;
import org.eclipse.wst.rdb.sqleditor.internal.utils.SQLStatementSupport;

public class SQLEditor
extends TextEditor
implements IPropertyChangeListener {
    public static final String PLUGIN_NAME = "org.eclipse.wst.rdb.sqleditor";
    public static final String HELP_CONTEXT_ID = "org.eclipse.wst.rdb.sqleditor.sqleditorhelp";
    private SQLEditorContentOutlinePage fOutlinePage;
    private ProjectionSupport fProjectionSupport;
    private ConnectionInfo fConnectionInfo;
    private Database fDatabase;
    private String fDefaultSchemaName;
    private SQLCodeScanner fSQLCodeScanner;
    private SQLEditorDocumentSetupParticipant fDocSetupParticipant;
    private ISQLDBProposalsService fDBProposalsService;
    private SQLStatementSupport fStmtSupport;
    static /* synthetic */ Class class$0;

    protected void createActions() {
        super.createActions();
        ResourceBundle bundle = this.getResourceBundle();
        Object a = new TextOperationAction(bundle, "ContentAssistProposal.", (ITextEditor)this, 13);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)a);
        a = new TextOperationAction(bundle, "ContentAssistTip.", (ITextEditor)this, 14);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
        this.setAction("ContentAssistTip", (IAction)a);
        a = new TextOperationAction(bundle, "ContentFormat.", (ITextEditor)this, 15);
        this.setAction("ContentFormat", (IAction)a);
        a = new SQLConnectAction(bundle, "SQLEditor.connectAction.");
        this.setAction("SQLEditor.connectAction", (IAction)a);
        a = new SQLDisconnectAction(bundle, "SQLEditor.disconnectAction.");
        this.setAction("SQLEditor.disconnectAction", (IAction)a);
        a = new SQLRunAction(bundle, "SQLEditor.runAction.");
        this.setAction("SQLEditor.runAction", (IAction)a);
        a = new SQLSetStatementTerminatorAction(bundle, "SQLEditor.setStatementTerminatorAction.");
        this.setAction("SQLEditor.setStatementTerminatorAction", (IAction)a);
    }

    protected SQLEditorContentOutlinePage createContentOutlinePage() {
        SQLEditorContentOutlinePage outlinePage = new SQLEditorContentOutlinePage(this.getDocumentProvider(), this);
        return outlinePage;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.setProjectionSupport(this.createProjectionSupport());
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        viewer.doOperation(19);
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchHelpSystem helpSystem = workbench.getHelpSystem();
        helpSystem.setHelp((Control)parent, HELP_CONTEXT_ID);
    }

    protected ProjectionSupport createProjectionSupport() {
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        ProjectionSupport projSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        projSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        projSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        projSupport.install();
        return projSupport;
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        SQLSourceViewer viewer = new SQLSourceViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        return viewer;
    }

    protected SQLSourceViewerConfiguration createSourceViewerConfiguration() {
        SQLSourceViewerConfiguration config = new SQLSourceViewerConfiguration(this);
        ISQLDBProposalsService proposalsService = this.getDBProposalsService();
        if (proposalsService != null) {
            config.setDBProposalsService(proposalsService);
        }
        return config;
    }

    public void dispose() {
        SQLEditorContentOutlinePage outlinePage = this.getOutlinePage();
        if (outlinePage != null) {
            outlinePage.setInput(null);
        }
        super.dispose();
    }

    public void doRevertToSaved() {
        super.doRevertToSaved();
        this.updateOutlinePage();
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        this.updateOutlinePage();
    }

    public void doSaveAs() {
        super.doSaveAs();
        this.updateOutlinePage();
    }

    public void doSetInput(IEditorInput input) throws CoreException {
        IDocument doc;
        super.doSetInput(input);
        IDocumentProvider docProvider = this.getDocumentProvider();
        if (docProvider != null && (doc = docProvider.getDocument((Object)input)) != null) {
            SQLEditorDocumentSetupParticipant docSetupParticipant = this.getDocumentSetupParticipant();
            docSetupParticipant.setup(doc);
        }
        ConnectionInfo connInfo = null;
        Database db = null;
        String defaultSchemaName = null;
        if (input instanceof ISQLEditorInput) {
            ISQLEditorInput sqlInput = (ISQLEditorInput)input;
            connInfo = sqlInput.getConnectionInfo();
            db = sqlInput.getDatabase();
            defaultSchemaName = sqlInput.getDefaultSchemaName();
        }
        if (connInfo != null && db == null) {
            db = connInfo.getSharedDatabase();
        }
        this.setConnectionInfo(connInfo);
        this.setDatabase(db);
        this.setDefaultSchemaName(defaultSchemaName);
        this.refreshConnectionStatus();
        SQLEditorContentOutlinePage outlinePage = this.getOutlinePage();
        if (outlinePage != null) {
            outlinePage.setInput(input);
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "ContentAssistProposal");
        this.addAction(menu, "ContentAssistTip");
        this.addAction(menu, "ContentFormat");
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "SQLEditor.connectAction");
        this.addAction(menu, "SQLEditor.runAction");
        this.addAction(menu, "SQLEditor.setStatementTerminatorAction");
        this.updateActionState(menu);
    }

    public Object getAdapter(Class classForWhichAdapterNeeded) {
        ProjectionSupport projSupport;
        Object adapter = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(classForWhichAdapterNeeded)) {
            SQLEditorContentOutlinePage outlinePage;
            adapter = outlinePage = this.getOutlinePage();
        } else if (adapter == null && (projSupport = this.getProjectionSupport()) != null) {
            adapter = projSupport.getAdapter(this.getSourceViewer(), classForWhichAdapterNeeded);
        }
        if (adapter == null) {
            adapter = super.getAdapter(classForWhichAdapterNeeded);
        }
        return adapter;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.fConnectionInfo;
    }

    public Database getDatabase() {
        return this.fDatabase;
    }

    public ISQLDBProposalsService getDBProposalsService() {
        return this.fDBProposalsService;
    }

    public String getDefaultSchemaName() {
        return this.fDefaultSchemaName;
    }

    public SQLEditorDocumentSetupParticipant getDocumentSetupParticipant() {
        if (this.fDocSetupParticipant == null) {
            this.fDocSetupParticipant = new SQLEditorDocumentSetupParticipant();
        }
        return this.fDocSetupParticipant;
    }

    protected SQLEditorContentOutlinePage getOutlinePage() {
        return this.fOutlinePage;
    }

    protected ProjectionSupport getProjectionSupport() {
        return this.fProjectionSupport;
    }

    public ResourceBundle getResourceBundle() {
        return SQLEditorResources.getResourceBundle();
    }

    public SQLCodeScanner getSQLCodeScanner() {
        if (this.fSQLCodeScanner == null) {
            this.fSQLCodeScanner = new SQLCodeScanner(SQLEditorPlugin.getDefault().getSQLColorProvider());
        }
        return this.fSQLCodeScanner;
    }

    public SQLColorProvider getSQLColorProvider() {
        return SQLEditorPlugin.getDefault().getSQLColorProvider();
    }

    public SQLStatementSupport getSQLStatementSupport() {
        if (this.fStmtSupport == null) {
            this.fStmtSupport = new SQLStatementSupport();
        }
        IDocumentProvider docProvider = this.getDocumentProvider();
        IEditorInput editorInput = this.getEditorInput();
        IDocument doc = docProvider.getDocument((Object)editorInput);
        this.fStmtSupport.setDocument(doc);
        return this.fStmtSupport;
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setSourceViewerConfiguration(this.createSourceViewerConfiguration());
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("Connection")) {
            ConnectionInfo connInfo = (ConnectionInfo)event.getNewValue();
            this.setConnectionInfo(connInfo);
            this.refreshConnectionStatus();
        }
    }

    public ConnectionInfo requestConnectionFromUser() {
        ConnectionSelectionWizard connWizard = new ConnectionSelectionWizard();
        Shell shell = SQLEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        WizardDialog dialog = new WizardDialog(shell, (IWizard)connWizard);
        dialog.setBlockOnOpen(true);
        if (dialog.open() == 0) {
            ConnectionInfo info = connWizard.getConInfo();
            return info;
        }
        return null;
    }

    public void refreshConnectionStatus() {
        IActionBars actionBars;
        IEditorSite editorSite = this.getEditorSite();
        if (editorSite != null && (actionBars = editorSite.getActionBars()) != null) {
            IStatusLineManager statusLineMgr = actionBars.getStatusLineManager();
            ConnectionInfo connInfo = this.getConnectionInfo();
            if (connInfo != null) {
                statusLineMgr.setErrorMessage(null);
                String connStatus = String.valueOf(connInfo.getName()) + " (" + connInfo.getDatabaseName() + ": " + connInfo.getURL() + ")";
                statusLineMgr.setMessage(connStatus);
            } else {
                String connStatus = SQLEditorResources.getString("SQLEditor.connection.status.noConnection");
                statusLineMgr.setErrorMessage(connStatus);
            }
            actionBars.updateActionBars();
        }
    }

    public void setConnectionInfo(ConnectionInfo connInfo) {
        this.fConnectionInfo = connInfo;
        IEditorInput input = this.getEditorInput();
        if (input instanceof ISQLEditorInput) {
            ISQLEditorInput sqlEditorInput = (ISQLEditorInput)input;
            sqlEditorInput.setConnectionInfo(connInfo);
        }
        if (this.fConnectionInfo != null) {
            this.fDBProposalsService = new SQLDBProposalsService(connInfo);
            SourceViewerConfiguration config = this.getSourceViewerConfiguration();
            if (config != null && config instanceof SQLSourceViewerConfiguration) {
                SQLSourceViewerConfiguration sqlConfig = (SQLSourceViewerConfiguration)config;
                sqlConfig.setDBProposalsService(this.fDBProposalsService);
            }
        }
    }

    public void setDatabase(Database database) {
        this.fDatabase = database;
        IEditorInput input = this.getEditorInput();
        if (input instanceof ISQLEditorInput) {
            ISQLEditorInput sqlEditorInput = (ISQLEditorInput)input;
            sqlEditorInput.setDatabase(database);
        }
    }

    public void setDefaultSchemaName(String schemaName) {
        this.fDefaultSchemaName = schemaName;
        IEditorInput input = this.getEditorInput();
        if (input instanceof ISQLEditorInput) {
            ISQLEditorInput sqlEditorInput = (ISQLEditorInput)input;
            sqlEditorInput.setDefaultSchemaName(schemaName);
        }
    }

    public void setDocumentSetupParticipant(SQLEditorDocumentSetupParticipant docSetupParticipant) {
        this.fDocSetupParticipant = docSetupParticipant;
    }

    public void setFocus() {
        super.setFocus();
        this.refreshConnectionStatus();
    }

    protected void setOutlinePage(SQLEditorContentOutlinePage outlinePage) {
        this.fOutlinePage = outlinePage;
    }

    protected void setProjectionSupport(ProjectionSupport projSupport) {
        this.fProjectionSupport = projSupport;
    }

    public void setSQLStatementSupport(SQLStatementSupport stmtSupport) {
        this.fStmtSupport = stmtSupport;
    }

    protected void updateOutlinePage() {
        SQLEditorContentOutlinePage outlinePage = this.getOutlinePage();
        if (outlinePage != null) {
            outlinePage.update();
        }
    }

    protected void updateActionState(IMenuManager menu) {
        IAction runAction = this.getAction("SQLEditor.runAction");
        ConnectionInfo coninfo = this.getConnectionInfo();
        if (coninfo != null && coninfo.getSharedConnection() == null && coninfo.getSharedDatabase() != null) {
            runAction.setEnabled(false);
        } else {
            runAction.setEnabled(true);
        }
    }
}

