/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.sqleditor.internal.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.wst.rdb.sqleditor.internal.sql.SQLPartitionScanner;

public class SQLStatementSupport
implements IPropertyChangeListener {
    public static final String CURRENT_STATEMENT_TERMINATOR = "currentStatementTerminator";
    public static final String DEFAULT_STATEMENT_TERMINATOR = ";";
    private static final String STMT_TERM_TAG_1 = "-- <ScriptOptions statementTerminator=\"";
    private static final String STMT_TERM_TAG_2 = "\" />\r";
    private static final Pattern STMT_TERM_TAG_PATTERN = Pattern.compile("\\A[ ]*--[ ]*<ScriptOptions[ ]+statementTerminator[ ]*=[ ]*\"(.+)\".*[\\s]*", 2);
    private IDocument fDoc;

    public SQLStatementSupport() {
        this(null);
    }

    public SQLStatementSupport(IDocument doc) {
        this.fDoc = doc;
    }

    public String getDefaultStatementTerminator() {
        return DEFAULT_STATEMENT_TERMINATOR;
    }

    protected IDocument getDocument() {
        return this.fDoc;
    }

    public List getSQLStatementList() {
        ArrayList<String> stmtList = new ArrayList<String>();
        String stmtTerminator = this.getStatementTerminator();
        IDocument doc = this.getDocument();
        ITypedRegion[] regions = SQLPartitionScanner.getDocumentRegions(doc);
        if (regions != null) {
            StringBuffer stmtBuf = new StringBuffer();
            ITypedRegion region = null;
            int i = 0;
            while (i < regions.length) {
                region = regions[i];
                if (!region.getType().equals("__sql_comment__")) {
                    int regionOffset = region.getOffset();
                    int regionLength = region.getLength();
                    String stmtPart = "";
                    try {
                        stmtPart = doc.get(regionOffset, regionLength);
                    }
                    catch (BadLocationException badLocationException) {}
                    if (region.getType().equals("__sql_quoted_literal__") || region.getType().equals("__sql_delimited_identifier__")) {
                        stmtBuf.append(stmtPart);
                    } else {
                        int scanStart = 0;
                        int terminatorPos = stmtPart.indexOf(stmtTerminator, scanStart);
                        while (terminatorPos != -1 && scanStart < stmtPart.length()) {
                            stmtBuf.append(stmtPart.substring(scanStart, terminatorPos));
                            String stmt = stmtBuf.toString();
                            stmt = stmt.trim();
                            if (stmt.length() > 0) {
                                stmtList.add(stmt);
                            }
                            stmtBuf.setLength(0);
                            scanStart = terminatorPos + stmtTerminator.length();
                            if (scanStart >= stmtPart.length()) continue;
                            terminatorPos = stmtPart.indexOf(stmtTerminator, scanStart);
                        }
                        if (scanStart < stmtPart.length()) {
                            stmtBuf.append(stmtPart.substring(scanStart, stmtPart.length()));
                        }
                    }
                }
                ++i;
            }
            if (stmtBuf.length() > 0) {
                String stmt = stmtBuf.toString();
                if ((stmt = stmt.trim()).length() > 0) {
                    stmtList.add(stmt);
                }
            }
        }
        return stmtList;
    }

    public String getStatementTerminator() {
        int groupCount;
        String statementTerminator = this.getDefaultStatementTerminator();
        StatementTerminatorTagInfo stmtTermTagInfo = this.getStatementTerminatorTagInfo();
        if (stmtTermTagInfo != null && (groupCount = stmtTermTagInfo.tagMatcher.groupCount()) == 1) {
            statementTerminator = stmtTermTagInfo.tagMatcher.group(1);
        }
        return statementTerminator;
    }

    protected StatementTerminatorTagInfo getStatementTerminatorTagInfo() {
        StatementTerminatorTagInfo stmtTermTagInfo = null;
        IDocument doc = this.getDocument();
        ITypedRegion[] regions = SQLPartitionScanner.getDocumentRegions(doc);
        ITypedRegion region = null;
        int regionCount = regions.length;
        int i = 0;
        while (i < regionCount && stmtTermTagInfo == null) {
            region = regions[i];
            if (region.getType().equals("__sql_comment__")) {
                int regionOffset = region.getOffset();
                int regionLength = region.getLength();
                String regionStr = "";
                try {
                    regionStr = doc.get(regionOffset, regionLength);
                }
                catch (BadLocationException badLocationException) {}
                Matcher stmtTermTagMatcher = STMT_TERM_TAG_PATTERN.matcher(regionStr);
                boolean matches = stmtTermTagMatcher.matches();
                if (matches) {
                    stmtTermTagInfo = new StatementTerminatorTagInfo();
                    stmtTermTagInfo.doc = doc;
                    stmtTermTagInfo.tagRegion = region;
                    stmtTermTagInfo.tagMatcher = stmtTermTagMatcher;
                }
            }
            ++i;
        }
        return stmtTermTagInfo;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(CURRENT_STATEMENT_TERMINATOR)) {
            String statementTerminator = (String)event.getNewValue();
            this.setStatementTerminator(statementTerminator);
        }
    }

    public void setDocument(IDocument doc) {
        this.fDoc = doc;
    }

    public void setStatementTerminator(String newStatementTerminator) {
        IDocument doc;
        int groupCount;
        String defaultStatementTerminator = this.getDefaultStatementTerminator();
        String docStatementTerminator = null;
        StatementTerminatorTagInfo stmtTermTagInfo = this.getStatementTerminatorTagInfo();
        if (stmtTermTagInfo != null && (groupCount = stmtTermTagInfo.tagMatcher.groupCount()) == 1) {
            docStatementTerminator = stmtTermTagInfo.tagMatcher.group(1);
        }
        if ((doc = this.getDocument()) != null) {
            if (docStatementTerminator != null && !newStatementTerminator.equals(docStatementTerminator)) {
                int tagOffset = stmtTermTagInfo.tagRegion.getOffset();
                int tagLength = stmtTermTagInfo.tagRegion.getLength();
                if (newStatementTerminator.equals(defaultStatementTerminator)) {
                    try {
                        doc.replace(tagOffset, tagLength, "");
                    }
                    catch (BadLocationException badLocationException) {}
                } else {
                    int stmtTermStartIndex = stmtTermTagInfo.tagMatcher.start(1);
                    int stmtTermEndIndex = stmtTermTagInfo.tagMatcher.end(1);
                    int stmtTermLength = stmtTermEndIndex - stmtTermStartIndex;
                    try {
                        doc.replace(tagOffset + stmtTermStartIndex, stmtTermLength, newStatementTerminator);
                    }
                    catch (BadLocationException badLocationException) {}
                }
            } else if (!newStatementTerminator.equals(defaultStatementTerminator)) {
                String stmtTermTag = STMT_TERM_TAG_1 + newStatementTerminator + STMT_TERM_TAG_2;
                try {
                    doc.replace(0, 0, stmtTermTag);
                }
                catch (BadLocationException badLocationException) {}
            }
        }
    }

    private class StatementTerminatorTagInfo {
        IDocument doc;
        ITypedRegion tagRegion;
        Matcher tagMatcher;

        StatementTerminatorTagInfo() {
        }
    }
}

