/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.core.internal.validation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolver;
import org.eclipse.wst.xml.core.internal.validation.XMLValidator;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationInfo;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationReport;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XSDValidator {
    private final String XML_INSTANCE_DOC_TOP = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<root \n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n";
    private final String XML_INSTANCE_DOC_MID = " xsi:noNamespaceSchemaLocation=\"";
    private final String XML_INSTANCE_DOC_BOT = "\">\n</root>\n";
    private final String DUMMY_URI = "http://example.org/dummy";
    private URIResolver uriresolver = null;

    public ValidationReport validate(String uri) {
        return this.validate(uri, null);
    }

    public ValidationReport validate(String uri, InputStream inputStream) {
        ValidationInfo valinfo = new ValidationInfo(uri);
        try {
            String ns = null;
            String schemaLocationString = "";
            URL url = new URL(uri);
            if (url != null) {
                BufferedReader bufreader = new BufferedReader(new InputStreamReader(url.openStream()));
                if (bufreader != null) {
                    StringBuffer source = new StringBuffer();
                    while (bufreader.ready()) {
                        source.append(bufreader.readLine());
                    }
                    bufreader.close();
                    int tn = source.indexOf("targetNamespace");
                    if (tn != -1) {
                        int firstquote = source.indexOf("\"", tn) + 1;
                        int secondquote = source.indexOf("\"", firstquote);
                        ns = source.substring(firstquote, secondquote);
                    }
                }
                bufreader.close();
            }
            XSDErrorHandler errorHandler = new XSDErrorHandler(valinfo);
            try {
                StringBuffer instanceDoc = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<root \n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
                if (ns != null && !ns.equals("")) {
                    instanceDoc.append(" xmlns=\"").append(ns).append("\"\n");
                    instanceDoc.append(" xsi:schemaLocation=\"");
                    instanceDoc.append(ns);
                    instanceDoc.append(" ");
                } else {
                    instanceDoc.append(" xsi:noNamespaceSchemaLocation=\"");
                }
                instanceDoc.append(uri.replaceAll(" ", "%20"));
                if (!schemaLocationString.equals("")) {
                    instanceDoc.append(" ").append(schemaLocationString);
                }
                instanceDoc.append("\">\n</root>\n");
                InputSource is = new InputSource(new StringReader(instanceDoc.toString()));
                is.setSystemId("http://example.org/dummy");
                String soapFile = "platform:/plugin/org.eclipse.wst.wsdl.validation./xsd/xml-soap.xsd";
                SAXParser reader = new SAXParser();
                try {
                    reader.setFeature("http://apache.org/xml/features/continue-after-fatal-error", false);
                    reader.setFeature("http://xml.org/sax/features/namespaces", true);
                    reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                    reader.setFeature("http://xml.org/sax/features/validation", true);
                    reader.setFeature("http://apache.org/xml/features/validation/schema", true);
                    reader.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
                    reader.setFeature("http://xml.org/sax/features/external-general-entities", true);
                    reader.setFeature("http://xml.org/sax/features/external-parameter-entities", true);
                    reader.setFeature("http://apache.org/xml/features/validation/warn-on-duplicate-attdef", true);
                    reader.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", "http://xml.apache.org/xml-soap " + soapFile);
                    reader.setErrorHandler(errorHandler);
                    if (this.uriresolver != null) {
                        XSDEntityResolver resolver = new XSDEntityResolver(this.uriresolver, uri, inputStream);
                        try {
                            reader.setProperty("http://apache.org/xml/properties/internal/entity-resolver", resolver);
                        }
                        catch (Exception exception) {}
                    }
                    reader.parse(is);
                }
                catch (SAXException sAXException) {
                }
            }
            catch (IOException iOException) {}
        }
        catch (Exception exception) {}
        return valinfo;
    }

    public void setURIResolver(URIResolver uriresolver) {
        this.uriresolver = uriresolver;
    }

    protected class XSDErrorHandler
    implements ErrorHandler {
        private final int ERROR = 0;
        private final int WARNING = 1;
        private final ValidationInfo valinfo;

        public XSDErrorHandler(ValidationInfo valinfo) {
            this.valinfo = valinfo;
        }

        protected void addValidationMessage(SAXParseException exception, int severity) {
            int index;
            String errorKey = exception.getLocalizedMessage();
            if (errorKey != null && (index = errorKey.indexOf(58)) != -1) {
                errorKey = errorKey.substring(0, index);
            }
            if (exception.getSystemId() != null && !exception.getSystemId().equals("http://example.org/dummy")) {
                if (severity == 1) {
                    this.valinfo.addWarning(exception.getLocalizedMessage(), exception.getLineNumber(), exception.getColumnNumber(), exception.getSystemId());
                } else {
                    this.valinfo.addError(exception.getLocalizedMessage(), exception.getLineNumber(), exception.getColumnNumber(), exception.getSystemId(), errorKey, null);
                }
            }
        }

        public void error(SAXParseException exception) throws SAXException {
            this.addValidationMessage(exception, 0);
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            this.addValidationMessage(exception, 0);
        }

        public void warning(SAXParseException exception) throws SAXException {
            this.addValidationMessage(exception, 1);
        }
    }

    protected class XSDEntityResolver
    implements XMLEntityResolver {
        private URIResolver uriresolver = null;
        private InputStream inputStream;

        public XSDEntityResolver(URIResolver uriresolver, String baselocation, InputStream inputStream) {
            this.uriresolver = uriresolver;
            this.inputStream = inputStream;
        }

        public XMLInputSource resolveEntity(XMLResourceIdentifier resourceIdentifier) throws XNIException, IOException {
            boolean isDummyXML = "http://example.org/dummy".equals(resourceIdentifier.getBaseSystemId());
            if (isDummyXML && this.inputStream != null) {
                XMLInputSource inputSource = new XMLInputSource(null, resourceIdentifier.getLiteralSystemId(), null, this.inputStream, null);
                return inputSource;
            }
            return XMLValidator._internalResolveEntity((URIResolver)this.uriresolver, (XMLResourceIdentifier)resourceIdentifier);
        }
    }
}

