/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.text;

import org.eclipse.ant.internal.ui.editor.text.AntAnnotationModel;
import org.eclipse.ant.internal.ui.editor.text.AntDocumentSetupParticipant;
import org.eclipse.ant.internal.ui.editor.text.AntExternalAnnotationModel;
import org.eclipse.ant.internal.ui.editor.text.AntStorageDocumentProvider;
import org.eclipse.ant.internal.ui.model.AntModel;
import org.eclipse.ant.internal.ui.model.IProblemRequestor;
import org.eclipse.ant.internal.ui.model.LocationProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class AntEditorDocumentProvider
extends TextFileDocumentProvider {
    private final AntDocumentSetupParticipant fAntDocumentSetupParticipant;

    public AntEditorDocumentProvider() {
        TextFileDocumentProvider provider = new TextFileDocumentProvider((IDocumentProvider)new AntStorageDocumentProvider());
        this.setParentDocumentProvider((IDocumentProvider)provider);
        this.fAntDocumentSetupParticipant = new AntDocumentSetupParticipant();
    }

    public AntModel getAntModel(Object element) {
        TextFileDocumentProvider.FileInfo info = this.getFileInfo(element);
        if (info instanceof AntFileInfo) {
            AntFileInfo xmlInfo = (AntFileInfo)info;
            return xmlInfo.fAntModel;
        }
        return null;
    }

    protected IAnnotationModel createAnnotationModel(IFile file) {
        return new AntAnnotationModel(file);
    }

    protected AntModel createAntModel(Object element, IDocument document, IAnnotationModel annotationModel) {
        IProblemRequestor requestor = annotationModel instanceof IProblemRequestor ? (IProblemRequestor)annotationModel : null;
        return new AntModel(document, requestor, new LocationProvider(element instanceof IEditorInput ? (IEditorInput)element : null));
    }

    protected TextFileDocumentProvider.FileInfo createFileInfo(Object element) throws CoreException {
        IDocumentExtension3 extension;
        TextFileDocumentProvider.FileInfo info = super.createFileInfo(element);
        if (!(info instanceof AntFileInfo)) {
            return null;
        }
        IDocument document = info.fTextFileBuffer.getDocument();
        if (document instanceof IDocumentExtension3 && (extension = (IDocumentExtension3)document).getDocumentPartitioner("org.eclipse.ant.ui.antPartitioning") == null) {
            this.fAntDocumentSetupParticipant.setup(document);
        }
        AntFileInfo xmlInfo = (AntFileInfo)info;
        Object annotationModel = xmlInfo.fTextFileBuffer.getAnnotationModel();
        if (annotationModel instanceof IProblemRequestor) {
            xmlInfo.fModel = annotationModel;
        } else {
            annotationModel = xmlInfo.fModel;
        }
        if (annotationModel == null) {
            xmlInfo.fModel = annotationModel = new AntExternalAnnotationModel();
        }
        AntModel antModel = this.createAntModel(element, document, (IAnnotationModel)annotationModel);
        antModel.install();
        xmlInfo.fAntModel = antModel;
        this.setUpSynchronization(xmlInfo);
        return xmlInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disposeFileInfo(Object element, TextFileDocumentProvider.FileInfo info) {
        if (info instanceof AntFileInfo) {
            AntFileInfo xmlInfo = (AntFileInfo)info;
            if (xmlInfo.fAntModel != null) {
                IDocument doc = xmlInfo.fTextFileBuffer.getDocument();
                Object lock = null;
                lock = doc instanceof ISynchronizable ? ((ISynchronizable)doc).getLockObject() : xmlInfo.fAntModel;
                Object object = lock;
                synchronized (object) {
                    xmlInfo.fAntModel.dispose();
                    xmlInfo.fAntModel = null;
                }
            }
        }
        super.disposeFileInfo(element, info);
    }

    protected TextFileDocumentProvider.FileInfo createEmptyFileInfo() {
        return new AntFileInfo();
    }

    private void setUpSynchronization(AntFileInfo antInfo) {
        IDocument document = antInfo.fTextFileBuffer.getDocument();
        IAnnotationModel model = antInfo.fModel;
        if (document instanceof ISynchronizable && model instanceof ISynchronizable) {
            Object lock = ((ISynchronizable)document).getLockObject();
            ((ISynchronizable)model).setLockObject(lock);
        }
    }

    protected class AntFileInfo
    extends TextFileDocumentProvider.FileInfo {
        public AntModel fAntModel;
    }
}

