/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.core.internal.publishers;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;

public class ModulePackager {
    private ZipOutputStream outputStream;
    private boolean useCompression = true;

    public ModulePackager(String filename, boolean compress) throws IOException {
        Path directoryPath = new Path(filename);
        directoryPath = (Path)directoryPath.removeLastSegments(1);
        File newZipFile = new File(directoryPath.toString());
        newZipFile.mkdirs();
        this.outputStream = new ZipOutputStream(new FileOutputStream(filename));
        this.useCompression = compress;
    }

    public void finished() throws IOException {
        this.outputStream.close();
    }

    protected void write(String pathname, byte[] contents) throws IOException {
        ZipEntry newEntry = new ZipEntry(pathname);
        if (!this.useCompression) {
            newEntry.setMethod(0);
            newEntry.setSize(contents.length);
            CRC32 checksumCalculator = new CRC32();
            checksumCalculator.update(contents);
            newEntry.setCrc(checksumCalculator.getValue());
        }
        this.outputStream.putNextEntry(newEntry);
        this.outputStream.write(contents);
        this.outputStream.closeEntry();
    }

    public void writeFolder(String destinationPath) throws IOException {
        if (!destinationPath.endsWith("/")) {
            destinationPath = String.valueOf(destinationPath) + '/';
        }
        ZipEntry newEntry = new ZipEntry(destinationPath);
        this.outputStream.putNextEntry(newEntry);
        this.outputStream.closeEntry();
    }

    /*
     * Exception decompiling
     */
    public void write(IFile resource, String destinationPath) throws IOException, CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 39->43)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(InputStream contentStream, String destinationPath) throws IOException, CoreException {
        ByteArrayOutputStream output;
        block5: {
            output = null;
            try {
                output = new ByteArrayOutputStream();
                int chunkSize = contentStream.available();
                byte[] readBuffer = new byte[chunkSize];
                int n = contentStream.read(readBuffer);
                while (n > 0) {
                    output.write(readBuffer);
                    n = contentStream.read(readBuffer);
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (output != null) {
                    output.close();
                }
                throw throwable;
            }
            {
                Object var7_9 = null;
                if (output == null) break block5;
            }
            output.close();
        }
        this.write(destinationPath, output.toByteArray());
    }
}

