/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.projection;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.wst.sse.core.internal.PropagatingAdapter;
import org.eclipse.wst.sse.core.internal.model.FactoryRegistry;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.eclipse.wst.sse.ui.internal.projection.IStructuredTextFoldingProvider;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.ui.internal.projection.ProjectionModelNodeAdapterFactoryXML;
import org.eclipse.wst.xml.ui.internal.projection.ProjectionModelNodeAdapterXML;
import org.w3c.dom.Node;

public class StructuredTextFoldingProviderXML
implements IStructuredTextFoldingProvider,
IProjectionListener {
    private static final boolean debugProjectionPerf = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.xml.ui/projectionperf"));
    private IDocument fDocument;
    private ProjectionViewer fViewer;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private void addAdapterToNodeAndChildren(Node node, int level) {
        if (node instanceof INodeNotifier) {
            ProjectionModelNodeAdapterXML adapter;
            INodeNotifier notifier = (INodeNotifier)node;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.xml.ui.internal.projection.ProjectionModelNodeAdapterXML");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (ProjectionModelNodeAdapterXML)notifier.getExistingAdapter((Object)clazz)) != null) {
                adapter.updateAdapter(node);
            } else {
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.wst.xml.ui.internal.projection.ProjectionModelNodeAdapterXML");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                notifier.getAdapterFor((Object)clazz2);
            }
            Node nextChild = node.getFirstChild();
            while (nextChild != null) {
                Node childNode = nextChild;
                nextChild = childNode.getNextSibling();
                this.addAdapterToNodeAndChildren(childNode, level + 1);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addAllAdapters() {
        long start;
        block7: {
            start = System.currentTimeMillis();
            IStructuredModel sModel = null;
            try {
                int startOffset;
                IndexedRegion startNode;
                sModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
                if (sModel != null && (startNode = sModel.getIndexedRegion(startOffset = 0)) instanceof Node) {
                    int level = 0;
                    Node nextSibling = (Node)startNode;
                    while (nextSibling != null) {
                        Node currentNode = nextSibling;
                        nextSibling = currentNode.getNextSibling();
                        this.addAdapterToNodeAndChildren(currentNode, level);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (sModel != null) {
                    sModel.releaseFromRead();
                }
                throw throwable;
            }
            {
                Object var9_11 = null;
                if (sModel == null) break block7;
            }
            sModel.releaseFromRead();
        }
        long end = System.currentTimeMillis();
        if (debugProjectionPerf) {
            System.out.println("StructuredTextFoldingProviderXML.addAllAdapters: " + (end - start));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ProjectionModelNodeAdapterFactoryXML getAdapterFactory(boolean createIfNeeded) {
        ProjectionModelNodeAdapterFactoryXML factory;
        long start;
        block17: {
            start = System.currentTimeMillis();
            factory = null;
            IStructuredModel sModel = null;
            try {
                sModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
                if (sModel != null) {
                    Class<?> clazz;
                    FactoryRegistry factoryRegistry = sModel.getFactoryRegistry();
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        Class<?> clazz3;
                        try {
                            clazz3 = Class.forName("org.eclipse.wst.xml.ui.internal.projection.ProjectionModelNodeAdapterXML");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        clazz2 = class$0 = clazz3;
                    }
                    if (!factoryRegistry.contains((Object)clazz2) && createIfNeeded) {
                        PropagatingAdapter propagatingAdapter;
                        ProjectionModelNodeAdapterFactoryXML newFactory = new ProjectionModelNodeAdapterFactoryXML();
                        factoryRegistry.addFactory((INodeAdapterFactory)newFactory);
                        IDOMModel domModel = (IDOMModel)sModel;
                        IDOMDocument document = domModel.getDocument();
                        INodeNotifier iNodeNotifier = (INodeNotifier)document;
                        Class<?> clazz4 = class$1;
                        if (clazz4 == null) {
                            Class<?> clazz5;
                            try {
                                clazz5 = Class.forName("org.eclipse.wst.sse.core.internal.PropagatingAdapter");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            clazz4 = class$1 = clazz5;
                        }
                        if ((propagatingAdapter = (PropagatingAdapter)iNodeNotifier.getAdapterFor((Object)clazz4)) != null) {
                            propagatingAdapter.addAdaptOnCreateFactory((INodeAdapterFactory)newFactory);
                        }
                    }
                    if ((clazz = class$0) == null) {
                        Class<?> clazz6;
                        try {
                            clazz6 = Class.forName("org.eclipse.wst.xml.ui.internal.projection.ProjectionModelNodeAdapterXML");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        clazz = class$0 = clazz6;
                    }
                    factory = (ProjectionModelNodeAdapterFactoryXML)factoryRegistry.getFactoryFor((Object)clazz);
                }
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (sModel != null) {
                    sModel.releaseFromRead();
                }
                throw throwable;
            }
            {
                Object var11_13 = null;
                if (sModel == null) break block17;
            }
            sModel.releaseFromRead();
        }
        long end = System.currentTimeMillis();
        if (debugProjectionPerf) {
            System.out.println("StructuredTextFoldingProviderXML.getAdapterFactory: " + (end - start));
        }
        return factory;
    }

    public void initialize() {
        if (!this.isInstalled()) {
            return;
        }
        ProjectionModelNodeAdapterFactoryXML factory = this.getAdapterFactory(false);
        if (factory != null) {
            factory.setProjectionViewer(null);
        }
        if (this.fViewer.getProjectionAnnotationModel() != null) {
            this.fViewer.getProjectionAnnotationModel().removeAllAnnotations();
        }
        this.fDocument = this.fViewer.getDocument();
        if (this.fDocument != null) {
            factory = this.getAdapterFactory(true);
            if (factory != null) {
                factory.setProjectionViewer(this.fViewer);
            }
            this.addAllAdapters();
        }
    }

    public void install(ProjectionViewer viewer) {
        if (this.isInstalled()) {
            this.uninstall();
        }
        this.fViewer = viewer;
        this.fViewer.addProjectionListener((IProjectionListener)this);
    }

    private boolean isInstalled() {
        return this.fViewer != null;
    }

    public void projectionDisabled() {
        ProjectionModelNodeAdapterFactoryXML factory = this.getAdapterFactory(false);
        if (factory != null) {
            factory.setProjectionViewer(null);
        }
        this.fDocument = null;
    }

    public void projectionEnabled() {
        this.initialize();
    }

    public void uninstall() {
        if (this.isInstalled()) {
            this.projectionDisabled();
            this.fViewer.removeProjectionListener((IProjectionListener)this);
            this.fViewer = null;
        }
    }
}

