/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.tabletree;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageSelectionProvider;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.common.ui.provisional.editors.PostMultiPageEditorSite;
import org.eclipse.wst.common.ui.provisional.editors.PostMultiPageSelectionProvider;
import org.eclipse.wst.common.ui.provisional.editors.PostSelectionMultiPageEditorPart;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.eclipse.wst.xml.ui.internal.tabletree.IDesignViewer;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLEditorMessages;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLMultiPageEditorActionBarContributor;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLTableTreeViewer;

public class XMLMultiPageEditorPart
extends PostSelectionMultiPageEditorPart {
    private int fDesignPageIndex;
    IDesignViewer fDesignViewer;
    private ActivationListener fActivationListener;
    IPropertyListener fPropertyListener = null;
    private int fSourcePageIndex;
    private StructuredTextEditor fTextEditor;
    private TextEditorPostSelectionAdapter fTextEditorSelectionListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    void _firePropertyChange(int property) {
        super.firePropertyChange(property);
    }

    private void addSourcePage() throws PartInitException {
        this.fSourcePageIndex = this.addPage((IEditorPart)this.fTextEditor, this.getEditorInput());
        this.setPageText(this.fSourcePageIndex, XMLEditorMessages.XMLMultiPageEditorPart_0);
        this.fTextEditor.update();
        this.firePropertyChange(1);
        this.fTextEditor.getTextViewer().addTextInputListener((ITextInputListener)new TextInputListener());
    }

    private void connectDesignPage() {
        if (this.fDesignViewer != null) {
            this.fDesignViewer.setDocument(this.getDocument());
        }
        if (this.fDesignViewer.getSelectionProvider() instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)this.fDesignViewer.getSelectionProvider()).addPostSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ((PostMultiPageSelectionProvider)XMLMultiPageEditorPart.this.getSite().getSelectionProvider()).firePostSelectionChanged(event);
                }
            });
        }
        this.fDesignViewer.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ((MultiPageSelectionProvider)XMLMultiPageEditorPart.this.getSite().getSelectionProvider()).fireSelectionChanged(event);
            }
        });
        if (this.fDesignViewer.getSelectionProvider() instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)this.fDesignViewer.getSelectionProvider()).addPostSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    XMLMultiPageEditorPart.this.getTextEditor().getSelectionProvider().setSelection(event.getSelection());
                }
            });
        } else {
            this.fDesignViewer.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    XMLMultiPageEditorPart.this.getTextEditor().getSelectionProvider().setSelection(event.getSelection());
                }
            });
        }
        this.fDesignViewer.getControl().addListener(8, new Listener(){

            public void handleEvent(Event event) {
                ISelection selection = XMLMultiPageEditorPart.this.fDesignViewer.getSelectionProvider().getSelection();
                int start = -1;
                int length = -1;
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    Object o = structuredSelection.getFirstElement();
                    Object o2 = null;
                    o2 = structuredSelection.size() > 1 ? structuredSelection.toArray()[structuredSelection.size() - 1] : o;
                    if (o instanceof IndexedRegion) {
                        start = ((IndexedRegion)o).getStartOffset();
                        length = ((IndexedRegion)o2).getEndOffset() - start;
                    } else if (o2 instanceof ITextRegion) {
                        start = ((ITextRegion)o).getStart();
                        length = ((ITextRegion)o2).getEnd() - start;
                    }
                } else if (selection instanceof ITextSelection) {
                    start = ((ITextSelection)selection).getOffset();
                    length = ((ITextSelection)selection).getLength();
                }
                if (start > -1 && length > -1) {
                    XMLMultiPageEditorPart.this.getTextEditor().selectAndReveal(start, length);
                }
            }
        });
        ISelectionProvider provider = this.getTextEditor().getSelectionProvider();
        if (this.fTextEditorSelectionListener == null) {
            this.fTextEditorSelectionListener = new TextEditorPostSelectionAdapter();
        }
        if (provider instanceof IPostSelectionProvider) {
            this.fTextEditorSelectionListener.forcePostSelection = false;
            ((IPostSelectionProvider)provider).addPostSelectionChangedListener((ISelectionChangedListener)this.fTextEditorSelectionListener);
        } else {
            this.fTextEditorSelectionListener.forcePostSelection = true;
            provider.addSelectionChangedListener((ISelectionChangedListener)this.fTextEditorSelectionListener);
        }
    }

    private void createAndAddDesignPage() {
        IDesignViewer designViewer;
        this.fDesignViewer = designViewer = this.createDesignPage();
        this.fDesignPageIndex = this.addPage(designViewer.getControl());
        this.setPageText(this.fDesignPageIndex, designViewer.getTitle());
    }

    protected IDesignViewer createDesignPage() {
        XMLTableTreeViewer tableTreeViewer = new XMLTableTreeViewer(this.getContainer());
        XMLUIPlugin.getInstance().getWorkbench().getHelpSystem().setHelp(tableTreeViewer.getControl(), "org.eclipse.wst.xml.ui.xmlm3000");
        return tableTreeViewer;
    }

    protected void createPages() {
        try {
            this.createSourcePage();
            this.createAndAddDesignPage();
            this.addSourcePage();
            this.connectDesignPage();
            int activePageIndex = this.getPreferenceStore().getInt("lastActivePage");
            if (activePageIndex >= 0 && activePageIndex < this.getPageCount()) {
                this.setActivePage(activePageIndex);
            } else {
                this.setActivePage(this.fSourcePageIndex);
            }
        }
        catch (PartInitException e) {
            Logger.logException(e);
            throw new RuntimeException(e);
        }
    }

    protected IEditorSite createSite(IEditorPart editor) {
        Object site = null;
        site = editor == this.fTextEditor ? new PostMultiPageEditorSite((MultiPageEditorPart)this, editor){

            public IEditorActionBarContributor getActionBarContributor() {
                IEditorActionBarContributor contributor = super.getActionBarContributor();
                IEditorActionBarContributor multiContributor = XMLMultiPageEditorPart.this.getEditorSite().getActionBarContributor();
                if (multiContributor instanceof XMLMultiPageEditorActionBarContributor) {
                    contributor = ((XMLMultiPageEditorActionBarContributor)multiContributor).sourceViewerActionContributor;
                }
                return contributor;
            }

            public String getId() {
                return String.valueOf(ContentTypeIdForXML.ContentTypeID_XML) + ".source";
            }
        } : super.createSite(editor);
        return site;
    }

    protected void createSourcePage() throws PartInitException {
        this.fTextEditor = this.createTextEditor();
        this.fTextEditor.setEditorPart((IEditorPart)this);
        if (this.fPropertyListener == null) {
            this.fPropertyListener = new PropertyListener();
        }
        this.fTextEditor.addPropertyListener(this.fPropertyListener);
    }

    private StructuredTextEditor createTextEditor() {
        return new StructuredTextEditor();
    }

    private void disconnectDesignPage() {
        if (this.fDesignViewer != null) {
            this.fDesignViewer.setDocument(null);
        }
    }

    public void dispose() {
        Logger.trace("Source Editor", "XMLMultiPageEditorPart::dispose entry");
        this.disconnectDesignPage();
        if (this.fActivationListener != null) {
            this.fActivationListener.dispose();
            this.fActivationListener = null;
        }
        if (this.fTextEditor != null && this.fPropertyListener != null) {
            this.fTextEditor.removePropertyListener(this.fPropertyListener);
        }
        super.dispose();
        Logger.trace("Source Editor", "StructuredTextMultiPageEditorPart::dispose exit");
    }

    public void doSave(IProgressMonitor monitor) {
        this.fTextEditor.doSave(monitor);
    }

    public void doSaveAs() {
        this.fTextEditor.doSaveAs();
    }

    public Object getAdapter(Class key) {
        Object result = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.ui.internal.tabletree.IDesignViewer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz) {
            result = this.fDesignViewer;
        } else {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.ui.ide.IGotoMarker");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (key.equals(clazz2)) {
                result = new IGotoMarker(){

                    public void gotoMarker(IMarker marker) {
                        XMLMultiPageEditorPart.this.gotoMarker(marker);
                    }
                };
            } else if (this.fTextEditor != null) {
                result = this.fTextEditor.getAdapter(key);
            }
        }
        return result;
    }

    private IDocument getDocument() {
        IDocument document = null;
        if (this.fTextEditor != null) {
            document = this.fTextEditor.getDocumentProvider().getDocument((Object)this.fTextEditor.getEditorInput());
        }
        return document;
    }

    private IPreferenceStore getPreferenceStore() {
        return XMLUIPlugin.getDefault().getPreferenceStore();
    }

    StructuredTextEditor getTextEditor() {
        return this.fTextEditor;
    }

    public String getTitle() {
        String title = null;
        if (this.getTextEditor() == null) {
            if (this.getEditorInput() != null) {
                title = this.getEditorInput().getName();
            }
        } else {
            title = this.getTextEditor().getTitle();
        }
        if (title == null) {
            title = this.getPartName();
        }
        return title;
    }

    void gotoMarker(IMarker marker) {
        this.setActivePage(this.fSourcePageIndex);
        IDE.gotoMarker((IEditorPart)this.fTextEditor, (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        try {
            super.init(site, input);
            this.fActivationListener = new ActivationListener(site.getWorkbenchWindow().getPartService());
        }
        catch (Exception e) {
            Logger.logException("exception initializing " + ((Object)((Object)this)).getClass().getName(), e);
        }
        this.setPartName(input.getName());
    }

    public boolean isSaveAsAllowed() {
        return this.fTextEditor != null && this.fTextEditor.isSaveAsAllowed();
    }

    public boolean isSaveOnCloseNeeded() {
        if (this.fTextEditor != null) {
            return this.fTextEditor.isSaveOnCloseNeeded();
        }
        return this.isDirty();
    }

    protected void pageChange(int newPageIndex) {
        ISelectionProvider selectionProvider;
        super.pageChange(newPageIndex);
        this.saveLastActivePageIndex(newPageIndex);
        if (newPageIndex == this.fDesignPageIndex && (selectionProvider = this.fDesignViewer.getSelectionProvider()) != null) {
            SelectionChangedEvent event = new SelectionChangedEvent(selectionProvider, selectionProvider.getSelection());
            ((MultiPageSelectionProvider)this.getSite().getSelectionProvider()).fireSelectionChanged(event);
            ((PostMultiPageSelectionProvider)this.getSite().getSelectionProvider()).firePostSelectionChanged(event);
        }
    }

    private void saveLastActivePageIndex(int newPageIndex) {
        this.getPreferenceStore().setValue("lastActivePage", newPageIndex);
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        if (this.fDesignViewer != null) {
            this.fDesignViewer.setDocument(this.getDocument());
        }
        this.setPartName(input.getName());
    }

    class ActivationListener
    implements IPartListener,
    IWindowListener {
        private IWorkbenchPart fActivePart;
        private boolean fIsHandlingActivation = false;
        private IPartService fPartService;

        public ActivationListener(IPartService partService) {
            this.fPartService = partService;
            this.fPartService.addPartListener((IPartListener)this);
            PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
        }

        public void dispose() {
            this.fPartService.removePartListener((IPartListener)this);
            PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
            this.fPartService = null;
        }

        public void partActivated(IWorkbenchPart part) {
            this.fActivePart = part;
            this.handleActivation();
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
            this.fActivePart = null;
        }

        public void partOpened(IWorkbenchPart part) {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void handleActivation() {
            if (this.fIsHandlingActivation) return;
            if (XMLMultiPageEditorPart.this.getTextEditor() == null) {
                return;
            }
            if (this.fActivePart != XMLMultiPageEditorPart.this) return;
            this.fIsHandlingActivation = true;
            try {
                XMLMultiPageEditorPart.this.getTextEditor().safelySanityCheckState(XMLMultiPageEditorPart.this.getEditorInput());
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                this.fIsHandlingActivation = false;
                throw throwable;
            }
            {
                Object var1_3 = null;
                this.fIsHandlingActivation = false;
                return;
            }
        }

        public void windowActivated(IWorkbenchWindow window) {
            if (window == XMLMultiPageEditorPart.this.getEditorSite().getWorkbenchWindow()) {
                window.getShell().getDisplay().asyncExec(new Runnable(this){
                    final /* synthetic */ ActivationListener this$1;
                    {
                        this.this$1 = activationListener;
                    }

                    public void run() {
                        this.this$1.handleActivation();
                    }
                });
            }
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
        }
    }

    private class TextEditorPostSelectionAdapter
    extends UIJob
    implements ISelectionChangedListener {
        boolean forcePostSelection = false;
        ISelection selection = null;

        public TextEditorPostSelectionAdapter() {
            super(XMLMultiPageEditorPart.this.getTitle());
            this.setUser(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (this.selection != null) {
                XMLMultiPageEditorPart.this.fDesignViewer.getSelectionProvider().setSelection(this.selection);
            }
            return Status.OK_STATUS;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (!(XMLMultiPageEditorPart.this.fDesignViewer == null || XMLMultiPageEditorPart.this.getActivePage() == XMLMultiPageEditorPart.this.fDesignPageIndex && ((Object)((Object)XMLMultiPageEditorPart.this)).equals(XMLMultiPageEditorPart.this.getSite().getPage().getActivePart()))) {
                if (this.forcePostSelection) {
                    this.selection = event.getSelection();
                    this.schedule(200L);
                } else {
                    XMLMultiPageEditorPart.this.fDesignViewer.getSelectionProvider().setSelection(event.getSelection());
                }
            }
        }
    }

    class PropertyListener
    implements IPropertyListener {
        static /* synthetic */ Class class$0;

        PropertyListener() {
        }

        public void propertyChanged(Object source, int propId) {
            switch (propId) {
                case 257: 
                case 258: {
                    if (source != XMLMultiPageEditorPart.this.getTextEditor() || XMLMultiPageEditorPart.this.getTextEditor().getEditorInput() == XMLMultiPageEditorPart.this.getEditorInput()) break;
                    XMLMultiPageEditorPart.this.setInput(XMLMultiPageEditorPart.this.getTextEditor().getEditorInput());
                    Runnable runnable = new Runnable(this){
                        final /* synthetic */ PropertyListener this$1;
                        {
                            this.this$1 = propertyListener;
                        }

                        public void run() {
                            PropertyListener.access$0(this.this$1)._firePropertyChange(1);
                        }
                    };
                    StructuredTextEditor structuredTextEditor = XMLMultiPageEditorPart.this.getTextEditor();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.swt.widgets.Control");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    ((Control)structuredTextEditor.getAdapter((Class)clazz)).getDisplay().asyncExec(runnable);
                    break;
                }
                case 1: {
                    if (source != XMLMultiPageEditorPart.this.getTextEditor() || XMLMultiPageEditorPart.this.getTextEditor().getEditorInput() == XMLMultiPageEditorPart.this.getEditorInput()) break;
                    XMLMultiPageEditorPart.this.setInput(XMLMultiPageEditorPart.this.getTextEditor().getEditorInput());
                    break;
                }
                default: {
                    if (source != XMLMultiPageEditorPart.this.getTextEditor()) break;
                    XMLMultiPageEditorPart.this._firePropertyChange(propId);
                }
            }
        }

        static /* synthetic */ XMLMultiPageEditorPart access$0(PropertyListener propertyListener) {
            return propertyListener.XMLMultiPageEditorPart.this;
        }
    }

    class TextInputListener
    implements ITextInputListener {
        TextInputListener() {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            if (XMLMultiPageEditorPart.this.fDesignViewer != null && newInput != null) {
                XMLMultiPageEditorPart.this.fDesignViewer.setDocument(newInput);
            }
        }
    }
}

