/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.validation;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.wst.xml.ui.internal.validation.ValidateAction;
import org.eclipse.wst.xml.ui.internal.validation.Validator;
import org.eclipse.wst.xml.ui.internal.validation.XMLValidationUIMessages;

public class ValidateXMLFileActionDelegate
implements IActionDelegate {
    protected ISelection selection;

    public void run(IAction action) {
        IFile fileResource = null;
        try {
            Class<?> theClass = Class.forName("org.apache.xerces.xni.parser.XMLParserConfiguration", true, this.getClass().getClassLoader());
            if (theClass == null) {
                throw new Exception("Missing Xerces jars in plugin's 'jars' folder");
            }
            if (!this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)this.selection;
                Object element = structuredSelection.getFirstElement();
                if (element instanceof IFile) {
                    fileResource = (IFile)element;
                } else {
                    return;
                }
            }
            if (fileResource != null) {
                ValidateAction validateAction = new ValidateAction(fileResource, true);
                validateAction.setValidator(new Validator());
                validateAction.run();
            }
        }
        catch (Exception exception) {
            String xercesLine1 = XMLValidationUIMessages.ValidateXMLFileActionDelegate_2;
            String xercesLine2 = XMLValidationUIMessages.ValidateXMLFileActionDelegate_3;
            String xercesLine3 = XMLValidationUIMessages.ValidateXMLFileActionDelegate_4;
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)XMLValidationUIMessages.ValidateXMLFileActionDelegate_5, (String)(String.valueOf(xercesLine1) + xercesLine2 + xercesLine3));
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }
}

