/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class DataModelManager {
    private IDataModel rootDataModel;
    private HashMap nestedModelEntries;

    public DataModelManager(IDataModel rootDataModel) {
        this.rootDataModel = rootDataModel;
        this.nestedModelEntries = new HashMap();
        Iterator names = this.rootDataModel.getNestedModelNames().iterator();
        while (names.hasNext()) {
            String nestedModelName = (String)names.next();
            this.nestedModelEntries.put(nestedModelName, new Integer(1));
        }
    }

    public IDataModel getDataModel() {
        return this.rootDataModel;
    }

    public void addNestedDataModel(String dataModelID) {
        Integer referenceCount = (Integer)this.nestedModelEntries.get(dataModelID);
        if (referenceCount == null) {
            IDataModel dataModel = DataModelFactory.createDataModel(dataModelID);
            if (dataModel != null) {
                this.rootDataModel.addNestedModel(dataModelID, dataModel);
                this.nestedModelEntries.put(dataModelID, new Integer(1));
            }
        } else {
            this.nestedModelEntries.put(dataModelID, new Integer(referenceCount + 1));
        }
    }

    public void removeNestedDataModel(String dataModelID) {
        Integer referenceCount = (Integer)this.nestedModelEntries.get(dataModelID);
        if (referenceCount != null) {
            int newRefCount = referenceCount - 1;
            if (newRefCount == 0) {
                this.nestedModelEntries.remove(dataModelID);
                this.rootDataModel.removeNestedModel(dataModelID);
            } else {
                this.nestedModelEntries.put(dataModelID, new Integer(newRefCount));
            }
        }
    }
}

