/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jst.j2ee.application.internal.operations.AddComponentToEnterpriseApplicationDataModelProvider;
import org.eclipse.jst.j2ee.application.internal.operations.RemoveComponentFromEnterpriseApplicationOperation;
import org.eclipse.jst.j2ee.internal.AvailableJ2EEComponentsForEARContentProvider;
import org.eclipse.jst.j2ee.internal.IJ2EEDependenciesControl;
import org.eclipse.jst.j2ee.internal.J2EEDependenciesPage;
import org.eclipse.jst.j2ee.internal.ManifestUIResourceHandler;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.project.facet.JavaProjectMigrationDataModelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.operation.CreateReferenceComponentsDataModelProvider;
import org.eclipse.wst.common.componentcore.internal.operation.RemoveReferenceComponentsDataModelProvider;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class AddModulestoEARPropertiesPage
implements IJ2EEDependenciesControl,
Listener {
    protected final IProject project;
    protected final J2EEDependenciesPage propPage;
    protected IVirtualComponent earComponent = null;
    protected Text componentNameText;
    protected Label availableModules;
    protected CheckboxTableViewer availableComponentsViewer;
    protected Button selectAllButton;
    protected Button deselectAllButton;
    protected Button externalJarButton;
    protected Button addVariableButton;
    protected Composite buttonColumn;
    protected List j2eeComponentList = new ArrayList();
    protected List javaProjectsList = new ArrayList();
    protected static final IStatus OK_STATUS = IDataModelProvider.OK_STATUS;

    public AddModulestoEARPropertiesPage(IProject project, J2EEDependenciesPage page) {
        this.project = project;
        this.propPage = page;
        this.earComponent = ComponentCore.createComponent((IProject)project);
    }

    public Composite createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        J2EEDependenciesPage.createDescriptionComposite(composite, ManifestUIResourceHandler.EAR_Modules_Desc);
        this.createListGroup(composite);
        this.refresh();
        return composite;
    }

    protected void createListGroup(Composite parent) {
        Composite listGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        listGroup.setLayout((Layout)layout);
        GridData gData = new GridData(1808);
        gData.horizontalIndent = 5;
        listGroup.setLayoutData((Object)gData);
        this.availableModules = new Label(listGroup, 0);
        gData = new GridData(272);
        this.availableModules.setText(J2EEUIMessages.getResourceString("AVAILABLE_J2EE_COMPONENTS"));
        this.availableModules.setLayoutData((Object)gData);
        this.createTableComposite(listGroup);
    }

    public boolean performOk() {
        NullProgressMonitor monitor = new NullProgressMonitor();
        this.addModulesToEAR((IProgressMonitor)monitor);
        this.removeModulesFromEAR((IProgressMonitor)monitor);
        return true;
    }

    public void performDefaults() {
    }

    public boolean performCancel() {
        return true;
    }

    public void dispose() {
    }

    public void setVisible(boolean visible) {
    }

    private List newJ2EEModulesToAdd() {
        ArrayList<IVirtualComponent> newComps = new ArrayList<IVirtualComponent>();
        if (this.j2eeComponentList != null && !this.j2eeComponentList.isEmpty()) {
            int i = 0;
            while (i < this.j2eeComponentList.size()) {
                IVirtualComponent handle = (IVirtualComponent)this.j2eeComponentList.get(i);
                if (!this.inEARAlready(handle)) {
                    newComps.add(handle);
                }
                ++i;
            }
        }
        return newComps;
    }

    private IStatus addModulesToEAR(IProgressMonitor monitor) {
        IStatus stat = OK_STATUS;
        try {
            if (this.earComponent != null) {
                List list = this.newJ2EEModulesToAdd();
                if (list != null && !list.isEmpty()) {
                    IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new AddComponentToEnterpriseApplicationDataModelProvider());
                    dm.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)this.earComponent);
                    dm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)list);
                    stat = dm.validateProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
                    if (stat != OK_STATUS) {
                        return stat;
                    }
                    dm.getDefaultOperation().execute(monitor, null);
                }
                if (!this.javaProjectsList.isEmpty()) {
                    int i = 0;
                    while (i < this.javaProjectsList.size()) {
                        IProject proj = (IProject)this.javaProjectsList.get(i);
                        IDataModel migrationdm = DataModelFactory.createDataModel((IDataModelProvider)new JavaProjectMigrationDataModelProvider());
                        migrationdm.setProperty("IJavaProjectMigrationDataModelProperties.PROJECT_NAME", (Object)proj.getName());
                        migrationdm.getDefaultOperation().execute(monitor, null);
                        IDataModel refdm = DataModelFactory.createDataModel((IDataModelProvider)new CreateReferenceComponentsDataModelProvider());
                        List targetCompList = (List)refdm.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
                        IVirtualComponent targetcomponent = ComponentCore.createComponent((IProject)proj);
                        targetCompList.add(targetcomponent);
                        refdm.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)this.earComponent);
                        refdm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)targetCompList);
                        refdm.getDefaultOperation().execute(monitor, null);
                        this.j2eeComponentList.add(targetcomponent);
                        ++i;
                    }
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger().log((Throwable)e);
        }
        return OK_STATUS;
    }

    private IStatus removeModulesFromEAR(IProgressMonitor monitor) {
        List list;
        IStatus stat = OK_STATUS;
        if (this.earComponent != null && this.j2eeComponentList != null && !(list = this.getComponentsToRemove()).isEmpty()) {
            try {
                RemoveComponentFromEnterpriseApplicationOperation op = this.removeComponentFromEAROperation(this.earComponent, list);
                op.execute(null, null);
            }
            catch (ExecutionException e) {
                Logger.getLogger().log((Throwable)e);
            }
        }
        return stat;
    }

    protected RemoveComponentFromEnterpriseApplicationOperation removeComponentFromEAROperation(IVirtualComponent sourceComponent, List targetComponentsHandles) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new RemoveReferenceComponentsDataModelProvider());
        model.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)sourceComponent);
        List modHandlesList = (List)model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
        modHandlesList.addAll(targetComponentsHandles);
        model.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)modHandlesList);
        return new RemoveComponentFromEnterpriseApplicationOperation(model);
    }

    protected List getComponentsToRemove() {
        ArrayList<IVirtualComponent> list = new ArrayList<IVirtualComponent>();
        if (this.earComponent != null && list != null) {
            IVirtualReference[] oldrefs = this.earComponent.getReferences();
            int j = 0;
            while (j < oldrefs.length) {
                IVirtualReference ref = oldrefs[j];
                IVirtualComponent handle = ref.getReferencedComponent();
                if (!this.j2eeComponentList.contains(handle)) {
                    list.add(handle);
                }
                ++j;
            }
        }
        return list;
    }

    public void handleEvent(Event event) {
        if (event.widget == this.selectAllButton) {
            this.handleSelectAllButtonPressed();
        } else if (event.widget == this.deselectAllButton) {
            this.handleDeselectAllButtonPressed();
        } else if (event.widget == this.externalJarButton) {
            this.handleSelectExternalJarButton();
        } else if (event.widget == this.addVariableButton) {
            this.handleSelectVariableButton();
        }
    }

    private void handleSelectAllButtonPressed() {
        this.availableComponentsViewer.setAllChecked(true);
        this.j2eeComponentList = this.getCheckedJ2EEElementsAsList();
        this.javaProjectsList = this.getCheckedJavaProjectsAsList();
    }

    private void handleDeselectAllButtonPressed() {
        this.availableComponentsViewer.setAllChecked(false);
        this.j2eeComponentList = new ArrayList();
        this.javaProjectsList = new ArrayList();
    }

    private void handleSelectExternalJarButton() {
        IPath[] selected = BuildPathDialogAccess.chooseExternalJAREntries((Shell)this.propPage.getShell());
        if (selected != null) {
            int i = 0;
            while (i < selected.length) {
                String type = "lib/";
                IVirtualComponent archive = ComponentCore.createArchiveComponent((IProject)this.earComponent.getProject(), (String)(String.valueOf(type) + selected[i].toString()));
                ArrayList<IVirtualReference> vlist = new ArrayList<IVirtualReference>();
                IVirtualReference ref = ComponentCore.createReference((IVirtualComponent)this.earComponent, (IVirtualComponent)archive);
                vlist.add(ref);
                IVirtualReference[] refs = vlist.toArray(new IVirtualReference[vlist.size()]);
                this.earComponent.addReferences(refs);
                this.j2eeComponentList.add(archive);
                ++i;
            }
            this.refresh();
        }
    }

    private void handleSelectVariableButton() {
        Path[] existingPath = new Path[]{};
        IPath[] paths = BuildPathDialogAccess.chooseVariableEntries((Shell)this.propPage.getShell(), (IPath[])existingPath);
        if (paths != null) {
            this.refresh();
            int i = 0;
            while (i < paths.length) {
                IPath resolvedPath = JavaCore.getResolvedVariablePath((IPath)paths[i]);
                File file = new File(resolvedPath.toOSString());
                if (file.isFile() && file.exists()) {
                    String type = "var/";
                    IVirtualComponent archive = ComponentCore.createArchiveComponent((IProject)this.earComponent.getProject(), (String)(String.valueOf(type) + paths[i].toString()));
                    ArrayList<IVirtualReference> vlist = new ArrayList<IVirtualReference>();
                    IVirtualReference[] oldrefs = this.earComponent.getReferences();
                    int j = 0;
                    while (j < oldrefs.length) {
                        IVirtualReference ref = oldrefs[j];
                        vlist.add(ref);
                        ++j;
                    }
                    IVirtualReference ref = ComponentCore.createReference((IVirtualComponent)this.earComponent, (IVirtualComponent)archive);
                    vlist.add(ref);
                    IVirtualReference[] refs = new IVirtualReference[vlist.size()];
                    int j2 = 0;
                    while (j2 < vlist.size()) {
                        IVirtualReference tmpref;
                        refs[j2] = tmpref = (IVirtualReference)vlist.get(j2);
                        ++j2;
                    }
                    this.earComponent.setReferences(refs);
                    this.j2eeComponentList.add(archive);
                }
                ++i;
            }
            this.refresh();
        }
    }

    protected void createTableComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gData = new GridData(1808);
        composite.setLayoutData((Object)gData);
        this.fillComposite(composite);
    }

    public void fillComposite(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(1808));
        this.createTable(parent);
        this.createButtonColumn(parent);
    }

    protected void createButtonColumn(Composite parent) {
        this.buttonColumn = this.createButtonColumnComposite(parent);
        GridData data = new GridData(128);
        this.buttonColumn.setLayoutData((Object)data);
        this.createPushButtons();
    }

    protected void createPushButtons() {
        this.selectAllButton = this.createPushButton(SELECT_ALL_BUTTON);
        this.deselectAllButton = this.createPushButton(DE_SELECT_ALL_BUTTON);
        this.externalJarButton = this.createPushButton(J2EEUIMessages.getResourceString("EXTERNAL_JAR"));
        this.addVariableButton = this.createPushButton(J2EEUIMessages.getResourceString("ADDVARIABLE"));
    }

    protected Button createPushButton(String label) {
        Button aButton = this.primCreatePushButton(label, this.buttonColumn);
        aButton.addListener(13, (Listener)this);
        aButton.setLayoutData((Object)new GridData(768));
        return aButton;
    }

    public Button primCreatePushButton(String label, Composite aButtonColumn) {
        Button aButton = new Button(aButtonColumn, 8);
        aButton.setText(label);
        return aButton;
    }

    public Composite createButtonColumnComposite(Composite parent) {
        Composite aButtonColumn = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        aButtonColumn.setLayout((Layout)layout);
        GridData data = new GridData(258);
        aButtonColumn.setLayoutData((Object)data);
        return aButtonColumn;
    }

    public Group createGroup(Composite parent) {
        return new Group(parent, 0);
    }

    protected void createTable(Composite parent) {
        this.availableComponentsViewer = this.createavailableComponentsViewer(parent);
        GridData gd = new GridData(1296);
        this.availableComponentsViewer.getTable().setLayoutData((Object)gd);
        if (this.earComponent != null) {
            int j2eeVersion = J2EEVersionUtil.convertVersionStringToInt((IVirtualComponent)this.earComponent);
            AvailableJ2EEComponentsForEARContentProvider provider = new AvailableJ2EEComponentsForEARContentProvider(this.earComponent, j2eeVersion);
            this.availableComponentsViewer.setContentProvider((IContentProvider)provider);
            this.availableComponentsViewer.setLabelProvider((IBaseLabelProvider)provider);
            this.addTableListeners();
        }
    }

    protected void addTableListeners() {
        this.addCheckStateListener();
    }

    protected void addCheckStateListener() {
        this.availableComponentsViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                AddModulestoEARPropertiesPage.this.j2eeComponentList = AddModulestoEARPropertiesPage.this.getCheckedJ2EEElementsAsList();
                AddModulestoEARPropertiesPage.this.javaProjectsList = AddModulestoEARPropertiesPage.this.getCheckedJavaProjectsAsList();
            }
        });
    }

    protected Object[] getComponentsInEar() {
        ArrayList<IVirtualComponent> list = new ArrayList<IVirtualComponent>();
        IVirtualReference[] refs = this.earComponent.getReferences();
        int i = 0;
        while (i < refs.length) {
            IVirtualReference ref = refs[i];
            list.add(ref.getReferencedComponent());
            ++i;
        }
        return list.toArray();
    }

    protected boolean inEARAlready(IVirtualComponent component) {
        IVirtualReference[] refs = this.earComponent.getReferences();
        int i = 0;
        while (i < refs.length) {
            IVirtualReference ref = refs[i];
            if (ref.getReferencedComponent().equals(component)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected List getCheckedJ2EEElementsAsList() {
        ArrayList<Object> list;
        Object[] elements = this.availableComponentsViewer.getCheckedElements();
        if (elements == null || elements.length == 0) {
            list = Collections.EMPTY_LIST;
        } else {
            list = new ArrayList<Object>();
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof IVirtualComponent) {
                    list.add(elements[i]);
                }
                ++i;
            }
        }
        return list;
    }

    protected List getCheckedJavaProjectsAsList() {
        ArrayList<Object> list;
        Object[] elements = this.availableComponentsViewer.getCheckedElements();
        if (elements == null || elements.length == 0) {
            list = Collections.EMPTY_LIST;
        } else {
            list = new ArrayList<Object>();
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof IProject) {
                    list.add(elements[i]);
                }
                ++i;
            }
        }
        return list;
    }

    public CheckboxTableViewer createavailableComponentsViewer(Composite parent) {
        int flags = 67618;
        Table table = new Table(parent, flags);
        this.availableComponentsViewer = new CheckboxTableViewer(table);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(200, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(200, true));
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.availableComponentsViewer.setSorter(null);
        TableColumn fileNameColumn = new TableColumn(table, 0, 0);
        fileNameColumn.setText(ManifestUIResourceHandler.JAR_Module_UI_);
        fileNameColumn.setResizable(true);
        TableColumn projectColumn = new TableColumn(table, 0, 1);
        projectColumn.setText(ManifestUIResourceHandler.Project_UI_);
        projectColumn.setResizable(true);
        tableLayout.layout((Composite)table, true);
        return this.availableComponentsViewer;
    }

    public void refresh() {
        IWorkspaceRoot input = ResourcesPlugin.getWorkspace().getRoot();
        this.availableComponentsViewer.setInput((Object)input);
        GridData data = new GridData(1808);
        int numlines = Math.min(10, this.availableComponentsViewer.getTable().getItemCount());
        data.heightHint = this.availableComponentsViewer.getTable().getItemHeight() * numlines;
        this.availableComponentsViewer.getTable().setLayoutData((Object)data);
        TableItem[] items = this.availableComponentsViewer.getTable().getItems();
        ArrayList<IVirtualComponent> list = new ArrayList<IVirtualComponent>();
        Object[] comps = this.getComponentsInEar();
        int i = 0;
        while (i < items.length) {
            Object element = items[i].getData();
            if (element instanceof IVirtualComponent) {
                IVirtualComponent comp = (IVirtualComponent)element;
                int j = 0;
                while (j < comps.length) {
                    IVirtualComponent tempcomp = (IVirtualComponent)comps[j];
                    if (comp.equals(tempcomp)) {
                        list.add(comp);
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.availableComponentsViewer.setCheckedElements(list.toArray());
        this.j2eeComponentList.addAll(list);
        GridData btndata = new GridData(258);
        this.buttonColumn.setLayoutData((Object)btndata);
    }
}

