/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.server.core.PublishUtil;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServerBehaviour;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.PublishOperation;
import org.eclipse.wst.server.core.util.ProjectModule;

public class PublishOperation2
extends PublishOperation {
    protected TomcatServerBehaviour server;
    protected IModule[] module;
    protected int kind;
    protected int deltaKind;
    static /* synthetic */ Class class$0;

    public PublishOperation2(TomcatServerBehaviour server, int kind, IModule[] module, int deltaKind) {
        super("Publish to server", "Publish Web module to Tomcat server");
        this.server = server;
        this.module = module;
        this.kind = kind;
        this.deltaKind = deltaKind;
    }

    public int getOrder() {
        return 0;
    }

    public int getKind() {
        return 2;
    }

    public void execute(IProgressMonitor monitor, IAdaptable info) throws CoreException {
        if (this.module.length == 1) {
            this.publishDir(this.module[0], monitor);
        } else {
            this.publishJar(monitor);
        }
        this.server.setModulePublishState2(this.module, 1);
    }

    private void publishDir(IModule module2, IProgressMonitor monitor) throws CoreException {
        IPath path = this.server.getTempDirectory().append("webapps");
        path = path.append(module2.getName());
        if (this.kind == 4 || this.deltaKind == 3) {
            PublishUtil.deleteDirectory((File)path.toFile(), (IProgressMonitor)monitor);
            if (this.deltaKind == 3) {
                return;
            }
        }
        if (this.kind == 4 || this.kind == 2) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.server.core.util.ProjectModule");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ProjectModule pm = (ProjectModule)module2.loadAdapter((Class)clazz, monitor);
            IModuleResource[] mr = pm.members();
            PublishUtil.copy((IModuleResource[])mr, (IPath)path);
            return;
        }
        IModuleResourceDelta[] delta = this.server.getPublishedResourceDelta(this.module);
        int size = delta.length;
        int i = 0;
        while (i < size) {
            PublishUtil.handleDelta((int)this.kind, (IPath)path, (IModuleResourceDelta)delta[i]);
            ++i;
        }
    }

    private void publishJar(IProgressMonitor monitor) throws CoreException {
        IModuleResourceDelta[] delta;
        IPath path = this.server.getTempDirectory().append("webapps");
        path = path.append(this.module[0].getName()).append("WEB-INF").append("lib");
        IPath jarPath = path.append(String.valueOf(this.module[1].getName()) + ".jar");
        if (this.kind == 4 || this.deltaKind == 3) {
            if (jarPath.toFile().exists()) {
                jarPath.toFile().delete();
            }
            if (this.deltaKind == 3) {
                return;
            }
        }
        if (this.kind != 4 && this.kind != 2 && ((delta = this.server.getPublishedResourceDelta(this.module)) == null || delta.length == 0)) {
            return;
        }
        if (!path.toFile().exists()) {
            path.toFile().mkdirs();
        }
        IModule iModule = this.module[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.server.core.util.ProjectModule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ProjectModule pm = (ProjectModule)iModule.loadAdapter((Class)clazz, monitor);
        IModuleResource[] mr = pm.members();
        PublishUtil.createZipFile((IModuleResource[])mr, (IPath)jarPath);
    }
}

