/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.catalog;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.catalog.CatalogContributorRegistryReader;
import org.eclipse.wst.xml.core.internal.catalog.CatalogElement;
import org.eclipse.wst.xml.core.internal.catalog.CatalogEntry;
import org.eclipse.wst.xml.core.internal.catalog.CatalogEvent;
import org.eclipse.wst.xml.core.internal.catalog.CatalogSet;
import org.eclipse.wst.xml.core.internal.catalog.CatalogWriter;
import org.eclipse.wst.xml.core.internal.catalog.NextCatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogElement;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEvent;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogListener;
import org.eclipse.wst.xml.core.internal.catalog.provisional.INextCatalog;

public class Catalog
implements ICatalog {
    public static final String DEFAULT_CATALOG_FILE = "default_catalog.xml";
    public static final String SYSTEM_CATALOG_FILE = "system_catalog.xml";
    public static final String USER_CATALOG_FILE = "user_catalog.xml";
    protected String base;
    protected List catalogElements = new ArrayList();
    protected CatalogLS catalogLS;
    protected String id;
    protected InternalResolver internalResolver;
    protected boolean isNotificationEnabled;
    protected List listenerList = new ArrayList();
    protected String location;
    protected CatalogSet resourceSet;

    public Catalog(CatalogSet catalogResourceSet, String id, String location) {
        this.resourceSet = catalogResourceSet;
        this.id = id;
        this.location = location;
        this.catalogLS = "default_catalog".equals(id) ? new DefaultCatalogLS() : ("system_catalog".equals(id) ? new SystemCatalogLS() : new UserCatalogLS());
    }

    public void addCatalogElement(ICatalogElement element) {
        this.catalogElements.add(element);
        element.setOwnerCatalog(this);
        this.internalResolver = null;
        this.notifyAddElement(element);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addEntriesFromCatalog(ICatalog catalog) {
        try {
            this.setNotificationEnabled(false);
            if (catalog != null) {
                ICatalogElement[] entries = ((Catalog)catalog).getCatalogElements();
                int i = 0;
                while (i < entries.length) {
                    CatalogElement clone = (CatalogElement)((CatalogElement)entries[i]).clone();
                    this.addCatalogElement(clone);
                    ++i;
                }
            } else {
                Logger.log(4, "argument was null in Catalog.addEntriesFromCatalog");
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.setNotificationEnabled(true);
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.setNotificationEnabled(true);
            this.internalResolver = null;
            this.notifyChanged();
            return;
        }
    }

    public void addListener(ICatalogListener listener) {
        this.listenerList.add(listener);
    }

    public void clear() {
        this.catalogElements.clear();
        this.internalResolver = null;
        this.notifyChanged();
    }

    public ICatalogElement createCatalogElement(int type) {
        switch (type) {
            case 1: {
                return new CatalogEntry();
            }
            case 10: {
                return new NextCatalog();
            }
            case 2: {
                return new CatalogEntry(2);
            }
            case 3: {
                return new CatalogEntry(3);
            }
            case 4: {
                return new CatalogEntry(4);
            }
        }
        return new CatalogElement(type);
    }

    public String getBase() {
        return this.base;
    }

    private List getCatalogElements(int type) {
        ArrayList<ICatalogElement> result = new ArrayList<ICatalogElement>();
        ICatalogElement[] elements = this.catalogElements.toArray(new ICatalogElement[this.catalogElements.size()]);
        int i = 0;
        while (i < elements.length) {
            ICatalogElement element = elements[i];
            if (element.getType() == type) {
                result.add(element);
            }
            ++i;
        }
        return result;
    }

    public ICatalogEntry[] getCatalogEntries() {
        List result = this.getCatalogElements(1);
        return result.toArray(new ICatalogEntry[result.size()]);
    }

    protected CatalogSet getCatalogSet() {
        return this.resourceSet;
    }

    public String getId() {
        return this.id;
    }

    public String getLocation() {
        return this.location;
    }

    public INextCatalog[] getNextCatalogs() {
        List result = this.getCatalogElements(10);
        return result.toArray(new INextCatalog[result.size()]);
    }

    protected InternalResolver getOrCreateInternalResolver() {
        if (this.internalResolver == null) {
            this.internalResolver = new InternalResolver();
        }
        return this.internalResolver;
    }

    protected boolean isNotificationEnabled() {
        return this.isNotificationEnabled;
    }

    public void load() throws IOException {
        this.catalogLS.load();
    }

    protected void notifyAddElement(ICatalogElement entry) {
        if (this.isNotificationEnabled) {
            CatalogEvent event = new CatalogEvent(this, entry, 1);
            this.notifyListeners(event);
        }
    }

    protected void notifyChanged() {
        CatalogEvent event = new CatalogEvent(this, null, 0);
        this.notifyListeners(event);
    }

    protected void notifyListeners(ICatalogEvent event) {
        ArrayList list = new ArrayList();
        list.addAll(this.listenerList);
        Iterator i = list.iterator();
        while (i.hasNext()) {
            ICatalogListener listener = (ICatalogListener)i.next();
            listener.catalogChanged(event);
        }
    }

    protected void notifyRemoveElement(ICatalogElement element) {
        if (this.isNotificationEnabled) {
            CatalogEvent event = new CatalogEvent(this, element, 2);
            this.notifyListeners(event);
        }
    }

    public void removeCatalogElement(ICatalogElement element) {
        this.catalogElements.remove(element);
        this.internalResolver = null;
        this.notifyRemoveElement(element);
    }

    public void removeListener(ICatalogListener listener) {
        this.listenerList.remove(listener);
    }

    public String resolvePublic(String publicId, String systemId) throws MalformedURLException, IOException {
        return this.getOrCreateInternalResolver().resolvePublic(publicId, systemId);
    }

    protected String resolveSubordinateCatalogs(int entryType, String publicId, String systemId) throws MalformedURLException, IOException {
        String result = null;
        INextCatalog[] nextCatalogs = this.getNextCatalogs();
        int i = 0;
        while (i < nextCatalogs.length) {
            INextCatalog nextCatalog = nextCatalogs[i];
            ICatalog catalog = nextCatalog.getReferencedCatalog();
            if (catalog != null) {
                switch (entryType) {
                    case 2: {
                        result = catalog.resolvePublic(publicId, systemId);
                        break;
                    }
                    case 3: {
                        result = catalog.resolveSystem(systemId);
                        break;
                    }
                    case 4: {
                        result = catalog.resolveURI(systemId);
                        break;
                    }
                }
                if (result != null) {
                    return result;
                }
            }
            ++i;
        }
        return null;
    }

    public String resolveSystem(String systemId) throws MalformedURLException, IOException {
        return this.getOrCreateInternalResolver().resolveSystem(systemId);
    }

    public String resolveURI(String uri) throws MalformedURLException, IOException {
        return this.getOrCreateInternalResolver().resolveURI(uri);
    }

    public void save() throws IOException {
        this.catalogLS.save();
    }

    public void setBase(String base) {
        this.base = base;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    protected void setNotificationEnabled(boolean b) {
        this.isNotificationEnabled = b;
    }

    public ICatalogElement[] getCatalogElements() {
        return this.catalogElements.toArray(new ICatalogElement[this.catalogElements.size()]);
    }

    class CatalogLS {
        CatalogLS() {
        }

        public void load() {
        }

        public void save() {
            try {
                new CatalogWriter().write((ICatalog)Catalog.this, Catalog.this.location);
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }
    }

    class DefaultCatalogLS
    extends CatalogLS {
        DefaultCatalogLS() {
        }

        public void load() {
            NextCatalog userCatalogReference = new NextCatalog();
            userCatalogReference.setId("user_catalog");
            userCatalogReference.setCatalogLocation(Catalog.USER_CATALOG_FILE);
            Catalog.this.addCatalogElement(userCatalogReference);
            NextCatalog systemCatalogReference = new NextCatalog();
            systemCatalogReference.setId("system_catalog");
            systemCatalogReference.setCatalogLocation(Catalog.SYSTEM_CATALOG_FILE);
            Catalog.this.addCatalogElement(systemCatalogReference);
            this.save();
        }
    }

    class InternalResolver {
        protected Map publicMap = new HashMap();
        protected Map systemMap = new HashMap();
        protected Map uriMap = new HashMap();

        InternalResolver() {
            Iterator i = Catalog.this.catalogElements.iterator();
            while (i.hasNext()) {
                ICatalogElement catalogElement = (ICatalogElement)i.next();
                if (catalogElement.getType() != 1) continue;
                ICatalogEntry entry = (ICatalogEntry)catalogElement;
                Map map = this.getEntryMap(entry.getEntryType());
                map.put(entry.getKey(), entry);
            }
        }

        private Map getEntryMap(int entryType) {
            Map map = this.systemMap;
            switch (entryType) {
                case 2: {
                    map = this.publicMap;
                    break;
                }
                case 4: {
                    map = this.uriMap;
                    break;
                }
            }
            return map;
        }

        protected String getMappedURI(Map map, String key) {
            CatalogEntry entry = (CatalogEntry)map.get(key);
            if (entry == null) {
                return null;
            }
            String uri = entry.getURI();
            try {
                String FILE_SCHEME;
                URL entryURL;
                if (uri.startsWith("platform:") && (uri = Platform.resolve((URL)(entryURL = new URL(entry.getAbsolutePath(uri)))).toString()).startsWith(FILE_SCHEME = "file:") && !uri.startsWith(String.valueOf(FILE_SCHEME) + "/")) {
                    uri = String.valueOf(FILE_SCHEME) + "///" + uri.substring(FILE_SCHEME.length());
                }
                return uri;
            }
            catch (IOException iOException) {
                return null;
            }
        }

        public String resolvePublic(String publicId, String systemId) throws MalformedURLException, IOException {
            String result = this.getMappedURI(this.publicMap, publicId);
            if (result == null) {
                result = this.getMappedURI(this.systemMap, systemId);
            }
            if (result == null) {
                result = this.getMappedURI(this.uriMap, publicId);
            }
            if (result == null) {
                result = Catalog.this.resolveSubordinateCatalogs(2, publicId, systemId);
            }
            return result;
        }

        public String resolveSystem(String systemId) throws MalformedURLException, IOException {
            String result = this.getMappedURI(this.systemMap, systemId);
            if (result == null) {
                result = Catalog.this.resolveSubordinateCatalogs(3, null, systemId);
            }
            return result;
        }

        public String resolveURI(String uri) throws MalformedURLException, IOException {
            String result = this.getMappedURI(this.uriMap, uri);
            if (result == null) {
                result = Catalog.this.resolveSubordinateCatalogs(4, null, uri);
            }
            return result;
        }
    }

    class SystemCatalogLS
    extends CatalogLS {
        SystemCatalogLS() {
        }

        public void load() {
            new CatalogContributorRegistryReader(Catalog.this).readRegistry();
            this.save();
        }
    }

    class UserCatalogLS
    extends CatalogLS {
        UserCatalogLS() {
        }

        /*
         * Exception decompiling
         */
        public void load() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [1 : 76->79)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

