/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.validation.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.QualifiedName;

public class ValidationMessage {
    public static final QualifiedName ERROR_MESSAGE_MAP_QUALIFIED_NAME = new QualifiedName("org.eclipse.wst.xml.validation", "errorMessageMap");
    protected String message;
    protected int lineNumber;
    protected int columnNumber;
    protected String uri;
    protected List nestedErrors;
    protected String key;
    protected Object[] messageArguments;
    protected int startOffset;
    protected int severity = 2;
    public static int SEV_HIGH = 1;
    public static int SEV_NORMAL = 2;
    public static int SEV_LOW = 4;

    public ValidationMessage(String message, int lineNumber, int columnNumber) {
        this(message, lineNumber, columnNumber, null);
    }

    public ValidationMessage(String message, int lineNumber, int columnNumber, String uri) {
        this(message, lineNumber, columnNumber, uri, null, null);
    }

    public ValidationMessage(String message, int lineNumber, int columnNumber, String uri, String key, Object[] messageArguments) {
        this.message = message;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.uri = uri;
        this.key = key;
        this.messageArguments = messageArguments;
        this.startOffset = 0;
    }

    public String getMessage() {
        return this.message;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getUri() {
        return this.uri;
    }

    public void addNestedMessage(ValidationMessage validationMessage) {
        if (this.nestedErrors == null) {
            this.nestedErrors = new ArrayList();
        }
        this.nestedErrors.add(validationMessage);
        int validaitonmessageSeverity = validationMessage.getSeverity();
        if (validaitonmessageSeverity == SEV_NORMAL || validaitonmessageSeverity == SEV_HIGH) {
            this.setSeverity(SEV_NORMAL);
        }
    }

    public List getNestedMessages() {
        return this.nestedErrors != null ? this.nestedErrors : Collections.EMPTY_LIST;
    }

    public int getSeverity() {
        return this.severity;
    }

    public void setSeverity(int sev) {
        this.severity = sev;
    }

    public void setStartOffset(int offset) {
        this.startOffset = offset;
    }

    public String getKey() {
        return this.key;
    }

    public Object[] getMessageArguments() {
        return this.messageArguments;
    }
}

