/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.command;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.jst.ws.internal.consumption.ConsumptionMessages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.core.common.ProgressUtils;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;

public class PublishProjectCommand
extends AbstractDataModelOperation {
    private String project;
    private String serverTypeID;
    private IServer existingServer;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = this.getEnvironment();
        IStatus status = Status.OK_STATUS;
        try {
            IStatus returnedStatus;
            ProgressUtils.report((IProgressMonitor)monitor, (String)ConsumptionMessages.PROGRESS_INFO_PUBLISH_WEB_PROJECT);
            if (this.project == null) {
                status = StatusUtils.errorStatus((String)ConsumptionMessages.MSG_ERROR_PROJECT_NOT_FOUND);
                env.getStatusHandler().reportError(status);
                return status;
            }
            IProject iProject = (IProject)ResourceUtils.findResource((String)this.project);
            IServer instance = ServerUtils.getServerForModule((IModule)ServerUtils.getModule((IProject)iProject), (String)this.serverTypeID, (IServer)this.existingServer, (boolean)true, (IProgressMonitor)monitor);
            if (instance == null) {
                status = StatusUtils.errorStatus((String)ConsumptionMessages.MSG_ERROR_INSTANCE_NOT_FOUND);
                env.getStatusHandler().reportError(status);
                return status;
            }
            status = returnedStatus = this.publish(instance, 1, monitor);
            env.getLog().log(0, 5026, (Object)this, "execute", (Object)new String("project=" + this.project + " successfully published"));
            return status;
        }
        catch (Exception e) {
            status = StatusUtils.errorStatus((String)ConsumptionMessages.MSG_ERROR_PUBLISH, (Throwable)e);
            env.getStatusHandler().reportError(status);
            return status;
        }
    }

    private IStatus publish(final IServer server, final int kind, IProgressMonitor monitor) {
        final IStatus[] istatus = new IStatus[]{Status.OK_STATUS};
        monitor.subTask(ConsumptionMessages.PROGRESS_INFO_PUBLISHING_SERVER);
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor shellMonitor) throws InvocationTargetException, InterruptedException {
                istatus[0] = server.publish(kind, shellMonitor);
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, false, runnable);
        }
        catch (InvocationTargetException ite) {
            istatus[0] = new Status(4, "id", 0, ite.getMessage(), (Throwable)ite);
            ite.printStackTrace();
        }
        catch (InterruptedException ie) {
            istatus[0] = new Status(4, "id", 0, ie.getMessage(), (Throwable)ie);
            ie.printStackTrace();
        }
        return istatus[0];
    }

    public void setProject(String project) {
        this.project = project;
    }

    public void setServerTypeID(String serverTypeID) {
        this.serverTypeID = serverTypeID;
    }

    public void setExistingServer(IServer existingServer) {
        this.existingServer = existingServer;
    }
}

