/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.object.ValidateWSDLJob;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.Choice;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.plugin.WSPlugin;

public class CheckWSDLValidationCommand
extends AbstractDataModelOperation {
    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = this.getEnvironment();
        IJobManager jobManager = Platform.getJobManager();
        Job[] jobs = jobManager.find((Object)"ValidateWSDLJobJamily");
        ValidateWSDLJob existingValidateWSDLJob = null;
        if (jobs.length > 0) {
            int i = 0;
            while (i < jobs.length) {
                existingValidateWSDLJob = (ValidateWSDLJob)jobs[i];
                if (existingValidateWSDLJob.getState() != 0) {
                    if (this.ignoreWSDLValidation(env)) {
                        existingValidateWSDLJob.cancel();
                        return Status.OK_STATUS;
                    }
                    return StatusUtils.errorStatus((String)ConsumptionUIMessages.WAIT_FOR_WSDL);
                }
                ++i;
            }
        }
        return Status.OK_STATUS;
    }

    private boolean ignoreWSDLValidation(IEnvironment env) {
        if (!WSPlugin.getInstance().getWaitForWSDLValidationContext().getPersistentWaitForWSDLValidation()) {
            return true;
        }
        IStatus status_ = StatusUtils.warningStatus((String)ConsumptionUIMessages.STILL_VALIDATING_WSDL);
        Choice ignoreChoice = new Choice('C', ConsumptionUIMessages.CANCEL_VALIDATION_LABEL, ConsumptionUIMessages.CANCEL_VALIDATION_DESCRIPTION);
        Choice ignoreAllChoice = new Choice('A', ConsumptionUIMessages.CANCEL_ALL_VALIDATION_LABEL, ConsumptionUIMessages.CANCEL_ALL_VALIDATION_DESCRIPTION);
        Choice cancelChoice = new Choice('W', ConsumptionUIMessages.WAIT_VALIDATION_LABEL, ConsumptionUIMessages.WAIT_VALIDATION_DESCRIPTION);
        Choice result = env.getStatusHandler().report(status_, new Choice[]{ignoreChoice, ignoreAllChoice, cancelChoice});
        if (result == null || result.getLabel().equals(ignoreChoice.getLabel())) {
            return true;
        }
        if (result.getLabel().equals(ignoreAllChoice.getLabel())) {
            WSPlugin.getInstance().getWaitForWSDLValidationContext().setWaitForWSDLValidation(false);
            return true;
        }
        return !result.getLabel().equals(cancelChoice.getLabel());
    }
}

