/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.object;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.wst.command.internal.env.core.data.Transformer;

public class JavaBeanSelectionTransformer
implements Transformer {
    public Object transform(Object value) {
        if (value instanceof IStructuredSelection) {
            IResource res;
            Object sel = ((IStructuredSelection)value).getFirstElement();
            if (sel instanceof IFile) {
                return new StructuredSelection((Object)this.computeFullyQualifiedJavaName((IFile)sel));
            }
            if (sel instanceof ICompilationUnit && (res = ((ICompilationUnit)sel).getResource()) instanceof IFile) {
                return new StructuredSelection((Object)this.computeFullyQualifiedJavaName((IFile)res));
            }
        }
        return value;
    }

    private String computeFullyQualifiedJavaName(IFile resource) {
        IPath path = resource.getFullPath();
        String basename = path.lastSegment();
        String beanClass = "";
        if (basename != null && basename.length() > 0) {
            String beanPackage = ResourceUtils.getJavaResourcePackageName((IPath)path);
            String string = beanClass = beanPackage == null || beanPackage.length() == 0 ? basename : String.valueOf(beanPackage) + "." + basename;
            if (beanClass.toLowerCase().endsWith(".java") || beanClass.toLowerCase().endsWith(".class")) {
                beanClass = beanClass.substring(0, beanClass.lastIndexOf(46));
            }
        }
        return beanClass;
    }
}

