/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.PDECore;

public class PDEClasspathContainer {
    private static HashMap ACCESSIBLE_RULES = new HashMap();
    private static HashMap DISCOURAGED_RULES = new HashMap();
    private static final IAccessRule EXCLUDE_ALL_RULE = JavaCore.newAccessRule((IPath)new Path("**/*"), (int)1);

    protected void addProjectEntry(IProject project, Rule[] rules, ArrayList entries) throws CoreException {
        if (project.hasNature("org.eclipse.jdt.core.javanature")) {
            IClasspathEntry entry = null;
            if (rules != null) {
                IAccessRule[] accessRules = this.getAccessRules(rules);
                entry = JavaCore.newProjectEntry((IPath)project.getFullPath(), (IAccessRule[])accessRules, (boolean)true, (IClasspathAttribute[])new IClasspathAttribute[0], (boolean)false);
            } else {
                entry = JavaCore.newProjectEntry((IPath)project.getFullPath());
            }
            if (!entries.contains(entry)) {
                entries.add(entry);
            }
        }
    }

    protected void addExternalPlugin(IPluginModelBase model, Rule[] rules, ArrayList entries) throws CoreException {
        if (new File(model.getInstallLocation()).isFile()) {
            IPath srcPath = ClasspathUtilCore.getSourceAnnotation(model, ".");
            if (srcPath == null) {
                srcPath = new Path(model.getInstallLocation());
            }
            this.addLibraryEntry((IPath)new Path(model.getInstallLocation()), srcPath, rules, entries);
        } else {
            IPluginLibrary[] libraries = model.getPluginBase().getLibraries();
            int i = 0;
            while (i < libraries.length) {
                if (!"resource".equals(libraries[i].getType())) {
                    String name;
                    String expandedName;
                    model = (IPluginModelBase)libraries[i].getModel();
                    IPath path = this.getPath(model, expandedName = ClasspathUtilCore.expandLibraryName(name = libraries[i].getName()));
                    if (path == null && !model.isFragmentModel() && ClasspathUtilCore.containsVariables(name) && (model = this.resolveLibraryInFragments(model, expandedName)) != null) {
                        path = this.getPath(model, expandedName);
                    }
                    if (path != null && !path.toFile().isDirectory()) {
                        this.addLibraryEntry(path, ClasspathUtilCore.getSourceAnnotation(model, expandedName), rules, entries);
                    }
                }
                ++i;
            }
        }
    }

    protected void addLibraryEntry(IPath path, IPath srcPath, Rule[] rules, ArrayList entries) {
        IClasspathEntry entry = null;
        entry = rules != null ? JavaCore.newLibraryEntry((IPath)path, (IPath)srcPath, null, (IAccessRule[])this.getAccessRules(rules), (IClasspathAttribute[])new IClasspathAttribute[0], (boolean)false) : JavaCore.newLibraryEntry((IPath)path, (IPath)srcPath, null);
        if (!entries.contains(entry)) {
            entries.add(entry);
        }
    }

    protected IAccessRule[] getAccessRules(Rule[] rules) {
        IAccessRule[] accessRules = new IAccessRule[rules.length + 1];
        int i = 0;
        while (i < rules.length) {
            Rule rule = rules[i];
            accessRules[i] = rule.discouraged ? PDEClasspathContainer.getDiscouragedRule(rule.path) : PDEClasspathContainer.getAccessibleRule(rule.path);
            ++i;
        }
        accessRules[rules.length] = EXCLUDE_ALL_RULE;
        return accessRules;
    }

    private static synchronized IAccessRule getAccessibleRule(IPath path) {
        IAccessRule rule = (IAccessRule)ACCESSIBLE_RULES.get(path);
        if (rule == null) {
            rule = JavaCore.newAccessRule((IPath)path, (int)0);
            ACCESSIBLE_RULES.put(path, rule);
        }
        return rule;
    }

    private static synchronized IAccessRule getDiscouragedRule(IPath path) {
        IAccessRule rule = (IAccessRule)DISCOURAGED_RULES.get(path);
        if (rule == null) {
            rule = JavaCore.newAccessRule((IPath)path, (int)2);
            DISCOURAGED_RULES.put(path, rule);
        }
        return rule;
    }

    protected IPath getPath(IPluginModelBase model, String libraryName) {
        IResource resource = model.getUnderlyingResource();
        if (resource != null) {
            IResource jarFile = resource.getProject().findMember(libraryName);
            return jarFile != null ? jarFile.getFullPath() : null;
        }
        File file = new File(model.getInstallLocation(), libraryName);
        return file.exists() ? new Path(file.getAbsolutePath()) : null;
    }

    protected IPluginModelBase resolveLibraryInFragments(IPluginModelBase model, String libraryName) {
        BundleDescription desc = model.getBundleDescription();
        if (desc != null) {
            BundleDescription[] fragments = desc.getFragments();
            int i = 0;
            while (i < fragments.length) {
                if (new File(fragments[i].getLocation(), libraryName).exists()) {
                    return PDECore.getDefault().getModelManager().findModel(fragments[i]);
                }
                ++i;
            }
        }
        return null;
    }

    class Rule {
        IPath path;
        boolean discouraged;

        Rule() {
        }
    }
}

