/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.bundle;

import java.io.Serializable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;

public class BundleObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient IBundleModel model;

    protected void ensureModelEditable() throws CoreException {
        if (!this.model.isEditable()) {
            this.throwCoreException(PDECoreMessages.BundleObject_readOnlyException);
        }
    }

    public IBundleModel getModel() {
        return this.model;
    }

    public void setModel(IBundleModel newModel) {
        this.model = newModel;
    }

    protected void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, PDECore.getPluginId(), 0, message, null);
        throw new CoreException((IStatus)status);
    }

    protected void fireStructureChanged(BundleObject child, int changeType) {
        if (this.model.isEditable()) {
            ModelChangedEvent e = new ModelChangedEvent(this.model, changeType, new Object[]{child}, null);
            this.fireModelChanged(e);
        }
    }

    protected void fireModelChanged(IModelChangedEvent e) {
        if (this.model.isEditable()) {
            IBundleModel provider = this.model;
            provider.fireModelChanged(e);
        }
    }

    protected void firePropertyChanged(BundleObject object, String property, Object oldValue, Object newValue) {
        if (this.model.isEditable()) {
            IBundleModel provider = this.model;
            provider.fireModelObjectChanged(object, property, oldValue, newValue);
        }
    }
}

