/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.outputview;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import org.eclipse.wst.rdb.data.internal.core.common.data.DataSerializer;
import org.eclipse.wst.rdb.data.internal.core.common.data.ResultSetReader;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.outputview.OutputViewPlugin;
import org.eclipse.wst.rdb.internal.outputview.ProcedureCallCache;
import org.eclipse.wst.rdb.internal.outputview.ResultTableRow;

public class ResultTableModel {
    protected String[] columnNames;
    protected ArrayList tableRows;
    protected int numRows;
    protected int columnCount;
    protected boolean haveRS = false;
    protected int[] columnTypes;
    protected int[] columnLengths;
    protected char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public ResultTableModel() {
        this.haveRS = false;
        this.numRows = 0;
        this.columnCount = 0;
        this.tableRows = new ArrayList();
    }

    public ResultTableModel(ResultSet rs) throws SQLException {
        if (rs != null) {
            this.haveRS = true;
            int maxLOBLengthRetrieved = RDBCorePlugin.getDefault().getPluginPreferences().getInt("OUTPUT_PREFERENCE_MAX_LOB_LENGTH");
            try {
                this.tableRows = new ArrayList();
                ResultSetMetaData rmeta = rs.getMetaData();
                this.columnCount = rmeta.getColumnCount();
                this.columnNames = new String[this.columnCount];
                this.columnTypes = new int[this.columnCount];
                this.columnLengths = new int[this.columnCount];
                int j = 1;
                while (j <= this.columnCount) {
                    this.columnNames[j - 1] = rmeta.getColumnName(j);
                    this.columnTypes[j - 1] = rmeta.getColumnType(j);
                    try {
                        this.columnLengths[j - 1] = rmeta.getPrecision(j);
                    }
                    catch (Exception exception) {
                        this.columnLengths[j - 1] = 5;
                    }
                    ++j;
                }
                this.numRows = 0;
                while (rs.next()) {
                    ResultTableRow row = new ResultTableRow(this.columnCount);
                    int i = 1;
                    while (i <= this.columnCount) {
                        String value = null;
                        int colType = rmeta.getColumnType(i);
                        Object o = ResultSetReader.read((ResultSet)rs, (int)(i - 1), (int)maxLOBLengthRetrieved);
                        value = DataSerializer.serialize((Object)o, (int)colType);
                        if (value == null) {
                            value = "-";
                        }
                        row.setColumn(value, i - 1);
                        ++i;
                    }
                    this.tableRows.add(row);
                    ++this.numRows;
                }
            }
            catch (SQLException sqlE) {
                throw sqlE;
            }
            catch (Exception e) {
                OutputViewPlugin.getPlugin().writeLog(4, 0, "ResultTableModel:constructor.", e);
            }
        }
    }

    private String getValueForCLOB(ResultSet aResult, int index, int maxLength) {
        try {
            Clob clob = aResult.getClob(index);
            if (clob != null) {
                String stringValue = clob.getSubString(1L, maxLength);
                return stringValue;
            }
        }
        catch (Exception ex) {
            OutputViewPlugin.getPlugin().writeLog(4, 0, "ResultTableModel:getValueForCLOB.", ex);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getValueForBLOB(ResultSet aResult, int index, int maxLength) {
        BufferedInputStream stream;
        block14: {
            String string;
            stream = null;
            try {
                try {
                    stream = new BufferedInputStream(aResult.getBinaryStream(index));
                    byte[] byteArray = new byte[maxLength];
                    try {
                        stream.available();
                    }
                    catch (IOException iOException) {
                        String string2 = null;
                        Object var9_9 = null;
                        try {
                            if (stream == null) return string2;
                            stream.close();
                            return string2;
                        }
                        catch (Exception exception) {}
                        return string2;
                    }
                    int bytesRead = stream.read(byteArray, 0, maxLength);
                    if (bytesRead <= 0) break block14;
                    StringBuffer sb = new StringBuffer(bytesRead * 2);
                    int i = 0;
                    while (true) {
                        if (i >= bytesRead) {
                            String stringValue;
                            string = stringValue = sb.toString();
                            Object var9_10 = null;
                            break;
                        }
                        sb.append(this.hexDigits[(byteArray[i] & 0xF0) >>> 4]);
                        sb.append(this.hexDigits[byteArray[i] & 0xF]);
                        ++i;
                    }
                }
                catch (Exception ex) {
                    OutputViewPlugin.getPlugin().writeLog(4, 0, "ResultTableModel:getValueForBLOB.", ex);
                    break block14;
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {}
                catch (Exception exception) {}
                if (stream == null) throw throwable;
                stream.close();
                throw throwable;
                throw throwable;
            }
            try {}
            catch (Exception exception) {}
            if (stream == null) return string;
            stream.close();
            return string;
        }
        Object var9_12 = null;
        try {}
        catch (Exception exception) {
            return null;
        }
        if (stream == null) return null;
        stream.close();
        return null;
    }

    public ResultTableModel(ProcedureCallCache proc) throws SQLException {
        if (proc != null) {
            this.haveRS = false;
            this.tableRows = new ArrayList();
            this.columnCount = proc.getColumnCount();
            this.columnNames = new String[this.columnCount];
            this.columnTypes = new int[this.columnCount];
            this.columnLengths = new int[this.columnCount];
            int j = 1;
            while (j <= this.columnCount) {
                this.columnNames[j - 1] = proc.getColumnName(j);
                this.columnTypes[j - 1] = proc.getColumnSQLType(j);
                this.columnLengths[j - 1] = proc.getColumnLength(j);
                ++j;
            }
            this.numRows = proc.getNumRows();
            int i = 0;
            while (i < this.numRows) {
                ResultTableRow row = new ResultTableRow(this.columnCount);
                int j2 = 1;
                while (j2 <= this.columnCount) {
                    row.setColumn(proc.getColumnValueToString(j2), j2 - 1);
                    ++j2;
                }
                this.tableRows.add(row);
                proc.nextRow();
                ++i;
            }
        }
    }

    public ResultTableRow getRow(int rowIndex) {
        return (ResultTableRow)this.tableRows.get(rowIndex);
    }

    public ArrayList getTableRows() {
        return this.tableRows;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    protected int getResultSetRowCount() {
        if (this.haveRS) {
            return this.numRows;
        }
        return -1;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public int[] getColumnTypes() {
        return this.columnTypes;
    }

    public int[] getColumnLengths() {
        return this.columnLengths;
    }
}

