/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.OpenTestAction;
import org.eclipse.jdt.internal.junit.ui.RerunAction;
import org.eclipse.jdt.internal.junit.ui.TestRunInfo;
import org.eclipse.jdt.internal.junit.ui.TestRunTab;
import org.eclipse.jdt.internal.junit.ui.TestRunnerViewPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TestHierarchyTab
extends TestRunTab
implements IMenuListener,
ISelectionProvider {
    private Tree fTree;
    private TreeItem fCachedParent;
    private TreeItem[] fCachedItems;
    private TreeItem fLastParent;
    private List fExecutionPath;
    private boolean fMoveSelection = false;
    private ListenerList fSelectionListeners = new ListenerList();
    private Vector fSuiteInfos = new Vector();
    private Map fTreeItemMap = new HashMap();
    private TestRunnerViewPart fTestRunnerPart;
    private final Image fOkIcon = TestRunnerViewPart.createImage("obj16/testok.gif");
    private final Image fErrorIcon = TestRunnerViewPart.createImage("obj16/testerr.gif");
    private final Image fFailureIcon = TestRunnerViewPart.createImage("obj16/testfail.gif");
    private final Image fHierarchyIcon = TestRunnerViewPart.createImage("obj16/testhier.gif");
    private final Image fSuiteIcon = TestRunnerViewPart.createImage("obj16/tsuite.gif");
    private final Image fSuiteErrorIcon = TestRunnerViewPart.createImage("obj16/tsuiteerror.gif");
    private final Image fSuiteFailIcon = TestRunnerViewPart.createImage("obj16/tsuitefail.gif");
    private final Image fTestIcon = TestRunnerViewPart.createImage("obj16/test.gif");
    private final Image fTestRunningIcon = TestRunnerViewPart.createImage("obj16/testrun.gif");
    private final Image fSuiteRunningIcon = TestRunnerViewPart.createImage("obj16/tsuiterun.gif");

    public void createTabControl(CTabFolder tabFolder, Clipboard clipboard, TestRunnerViewPart runner) {
        this.fTestRunnerPart = runner;
        CTabItem hierarchyTab = new CTabItem(tabFolder, 0);
        hierarchyTab.setText(this.getName());
        hierarchyTab.setImage(this.fHierarchyIcon);
        Composite testTreePanel = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        testTreePanel.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1536);
        testTreePanel.setLayoutData((Object)gridData);
        hierarchyTab.setControl((Control)testTreePanel);
        hierarchyTab.setToolTipText(JUnitMessages.HierarchyRunView_tab_tooltip);
        this.fTree = new Tree(testTreePanel, 516);
        gridData = new GridData(1808);
        this.fTree.setLayoutData((Object)gridData);
        OpenStrategy handler = new OpenStrategy((Control)this.fTree);
        handler.addPostSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestHierarchyTab.this.fireSelectionChanged();
            }
        });
        this.initMenu();
        this.addListeners();
    }

    void disposeIcons() {
        this.fErrorIcon.dispose();
        this.fFailureIcon.dispose();
        this.fOkIcon.dispose();
        this.fHierarchyIcon.dispose();
        this.fTestIcon.dispose();
        this.fTestRunningIcon.dispose();
        this.fSuiteRunningIcon.dispose();
        this.fSuiteIcon.dispose();
        this.fSuiteErrorIcon.dispose();
        this.fSuiteFailIcon.dispose();
    }

    private void initMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        this.fTestRunnerPart.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this);
        Menu menu = menuMgr.createContextMenu((Control)this.fTree);
        this.fTree.setMenu(menu);
    }

    private String getTestMethod() {
        return this.getTestInfo().getTestMethodName();
    }

    private TestRunInfo getTestInfo() {
        TreeItem[] treeItems = this.fTree.getSelection();
        if (treeItems.length == 0) {
            return null;
        }
        return (TestRunInfo)treeItems[0].getData();
    }

    private boolean isSuiteSelected() {
        TreeItem[] treeItems = this.fTree.getSelection();
        if (treeItems.length != 1) {
            return false;
        }
        return treeItems[0].getItemCount() > 0;
    }

    private String getClassName() {
        return this.getTestInfo().getClassName();
    }

    public String getSelectedTestId() {
        TestRunInfo testInfo = this.getTestInfo();
        if (testInfo == null) {
            return null;
        }
        return testInfo.getTestId();
    }

    public String getName() {
        return JUnitMessages.HierarchyRunView_tab_title;
    }

    public void setSelectedTest(String testId) {
        TreeItem treeItem = this.findTreeItem(testId);
        if (treeItem != null) {
            this.fTree.setSelection(new TreeItem[]{treeItem});
        }
    }

    public void startTest(String testId) {
        TreeItem treeItem = this.findTreeItem(testId);
        if (treeItem == null) {
            return;
        }
        TreeItem parent = treeItem.getParentItem();
        if (this.fLastParent != parent) {
            this.updatePath(parent);
            this.fLastParent = parent;
        }
        this.setCurrentItem(treeItem);
    }

    public void rerunTest(String testId) {
        TreeItem treeItem = this.findTreeItem(testId);
        if (treeItem == null) {
            return;
        }
        this.setCurrentItem(treeItem);
    }

    public void endRerunTest(String testId) {
        TestRunInfo testInfo = this.fTestRunnerPart.getTestInfo(testId);
        if (testInfo == null) {
            return;
        }
        this.testStatusChanged(testInfo);
    }

    private void updatePath(TreeItem parent) {
        ArrayList<TreeItem> newPath = new ArrayList<TreeItem>();
        while (parent != null) {
            newPath.add(parent);
            parent = parent.getParentItem();
        }
        Collections.reverse(newPath);
        ListIterator old = this.fExecutionPath.listIterator();
        ListIterator np = newPath.listIterator();
        int c = 0;
        while (old.hasNext() && np.hasNext()) {
            if (old.next() != np.next()) break;
            ++c;
        }
        ListIterator iter = this.fExecutionPath.listIterator(c);
        while (iter.hasNext()) {
            this.refreshItem((TreeItem)iter.next(), false);
        }
        iter = newPath.listIterator(c);
        while (iter.hasNext()) {
            this.refreshItem((TreeItem)iter.next(), true);
        }
        this.fExecutionPath = newPath;
    }

    private void refreshItem(TreeItem item, boolean onPath) {
        if (onPath) {
            item.setImage(this.fSuiteRunningIcon);
        } else {
            TestRunInfo info = this.getTestRunInfo(item);
            switch (info.getStatus()) {
                case 1: {
                    item.setImage(this.fSuiteErrorIcon);
                    break;
                }
                case 2: {
                    item.setImage(this.fSuiteFailIcon);
                    break;
                }
                default: {
                    item.setImage(this.fSuiteIcon);
                }
            }
        }
    }

    private void setCurrentItem(TreeItem treeItem) {
        treeItem.setImage(this.fTestRunningIcon);
        TreeItem parent = treeItem.getParentItem();
        if (this.fTestRunnerPart.isAutoScroll()) {
            this.fTree.showItem(treeItem);
            while (parent != null) {
                if (parent.getExpanded()) break;
                parent.setExpanded(true);
                parent = parent.getParentItem();
            }
        }
    }

    public void endTest(String testId) {
        TreeItem treeItem = this.findTreeItem(testId);
        if (treeItem == null) {
            return;
        }
        TestRunInfo testInfo = this.fTestRunnerPart.getTestInfo(testId);
        if (testInfo == null) {
            return;
        }
        this.updateItem(treeItem, testInfo);
        if (this.fTestRunnerPart.isAutoScroll()) {
            this.fTree.showItem(treeItem);
            this.cacheItems(treeItem);
            this.collapsePassedTests(treeItem);
        }
    }

    private void cacheItems(TreeItem treeItem) {
        TreeItem parent = treeItem.getParentItem();
        if (parent == this.fCachedParent) {
            return;
        }
        this.fCachedItems = parent != null ? parent.getItems() : null;
        this.fCachedParent = parent;
    }

    private void collapsePassedTests(TreeItem treeItem) {
        TreeItem parent = treeItem.getParentItem();
        if (parent != null) {
            TreeItem[] items = null;
            items = parent == this.fCachedParent ? this.fCachedItems : parent.getItems();
            if (this.isLast(treeItem, items)) {
                boolean ok = true;
                int i = 0;
                while (i < items.length) {
                    if (this.isFailure(items[i])) {
                        ok = false;
                        break;
                    }
                    ++i;
                }
                if (ok) {
                    parent.setExpanded(false);
                    this.collapsePassedTests(parent);
                }
            }
        }
    }

    private boolean isLast(TreeItem treeItem, TreeItem[] items) {
        return items[items.length - 1] == treeItem;
    }

    private void updateItem(TreeItem treeItem, TestRunInfo testInfo) {
        treeItem.setData((Object)testInfo);
        if (testInfo.getStatus() == 0) {
            treeItem.setImage(this.fOkIcon);
            return;
        }
        if (testInfo.getStatus() == 2) {
            treeItem.setImage(this.fFailureIcon);
        } else if (testInfo.getStatus() == 1) {
            treeItem.setImage(this.fErrorIcon);
        }
        this.propagateStatus(treeItem, testInfo.getStatus());
    }

    private void propagateStatus(TreeItem item, int status) {
        TreeItem parent = item.getParentItem();
        TestRunInfo testRunInfo = this.getTestRunInfo(item);
        if (parent == null) {
            return;
        }
        TestRunInfo parentInfo = this.getTestRunInfo(parent);
        int parentStatus = parentInfo.getStatus();
        if (status == 2) {
            if (parentStatus == 1 || parentStatus == 2) {
                return;
            }
            parentInfo.setStatus(2);
            testRunInfo.setStatus(2);
        } else {
            if (parentStatus == 1) {
                return;
            }
            parentInfo.setStatus(1);
            testRunInfo.setStatus(1);
        }
        this.propagateStatus(parent, status);
    }

    private TestRunInfo getTestRunInfo(TreeItem item) {
        return (TestRunInfo)item.getData();
    }

    public void activate() {
        this.fMoveSelection = false;
        this.testSelected();
    }

    public void setFocus() {
        this.fTree.setFocus();
    }

    public void aboutToStart() {
        this.fTree.removeAll();
        this.fSuiteInfos.removeAllElements();
        this.fTreeItemMap = new HashMap();
        this.fCachedParent = null;
        this.fCachedItems = null;
        this.fMoveSelection = false;
        this.fExecutionPath = new ArrayList();
    }

    private void testSelected() {
        this.fTestRunnerPart.handleTestSelected(this.getTestInfo());
    }

    private void addListeners() {
        this.fTree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TestHierarchyTab.this.activate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                TestHierarchyTab.this.handleDoubleClick(null);
            }
        });
        this.fTree.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TestHierarchyTab.this.disposeIcons();
            }
        });
        this.fTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TestHierarchyTab.this.handleDoubleClick(e);
            }
        });
    }

    void handleDoubleClick(MouseEvent e) {
        TestRunInfo testInfo = this.getTestInfo();
        if (testInfo == null) {
            return;
        }
        String testLabel = testInfo.getTestName();
        OpenTestAction action = null;
        action = this.isSuiteSelected() ? new OpenTestAction(this.fTestRunnerPart, testLabel) : new OpenTestAction(this.fTestRunnerPart, this.getClassName(), this.getTestMethod());
        if (action.isEnabled()) {
            action.run();
        }
    }

    public void menuAboutToShow(IMenuManager manager) {
        if (this.fTree.getSelectionCount() > 0) {
            TreeItem treeItem = this.fTree.getSelection()[0];
            TestRunInfo testInfo = (TestRunInfo)treeItem.getData();
            String testLabel = testInfo.getTestName();
            if (this.isSuiteSelected()) {
                manager.add((IAction)new OpenTestAction(this.fTestRunnerPart, testLabel));
                manager.add((IContributionItem)new Separator());
                if (this.testClassExists(this.getClassName()) && !this.fTestRunnerPart.lastLaunchIsKeptAlive()) {
                    manager.add((IAction)new RerunAction(this.fTestRunnerPart, this.getSelectedTestId(), this.getClassName(), null, "run"));
                    manager.add((IAction)new RerunAction(this.fTestRunnerPart, this.getSelectedTestId(), this.getClassName(), null, "debug"));
                }
            } else {
                manager.add((IAction)new OpenTestAction(this.fTestRunnerPart, this.getClassName(), this.getTestMethod()));
                manager.add((IContributionItem)new Separator());
                if (this.fTestRunnerPart.lastLaunchIsKeptAlive()) {
                    manager.add((IAction)new RerunAction(this.fTestRunnerPart, this.getSelectedTestId(), this.getClassName(), this.getTestMethod(), "run"));
                } else {
                    manager.add((IAction)new RerunAction(this.fTestRunnerPart, this.getSelectedTestId(), this.getClassName(), this.getTestMethod(), "run"));
                    manager.add((IAction)new RerunAction(this.fTestRunnerPart, this.getSelectedTestId(), this.getClassName(), this.getTestMethod(), "debug"));
                }
            }
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new ExpandAllAction());
        }
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator("additions-end"));
    }

    private boolean testClassExists(String className) {
        IJavaProject project = this.fTestRunnerPart.getLaunchedProject();
        try {
            IType type = project.findType(className);
            return type != null;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public void newTreeEntry(String treeEntry) {
        TreeItem treeItem;
        int index0 = treeEntry.indexOf(44);
        StringBuffer testStringBuffer = new StringBuffer(100);
        int index1 = this.scanTestName(treeEntry, index0 + 1, testStringBuffer);
        int index2 = treeEntry.indexOf(44, index1 + 1);
        String testString = testStringBuffer.toString().trim();
        String id = treeEntry.substring(0, index0);
        TestRunInfo testInfo = new TestRunInfo(id, testString);
        String isSuite = treeEntry.substring(index1 + 1, index2);
        int testCount = Integer.parseInt(treeEntry.substring(index2 + 1));
        while (this.fSuiteInfos.size() > 0 && ((SuiteInfo)this.fSuiteInfos.lastElement()).fTestCount == 0) {
            this.fSuiteInfos.removeElementAt(this.fSuiteInfos.size() - 1);
        }
        if (this.fSuiteInfos.size() == 0) {
            treeItem = new TreeItem(this.fTree, 0);
            treeItem.setImage(this.fSuiteIcon);
            this.fSuiteInfos.addElement(new SuiteInfo(treeItem, testCount));
        } else if (isSuite.equals("true")) {
            treeItem = new TreeItem(((SuiteInfo)this.fSuiteInfos.lastElement()).fTreeItem, 0);
            treeItem.setImage(this.fSuiteIcon);
            --((SuiteInfo)this.fSuiteInfos.lastElement()).fTestCount;
            this.fSuiteInfos.addElement(new SuiteInfo(treeItem, testCount));
        } else {
            treeItem = new TreeItem(((SuiteInfo)this.fSuiteInfos.lastElement()).fTreeItem, 0);
            treeItem.setImage(this.fTestIcon);
            --((SuiteInfo)this.fSuiteInfos.lastElement()).fTestCount;
        }
        this.mapTest(testInfo, treeItem);
        treeItem.setText(testInfo.getTestMethodName());
        treeItem.setData((Object)testInfo);
    }

    private int scanTestName(String s, int start, StringBuffer testName) {
        boolean inQuote = false;
        int i = start;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\\' && !inQuote) {
                inQuote = true;
            } else if (inQuote) {
                inQuote = false;
                testName.append(c);
            } else {
                if (c == ',') break;
                testName.append(c);
            }
            ++i;
        }
        return i;
    }

    private void mapTest(TestRunInfo info, TreeItem item) {
        this.fTreeItemMap.put(info.getTestId(), item);
    }

    private TreeItem findTreeItem(String testId) {
        Object o = this.fTreeItemMap.get(testId);
        if (o instanceof TreeItem) {
            return (TreeItem)o;
        }
        return null;
    }

    public void testStatusChanged(TestRunInfo newInfo) {
        Object o = this.fTreeItemMap.get(newInfo.getTestId());
        if (o instanceof TreeItem) {
            this.updateItem((TreeItem)o, newInfo);
            return;
        }
    }

    public void selectNext() {
        TreeItem selection = this.getInitialSearchSelection();
        if (!this.moveSelection(selection)) {
            return;
        }
        TreeItem failure = this.findFailure(selection, true, !this.isLeafFailure(selection));
        if (failure != null) {
            this.selectTest(failure);
        }
    }

    public void selectPrevious() {
        TreeItem selection = this.getInitialSearchSelection();
        if (!this.moveSelection(selection)) {
            return;
        }
        TreeItem failure = this.findFailure(selection, false, !this.isLeafFailure(selection));
        if (failure != null) {
            this.selectTest(failure);
        }
    }

    private boolean moveSelection(TreeItem selection) {
        if (!this.fMoveSelection) {
            this.fMoveSelection = true;
            if (this.isLeafFailure(selection)) {
                this.selectTest(selection);
                return false;
            }
        }
        return true;
    }

    private TreeItem getInitialSearchSelection() {
        TreeItem[] treeItems = this.fTree.getSelection();
        TreeItem selection = null;
        selection = treeItems.length == 0 ? this.fTree.getItems()[0] : treeItems[0];
        return selection;
    }

    private boolean isFailure(TreeItem selection) {
        return this.getTestRunInfo(selection).getStatus() != 0;
    }

    private boolean isLeafFailure(TreeItem selection) {
        boolean isLeaf;
        boolean bl = isLeaf = selection.getItemCount() == 0;
        return isLeaf && this.isFailure(selection);
    }

    private void selectTest(TreeItem selection) {
        this.fTestRunnerPart.showTest(this.getTestRunInfo(selection));
    }

    private TreeItem findFailure(TreeItem start, boolean next, boolean includeNode) {
        int i;
        TreeItem[] sib = this.findSiblings(start, next, includeNode);
        if (next) {
            i = 0;
            while (i < sib.length) {
                TreeItem failure = this.findFailureInTree(sib[i]);
                if (failure != null) {
                    return failure;
                }
                ++i;
            }
        } else {
            i = sib.length - 1;
            while (i >= 0) {
                TreeItem failure = this.findFailureInTree(sib[i]);
                if (failure != null) {
                    return failure;
                }
                --i;
            }
        }
        TreeItem parent = start.getParentItem();
        if (parent == null) {
            return null;
        }
        return this.findFailure(parent, next, false);
    }

    private TreeItem[] findSiblings(TreeItem item, boolean next, boolean includeNode) {
        TreeItem parent = item.getParentItem();
        TreeItem[] children = null;
        children = parent == null ? item.getParent().getItems() : parent.getItems();
        int i = 0;
        while (i < children.length) {
            TreeItem item2 = children[i];
            if (item2 == item) {
                TreeItem[] result = null;
                if (next) {
                    if (!includeNode) {
                        result = new TreeItem[children.length - i - 1];
                        System.arraycopy(children, i + 1, result, 0, children.length - i - 1);
                    } else {
                        result = new TreeItem[children.length - i];
                        System.arraycopy(children, i, result, 0, children.length - i);
                    }
                } else if (!includeNode) {
                    result = new TreeItem[i];
                    System.arraycopy(children, 0, result, 0, i);
                } else {
                    result = new TreeItem[i + 1];
                    System.arraycopy(children, 0, result, 0, i + 1);
                }
                return result;
            }
            ++i;
        }
        return new TreeItem[0];
    }

    private TreeItem findFailureInTree(TreeItem item) {
        if (item.getItemCount() == 0 && this.isFailure(item)) {
            return item;
        }
        TreeItem[] children = item.getItems();
        int i = 0;
        while (i < children.length) {
            TreeItem item2 = this.findFailureInTree(children[i]);
            if (item2 != null) {
                return item2;
            }
            ++i;
        }
        return null;
    }

    protected void expandAll() {
        TreeItem[] treeItems = this.fTree.getSelection();
        this.fTree.setRedraw(false);
        int i = 0;
        while (i < treeItems.length) {
            this.expandAll(treeItems[i]);
            ++i;
        }
        this.fTree.setRedraw(true);
    }

    private void expandAll(TreeItem item) {
        item.setExpanded(true);
        TreeItem[] items = item.getItems();
        int i = 0;
        while (i < items.length) {
            this.expandAll(items[i]);
            ++i;
        }
    }

    public void aboutToEnd() {
        int i = 0;
        while (i < this.fExecutionPath.size()) {
            this.refreshItem((TreeItem)this.fExecutionPath.get(i), false);
            ++i;
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        TestRunInfo testInfo = this.getTestInfo();
        if (testInfo == null) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection((Object)testInfo);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
    }

    private void fireSelectionChanged() {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        Object[] listeners = this.fSelectionListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ISelectionChangedListener listener = (ISelectionChangedListener)listeners[i];
            listener.selectionChanged(event);
            ++i;
        }
    }

    private static class SuiteInfo {
        public int fTestCount;
        public TreeItem fTreeItem;

        public SuiteInfo(TreeItem treeItem, int testCount) {
            this.fTreeItem = treeItem;
            this.fTestCount = testCount;
        }
    }

    private class ExpandAllAction
    extends Action {
        public ExpandAllAction() {
            this.setText(JUnitMessages.ExpandAllAction_text);
            this.setToolTipText(JUnitMessages.ExpandAllAction_tooltip);
        }

        public void run() {
            TestHierarchyTab.this.expandAll();
        }
    }
}

