/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.internal.ui.views.variables.VariablesViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.TreeItem;

public abstract class AbstractViewerState {
    protected List fSavedExpansion = null;
    protected IPath[] fSelection;

    public AbstractViewerState(TreeViewer viewer) {
        this.saveState(viewer);
    }

    public AbstractViewerState() {
    }

    public void saveState(TreeViewer viewer) {
        ArrayList expanded = new ArrayList();
        this.fSavedExpansion = null;
        TreeItem[] items = viewer.getTree().getItems();
        try {
            int i = 0;
            while (i < items.length) {
                this.collectExpandedItems(items[i], expanded);
                ++i;
            }
            if (expanded.size() > 0) {
                this.fSavedExpansion = expanded;
            }
        }
        catch (DebugException debugException) {
            this.fSavedExpansion = null;
        }
        TreeItem[] selection = viewer.getTree().getSelection();
        this.fSelection = new IPath[selection.length];
        try {
            int i = 0;
            while (i < selection.length) {
                this.fSelection[i] = this.encodeElement(selection[i]);
                if (this.fSelection[i] == null) {
                    this.fSelection = null;
                    return;
                }
                ++i;
            }
        }
        catch (DebugException debugException) {
            this.fSelection = null;
        }
    }

    protected void collectExpandedItems(TreeItem item, List expanded) throws DebugException {
        IPath path;
        if (item.getExpanded() && (path = this.encodeElement(item)) != null) {
            expanded.add(path);
            TreeItem[] items = item.getItems();
            int i = 0;
            while (i < items.length) {
                this.collectExpandedItems(items[i], expanded);
                ++i;
            }
        }
    }

    protected abstract IPath encodeElement(TreeItem var1) throws DebugException;

    public void restoreState(TreeViewer viewer) {
        boolean expansionComplete = true;
        if (this.fSavedExpansion != null && this.fSavedExpansion.size() > 0) {
            int i = 0;
            while (i < this.fSavedExpansion.size()) {
                IPath path = (IPath)this.fSavedExpansion.get(i);
                if (path != null) {
                    if (viewer instanceof VariablesViewer) {
                        VariablesViewer variablesViewer = (VariablesViewer)viewer;
                        boolean complete = variablesViewer.expandPath(path);
                        if (!complete) {
                            expansionComplete = false;
                        }
                    } else {
                        try {
                            Object obj = this.decodePath(path, viewer);
                            if (obj != null) {
                                viewer.expandToLevel(obj, 1);
                            } else {
                                expansionComplete = false;
                            }
                        }
                        catch (DebugException debugException) {}
                    }
                }
                ++i;
            }
            if (expansionComplete) {
                this.fSavedExpansion = null;
            }
        }
        boolean selectionComplete = true;
        if (this.fSelection != null && this.fSelection.length > 0) {
            ArrayList<Object> selection = new ArrayList<Object>(this.fSelection.length);
            int i = 0;
            while (i < this.fSelection.length) {
                IPath path = this.fSelection[i];
                try {
                    Object obj = this.decodePath(path, viewer);
                    if (obj != null) {
                        selection.add(obj);
                    } else {
                        selectionComplete = false;
                    }
                }
                catch (DebugException debugException) {}
                ++i;
            }
            if (selection.size() > 0) {
                viewer.setSelection((ISelection)new StructuredSelection(selection));
            }
            if (selectionComplete) {
                this.fSelection = null;
            }
        }
    }

    protected abstract Object decodePath(IPath var1, TreeViewer var2) throws DebugException;

    public abstract AbstractViewerState copy();
}

