/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.Logger;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDocletAntProjectBuilder;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDocletTaskProvider;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDoxletAnnotationUtil;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.ReferencedComponent;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.osgi.framework.Bundle;

public class XDocletEjbAntProjectBuilder
extends XDocletAntProjectBuilder {
    IProject clientProject;

    public XDocletEjbAntProjectBuilder() {
        this.templateUrl = Platform.getBundle((String)"org.eclipse.jst.j2ee.ejb.annotations.xdoclet").getEntry("/templates/builder/xdoclet.xml");
    }

    protected String getTaskName() {
        return "ejbdoclet";
    }

    protected HashMap createTemplates(String beanPath) {
        HashMap<String, String> templates = new HashMap<String, String>();
        templates.put("@beans@", beanPath);
        templates.put("@docletTasks@", this.createDocletTasks());
        return templates;
    }

    private String createDocletTasks() {
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jst.j2ee.ejb.annotations.xdoclet.ejbDocletTaskProvider").getExtensions();
        StringBuffer tasks = new StringBuffer(512);
        int i = 0;
        while (extensions != null && i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            if (elements != null) {
                try {
                    String pluginDescriptor = elements[0].getDeclaringExtension().getNamespace();
                    Bundle bundle = Platform.getBundle((String)pluginDescriptor);
                    Class c = bundle.loadClass(elements[0].getAttribute("class"));
                    if (c != null) {
                        XDocletTaskProvider docletTaskProvider = (XDocletTaskProvider)c.newInstance();
                        docletTaskProvider.setClientProject(this.clientProject);
                        docletTaskProvider.setPreferenceStore(this.preferenceStore);
                        docletTaskProvider.setExtension(extension);
                        docletTaskProvider.setProperties(this.getProperties());
                        docletTaskProvider.setProject(this.getProject());
                        if (this.preferenceStore.getBooleanProperty(String.valueOf(elements[0].getAttribute("id")) + ".defaultSelection")) {
                            tasks.append("\n");
                            tasks.append(docletTaskProvider.getTask());
                            tasks.append("\n");
                        }
                    }
                }
                catch (Exception e) {
                    Logger.logException(e);
                }
            }
            ++i;
        }
        return tasks.toString();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Properties createAntBuildProperties(IResource resource, IJavaProject javaProject, IPackageFragmentRoot packageFragmentRoot, String beanPath) {
        EJBArtifactEdit ejbEdit;
        Properties properties;
        block12: {
            properties = new Properties();
            StructureEdit core = null;
            ejbEdit = null;
            try {
                try {
                    core = StructureEdit.getStructureEditForRead((IProject)javaProject.getProject());
                    ArrayList ejbs = new ArrayList();
                    this.getAllAnnotatedEjbs((IParent)packageFragmentRoot, ejbs);
                    properties.put("ejb", resource.getProject().getName());
                    properties.put("ejb.project.dir", resource.getProject().getLocation().toString());
                    properties.put("ejb.project.classpath", this.asClassPath(javaProject));
                    properties.put("ejb.module.src", packageFragmentRoot.getResource().getProjectRelativePath().toString());
                    properties.put("ejb.module.gen", packageFragmentRoot.getResource().getProjectRelativePath().toString());
                    properties.put("ejb.bin.dir", this.getJavaProjectOutputContainer(javaProject).toString());
                    properties.put("ejb.bin.dir", this.getJavaProjectOutputContainer(javaProject).toString());
                    properties.put("xdoclet.home", this.getPreferenceStore().getProperty("XDOCLETHOME"));
                    URL url = Platform.getBundle((String)"org.apache.ant").getEntry("/");
                    url = Platform.asLocalURL((URL)url);
                    File file = new File(url.getFile());
                    properties.put("ant.home", file.getAbsolutePath());
                    WorkbenchComponent ejbModule = null;
                    ComponentResource[] moduleResources = core.findResourcesBySourcePath(resource.getProjectRelativePath());
                    int i = 0;
                    while (i < moduleResources.length) {
                        ComponentResource moduleResource = moduleResources[i];
                        if (moduleResource != null) {
                            ejbModule = moduleResource.getComponent();
                        }
                        if (ejbModule != null) break;
                        ++i;
                    }
                    IProject proj = javaProject.getProject();
                    if (ejbModule == null) {
                        ejbModule = core.getComponent();
                    }
                    ejbEdit = EJBArtifactEdit.getEJBArtifactEditForRead((IProject)proj);
                    int ejbLevelI = ejbEdit.getEJBJarXmiResource().getModuleVersionID();
                    String ejbLevel = J2EEProjectUtilities.getJ2EEProjectVersion((IProject)proj);
                    if ((ejbLevel == null || ejbLevel.length() == 0) && ejbLevelI == 20) {
                        ejbLevel = "2.0";
                    } else if ((ejbLevel == null || ejbLevel.length() == 0) && ejbLevelI == 21) {
                        ejbLevel = "2.1";
                    }
                    this.setEjbClientJarProperties(properties, core, ejbModule);
                    properties.put("ejb.spec.version", ejbLevel);
                    properties.put("java.class.path", "");
                    properties.put("project.class.path", "");
                    properties.put("project.path", "");
                    properties.put("ejb.dd.displayname", ejbModule.getName());
                    properties.put("ejb.dd.description", String.valueOf(ejbModule.getName()) + " generated by eclipse wtp xdoclet extension.");
                }
                catch (Exception e) {
                    Logger.logException(e);
                }
            }
            catch (Throwable throwable) {
                Object var16_20 = null;
                if (core != null) {
                    core.dispose();
                }
                if (ejbEdit == null) throw throwable;
                ejbEdit.dispose();
                throw throwable;
            }
            {
                Object var16_21 = null;
                if (core == null) break block12;
            }
            core.dispose();
        }
        if (ejbEdit == null) return properties;
        ejbEdit.dispose();
        return properties;
    }

    private void setEjbClientJarProperties(Properties properties, StructureEdit core, WorkbenchComponent ejbModule) throws UnresolveableURIException {
        ReferencedComponent refedComp;
        WorkbenchComponent clientEjbJarComp;
        IProject project;
        this.clientProject = null;
        Iterator refComps = ejbModule.getReferencedComponents().iterator();
        if (refComps.hasNext() && J2EEProjectUtilities.isUtilityProject((IProject)(project = StructureEdit.getContainingProject((WorkbenchComponent)(clientEjbJarComp = core.findComponentByURI((refedComp = (ReferencedComponent)refComps.next()).getHandle())))))) {
            properties.put("ejb.dd.clientjar", String.valueOf(clientEjbJarComp.getName()) + ".jar");
            this.setClientJarSourcepath(properties, ejbModule, clientEjbJarComp);
        }
    }

    private void setClientJarSourcepath(Properties properties, WorkbenchComponent ejbModule, WorkbenchComponent ejbClientJarComp) {
        Iterator clientHarResources = ejbClientJarComp.getResources().iterator();
        this.clientProject = StructureEdit.getContainingProject((WorkbenchComponent)ejbClientJarComp);
        List sourcePaths = JemProjectUtilities.getSourceContainers((IProject)this.clientProject);
        while (clientHarResources.hasNext()) {
            ComponentResource res = (ComponentResource)clientHarResources.next();
            IPath sPath = res.getSourcePath();
            Iterator projSPaths = sourcePaths.iterator();
            while (projSPaths.hasNext()) {
                IFolder pSPath = (IFolder)projSPaths.next();
                if (!sPath.makeRelative().equals((Object)pSPath.getProjectRelativePath())) continue;
                properties.put("ejb.client.module.src", pSPath.getLocation().toString());
                return;
            }
        }
    }

    protected String constructAnnotatedClassList(IPackageFragmentRoot root, IResource changedBean) {
        ArrayList ejbs = new ArrayList();
        this.getAllAnnotatedEjbs((IParent)root, ejbs);
        String beans = "";
        try {
            Iterator iterator = ejbs.iterator();
            while (iterator.hasNext()) {
                ICompilationUnit cu = (ICompilationUnit)iterator.next();
                IResource bean = cu.getCorrespondingResource();
                IPath path = bean.getProjectRelativePath();
                path = this.makeRelativeTo(path, root);
                beans = String.valueOf(beans) + "\t<include name=\"" + path.toString() + "\" />\n";
            }
        }
        catch (JavaModelException e) {
            Logger.logException(e);
        }
        return beans;
    }

    private void getAllAnnotatedEjbs(IParent root, List list) {
        IJavaElement[] elements = null;
        try {
            if (root == null) {
                return;
            }
            elements = root.getChildren();
            if (elements == null) {
                return;
            }
            int i = 0;
            while (i < elements.length) {
                IJavaElement element = elements[i];
                if (XDoxletAnnotationUtil.isXDocletAnnotatedEjbClass(element)) {
                    list.add(element);
                } else if (element.getElementType() == 4) {
                    this.getAllAnnotatedEjbs((IParent)((IPackageFragment)element), list);
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            Logger.logException(e);
        }
    }

    protected void refreshProjects(IProject project, IProgressMonitor monitor) throws CoreException {
        project.refreshLocal(2, monitor);
        if (this.clientProject != null) {
            this.clientProject.refreshLocal(2, monitor);
        }
    }
}

