/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.Logger;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDocletAnnotationPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public final class XDocletPreferenceStore {
    private static IPreferencesService preferencesService = null;
    private ScopedPreferenceStore projectSettings;
    private IProject project = null;
    public static final String XDOCLETBUILDERACTIVE = "XDOCLETBUILDERACTIVE";
    public static final String XDOCLETUSEGLOBAL = "XDOCLETUSEGLOBAL";
    public static final String XDOCLETFORCE = "XDOCLETFORCE";
    public static final String XDOCLETHOME = "XDOCLETHOME";
    public static final String XDOCLETVERSION = "XDOCLETVERSION";

    public XDocletPreferenceStore(IProject project) {
        this.project = project;
        if (project != null) {
            this.projectSettings = new ScopedPreferenceStore((IScopeContext)new ProjectScope(project), XDocletPreferenceStore.getPreferencePrefix());
        }
    }

    protected static String getPreferencePrefix() {
        return XDocletAnnotationPlugin.getDefault().getBundle().getSymbolicName();
    }

    private IPreferencesService getPreferencesService() {
        if (preferencesService == null) {
            preferencesService = Platform.getPreferencesService();
        }
        return preferencesService;
    }

    private IScopeContext[] getLookupOrder() {
        boolean useGlobal;
        String key = XDOCLETUSEGLOBAL;
        IScopeContext[] projectScopeOrder = null;
        if (this.project != null) {
            projectScopeOrder = new IScopeContext[]{new ProjectScope(this.project), new InstanceScope(), new DefaultScope()};
        }
        IScopeContext[] globalScopeOrder = new IScopeContext[]{new InstanceScope(), new DefaultScope()};
        if (projectScopeOrder == null) {
            projectScopeOrder = globalScopeOrder;
        }
        if ((useGlobal = this.getPreferencesService().getBoolean(XDocletPreferenceStore.getPreferencePrefix(), key, false, projectScopeOrder)) || this.project == null) {
            return globalScopeOrder;
        }
        return projectScopeOrder;
    }

    public void setProperty(String item, String value) {
        IPreferenceStore store = XDocletAnnotationPlugin.getDefault().getPreferenceStore();
        if (this.project != null) {
            store = this.projectSettings;
        }
        store.setValue(item, value);
    }

    public void save() {
        try {
            if (this.project != null && this.projectSettings != null) {
                this.projectSettings.save();
            }
        }
        catch (IOException e) {
            Logger.logException(e);
        }
    }

    public void setProperty(String item, boolean value) {
        IPreferenceStore store = XDocletAnnotationPlugin.getDefault().getPreferenceStore();
        if (this.project != null) {
            store = this.projectSettings;
        }
        store.setValue(item, value);
    }

    public String getProperty(String item) {
        IScopeContext[] lOrder = this.getLookupOrder();
        return this.getPreferencesService().getString(XDocletPreferenceStore.getPreferencePrefix(), item, null, lOrder);
    }

    public boolean getBooleanProperty(String item) {
        IScopeContext[] lOrder = this.getLookupOrder();
        return this.getPreferencesService().getBoolean(XDocletPreferenceStore.getPreferencePrefix(), item, false, lOrder);
    }

    protected static void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault(XDOCLETFORCE, true);
        store.setDefault(XDOCLETVERSION, "1.2.1");
        store.setDefault(XDOCLETHOME, "");
        store.setDefault(XDOCLETUSEGLOBAL, true);
        store.setDefault(XDOCLETBUILDERACTIVE, true);
        XDocletPreferenceStore.initDoclet(store, "org.eclipse.jst.j2ee.ejb.annotations.xdoclet.ejbDocletTaskProvider");
        XDocletPreferenceStore.initDoclet(store, "org.eclipse.jst.j2ee.ejb.annotations.xdoclet.webdocletTaskProvider");
    }

    private static void initDoclet(IPreferenceStore store, String extensionID) {
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(extensionID).getExtensions();
        int i = 0;
        while (extensions != null && i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            if (elements != null) {
                String id = elements[0].getAttribute("id");
                boolean selected = Boolean.valueOf(elements[0].getAttribute("defaultSelection"));
                store.setDefault(String.valueOf(id) + ".defaultSelection", selected);
                int j = 1;
                while (j < elements.length) {
                    IConfigurationElement param = elements[j];
                    String paramId = param.getAttribute("id");
                    String paramValue = param.getAttribute("default");
                    boolean include = Boolean.valueOf(param.getAttribute("include"));
                    store.setDefault(paramId, paramValue);
                    store.setDefault(String.valueOf(paramId) + ".include", include);
                    ++j;
                }
            }
            ++i;
        }
    }

    public static XDocletPreferenceStore forProject(IProject currentProject) {
        return new XDocletPreferenceStore(currentProject);
    }
}

