/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.webservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.common.navigator.internal.providers.CommonAdapterFactoryContentProvider;
import org.eclipse.jst.j2ee.internal.webservice.WebServiceNavigatorGroup;
import org.eclipse.jst.j2ee.internal.webservice.WebServiceNavigatorGroupType;
import org.eclipse.jst.j2ee.internal.webservice.WebServicesNavigatorSynchronizer;
import org.eclipse.jst.j2ee.internal.webservice.helper.WebServiceEvent;
import org.eclipse.jst.j2ee.internal.webservice.helper.WebServiceManagerListener;
import org.eclipse.jst.j2ee.internal.webservice.helper.WebServicesManager;
import org.eclipse.jst.j2ee.internal.webservices.WSDLServiceExtManager;
import org.eclipse.jst.j2ee.internal.webservices.WSDLServiceHelper;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.jst.j2ee.webservice.wsdd.Handler;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.common.internal.emfworkbench.integration.DynamicAdapterFactory;
import org.eclipse.wst.common.navigator.internal.provisional.views.INavigatorContentProvider;

public class WebServicesNavigatorContentProvider
extends CommonAdapterFactoryContentProvider
implements INavigatorContentProvider,
WebServiceManagerListener {
    private WebServicesManager webServicesManager = null;
    private boolean activityEnabled = false;
    private WebServiceNavigatorGroup webServiceNavigatorGroup;
    private WebServiceNavigatorGroupType SERVICES = null;
    private WebServiceNavigatorGroupType CLIENTS = null;
    private HashMap HANDLERS = new HashMap();
    private static final String VIEWER_ID = "org.eclipse.wst.navigator.ui.WTPCommonNavigator";
    private TreeViewer viewer = null;

    public WebServicesNavigatorContentProvider() {
        super(WebServicesNavigatorContentProvider.createAdapterFactory());
        WebServicesManager.getInstance().addListener((WebServiceManagerListener)this);
        WebServicesNavigatorSynchronizer.createInstance(WebServicesNavigatorContentProvider.createAdapterFactory(), this);
    }

    public static AdapterFactory createAdapterFactory() {
        return new DynamicAdapterFactory(VIEWER_ID);
    }

    public Object[] getChildren(Object parentElement) {
        WSDLServiceHelper serviceHelper = WSDLServiceExtManager.getServiceHelper();
        if (parentElement instanceof IWorkspaceRoot) {
            return new Object[]{this.getWebServicesNavigatorGroup(parentElement)};
        }
        if (parentElement instanceof WebServiceNavigatorGroup) {
            return new Object[]{this.getServicesGroup(), this.getClientsGroup()};
        }
        if (parentElement instanceof WebServiceNavigatorGroupType && ((WebServiceNavigatorGroupType)parentElement).isServices()) {
            ArrayList result = new ArrayList();
            result.addAll(this.getWebServicesManager().getInternalWSDLServices());
            result.addAll(this.getWebServicesManager().getExternalWSDLServices());
            return result.toArray();
        }
        if (parentElement instanceof WebServiceNavigatorGroupType && ((WebServiceNavigatorGroupType)parentElement).isClients()) {
            return this.getWebServicesManager().getAllWorkspaceServiceRefs().toArray();
        }
        if (serviceHelper.isService(parentElement)) {
            return this.getServiceLevelNodes(parentElement).toArray();
        }
        if (parentElement instanceof WebServiceNavigatorGroupType && ((WebServiceNavigatorGroupType)parentElement).isHandlers()) {
            return this.getHandlerChildren(parentElement).toArray();
        }
        if (parentElement instanceof ServiceRef) {
            ArrayList<WebServiceNavigatorGroupType> result = new ArrayList<WebServiceNavigatorGroupType>();
            result.add(this.getHandlersGroup(parentElement));
            return result.toArray();
        }
        if (parentElement instanceof Handler || parentElement instanceof org.eclipse.jst.j2ee.webservice.wsclient.Handler) {
            return new ArrayList().toArray();
        }
        if (serviceHelper.isWSDLResource(parentElement)) {
            return new ArrayList().toArray();
        }
        return super.getChildren(parentElement);
    }

    private List getServiceLevelNodes(Object parentElement) {
        Resource wsdl;
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.getWebServicesManager().isServiceInternal((EObject)parentElement) && this.getWebServicesManager().getServiceImplBean((EObject)parentElement) != null) {
            result.add(this.getWebServicesManager().getServiceImplBean((EObject)parentElement));
        }
        if (this.getWebServicesManager().isServiceInternal((EObject)parentElement)) {
            result.add(this.getHandlersGroup(parentElement));
        }
        if ((wsdl = this.getWebServicesManager().getWSDLResource((EObject)parentElement)) != null) {
            result.add(wsdl);
        }
        return result;
    }

    private List getHandlerChildren(Object parentElement) {
        ArrayList result = new ArrayList();
        WebServiceNavigatorGroupType handlersGroup = (WebServiceNavigatorGroupType)parentElement;
        if (handlersGroup.getWsdlService() != null) {
            PortComponent port = WebServicesManager.getInstance().getPortComponent(handlersGroup.getWsdlService());
            if (port != null && port.getHandlers() != null && !port.getHandlers().isEmpty()) {
                result.addAll(port.getHandlers());
            }
        } else if (handlersGroup.getServiceRef() != null) {
            result.addAll(handlersGroup.getServiceRef().getHandlers());
        }
        return result;
    }

    protected WebServiceNavigatorGroup getWebServicesNavigatorGroup(Object parentElement) {
        if (this.webServiceNavigatorGroup == null) {
            this.webServiceNavigatorGroup = new WebServiceNavigatorGroup((IWorkspaceRoot)parentElement);
        }
        return this.webServiceNavigatorGroup;
    }

    public Object getParent(Object element) {
        if (element instanceof IWorkspaceRoot) {
            return null;
        }
        if (element instanceof WebServiceNavigatorGroup) {
            return ((WebServiceNavigatorGroup)element).getRoot();
        }
        return super.getParent(element);
    }

    public boolean hasChildren(Object element) {
        return true;
    }

    public void inputChanged(Viewer aViewer, Object oldInput, Object newInput) {
        if (aViewer != null && aViewer instanceof TreeViewer) {
            this.viewer = (TreeViewer)aViewer;
        }
        super.inputChanged(aViewer, oldInput, newInput);
    }

    public void dispose() {
        super.dispose();
        WebServicesManager.getInstance().removeListener((WebServiceManagerListener)this);
        WebServicesNavigatorSynchronizer.disposeInstance();
    }

    public void webServiceManagerChanged(WebServiceEvent anEvent) {
        if (this.getViewer() == null) {
            return;
        }
        Display d = null;
        try {
            d = this.getViewer().getControl().getDisplay();
        }
        catch (Exception exception) {}
        if (d != Display.getCurrent() & d != null) {
            d.asyncExec(new Runnable(){

                public void run() {
                    WebServicesNavigatorContentProvider.this.getViewer().refresh((Object)WebServicesNavigatorContentProvider.this.getNavigatorGroup());
                }
            });
        } else {
            this.getViewer().refresh((Object)this.getNavigatorGroup());
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public WebServiceNavigatorGroup getNavigatorGroup() {
        if (this.webServiceNavigatorGroup == null) {
            this.webServiceNavigatorGroup = new WebServiceNavigatorGroup(ResourcesPlugin.getWorkspace().getRoot());
        }
        return this.webServiceNavigatorGroup;
    }

    protected WebServicesManager getWebServicesManager() {
        if (this.webServicesManager == null) {
            this.webServicesManager = WebServicesManager.getInstance();
        }
        return this.webServicesManager;
    }

    public boolean isActivityEnabled() {
        return this.activityEnabled;
    }

    private WebServiceNavigatorGroupType getServicesGroup() {
        if (this.SERVICES == null) {
            this.SERVICES = new WebServiceNavigatorGroupType(0);
        }
        return this.SERVICES;
    }

    private WebServiceNavigatorGroupType getClientsGroup() {
        if (this.CLIENTS == null) {
            this.CLIENTS = new WebServiceNavigatorGroupType(2);
        }
        return this.CLIENTS;
    }

    private WebServiceNavigatorGroupType getHandlersGroup(Object key) {
        if (key == null) {
            return null;
        }
        WebServiceNavigatorGroupType handler = null;
        handler = (WebServiceNavigatorGroupType)this.HANDLERS.get(key);
        WSDLServiceHelper serviceHelper = WSDLServiceExtManager.getServiceHelper();
        if (handler == null) {
            if (serviceHelper.isService(key)) {
                handler = new WebServiceNavigatorGroupType(3, (EObject)key);
            } else if (key instanceof ServiceRef) {
                handler = new WebServiceNavigatorGroupType(3, (ServiceRef)key);
            }
            if (handler != null) {
                this.HANDLERS.put(key, handler);
            }
        }
        return handler;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }
}

