/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.ui.AddRemoveFacetsWizard;

public class FacetsPropertyPage
extends PropertyPage {
    private IFacetedProject _project;
    private TableViewer _viewer;
    private Label _runtimeLabel;

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        IAdaptable element = this.getElement();
        if (element instanceof IProject) {
            IProject project = (IProject)element;
            try {
                this._project = ProjectFacetsManager.create((IProject)project);
            }
            catch (CoreException coreException) {
                return null;
            }
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            this._runtimeLabel = new Label(composite, 0);
            this.setRuntimeLabel();
            new Label(composite, 0);
            Label pageLabel = new Label(composite, 0);
            pageLabel.setText(Resources.pageLabel);
            this.createTableGroup(composite);
            return composite;
        }
        return null;
    }

    private void createTableGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this._viewer = this.createTableViewer(composite);
        this._viewer.setInput((Object)this._project);
        Button button = new Button(parent, 8);
        button.setText(Resources.addRemoveLabel);
        button.setLayoutData((Object)new GridData(128));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddRemoveFacetsWizard wizard = new AddRemoveFacetsWizard(FacetsPropertyPage.this._project);
                WizardDialog dialog = new WizardDialog(FacetsPropertyPage.this.getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    FacetsPropertyPage.this._viewer.setInput((Object)FacetsPropertyPage.this._project);
                    FacetsPropertyPage.this.setRuntimeLabel();
                }
            }
        });
    }

    private TableViewer createTableViewer(Composite parent) {
        Table table = new Table(parent, 68352);
        table.setLayout((Layout)new GridLayout());
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn labelCol = new TableColumn(table, 0);
        labelCol.setText(Resources.facetLabel);
        labelCol.setResizable(true);
        labelCol.setWidth(200);
        TableColumn versionCol = new TableColumn(table, 0);
        versionCol.setText(Resources.versionLabel);
        versionCol.setResizable(true);
        versionCol.setWidth(100);
        TableViewer viewer = new TableViewer(table);
        viewer.setContentProvider((IContentProvider)new FacetsContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new FacetsLabelProvider());
        return viewer;
    }

    private void setRuntimeLabel() {
        IRuntime runtime = this._project.getRuntime();
        if (runtime != null) {
            this._runtimeLabel.setText(NLS.bind((String)Resources.runtimeLabel, (Object)this._project.getRuntime().getName()));
        } else {
            this._runtimeLabel.setText(Resources.runtimeText);
        }
        this._runtimeLabel.redraw();
    }

    private static class FacetsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        static final int DESCRIPTION_FIELD = 0;
        static final int VERSION_FIELD = 1;

        FacetsLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IProjectFacetVersion) {
                IProjectFacetVersion facet = (IProjectFacetVersion)element;
                switch (columnIndex) {
                    case 0: {
                        return facet.getProjectFacet().getLabel();
                    }
                    case 1: {
                        return facet.getVersionString();
                    }
                }
            }
            return null;
        }
    }

    private static class FacetsContentProvider
    implements IStructuredContentProvider {
        FacetsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IFacetedProject) {
                IFacetedProject project = (IFacetedProject)inputElement;
                ArrayList facets = new ArrayList();
                Iterator it = project.getProjectFacets().iterator();
                while (it.hasNext()) {
                    facets.add(it.next());
                }
                Collections.sort(facets, new Comparator(this){
                    final /* synthetic */ FacetsContentProvider this$1;
                    {
                        this.this$1 = facetsContentProvider;
                    }

                    public int compare(Object p1, Object p2) {
                        if (p1 == p2) {
                            return 0;
                        }
                        String label1 = ((IProjectFacetVersion)p1).getProjectFacet().getLabel();
                        String label2 = ((IProjectFacetVersion)p2).getProjectFacet().getLabel();
                        return label1.compareTo(label2);
                    }
                });
                return facets.toArray(new IProjectFacetVersion[0]);
            }
            return new String[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static final class Resources
    extends NLS {
        public static String pageLabel;
        public static String runtimeLabel;
        public static String runtimeText;
        public static String addRemoveLabel;
        public static String facetLabel;
        public static String versionLabel;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.common.project.facet.ui.internal.FacetsPropertyPage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String string = clazz.getName();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.wst.common.project.facet.ui.internal.FacetsPropertyPage$Resources");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Resources.initializeMessages((String)string, (Class)clazz2);
        }

        Resources() {
        }
    }
}

