/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.ui.internal.validation;

import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.dtd.ui.internal.DTDUIMessages;
import org.eclipse.wst.dtd.ui.internal.validation.ValidateDTDAction;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class DTDValidator
implements IValidator {
    private final String GET_FILE = "getFile";
    public final String GET_PROJECT_FILES = "getAllFiles";

    static boolean shouldValidate(IFile file) {
        IFile resource = file;
        do {
            if (!resource.isDerived() && !resource.isTeamPrivateMember() && resource.isAccessible() && resource.getName().charAt(0) != '.') continue;
            return false;
        } while (((resource = resource.getParent()).getType() & 4) == 0);
        return true;
    }

    public void cleanup(IReporter reporter) {
    }

    public void validate(IFile file) {
        ValidateDTDAction validateAction = new ValidateDTDAction(file, false);
        validateAction.setValidator(this);
        validateAction.run();
    }

    public void validate(IFile file, IReporter reporter, int ruleGroup) {
        ValidateDTDAction validateAction = new ValidateDTDAction(file, false);
        validateAction.setValidator(this);
        validateAction.run();
    }

    public void validate(IValidationContext context, IReporter reporter) throws ValidationException {
        String[] changedFiles = context.getURIs();
        if (changedFiles != null && changedFiles.length > 0) {
            int i = 0;
            while (i < changedFiles.length) {
                Object[] parms;
                IFile file;
                String changedFileName = changedFiles[i];
                if (changedFileName != null && (file = (IFile)context.loadModel("getFile", parms = new Object[]{changedFileName})) != null && DTDValidator.shouldValidate(file)) {
                    this.validateIfNeeded(file, context, reporter);
                }
                ++i;
            }
        } else {
            Object[] parms = new Object[]{this.getClass().getName()};
            Collection files = (Collection)context.loadModel("getAllFiles", parms);
            Iterator iter = files.iterator();
            while (iter.hasNext()) {
                IFile file = (IFile)iter.next();
                if (!DTDValidator.shouldValidate(file)) continue;
                this.validateIfNeeded(file, context, reporter);
            }
        }
    }

    protected void validateIfNeeded(IFile file, IValidationContext context, IReporter reporter) {
        LocalizedMessage message = new LocalizedMessage(4, NLS.bind((String)DTDUIMessages.MESSAGE_DTD_VALIDATION_MESSAGE_UI_, (Object[])new String[]{file.getFullPath().toString()}));
        reporter.displaySubtask((IValidator)this, (IMessage)message);
        Integer ruleGroupInt = (Integer)context.loadModel("PASS_LEVEL", null);
        int ruleGroup = ruleGroupInt == null ? 3 : ruleGroupInt;
        this.validate(file, reporter, ruleGroup);
    }

    class LocalizedMessage
    extends Message {
        private String _message = null;

        public LocalizedMessage(int severity, String messageText) {
            this(severity, messageText, null);
        }

        public LocalizedMessage(int severity, String messageText, IResource targetObject) {
            this(severity, messageText, (Object)targetObject);
        }

        public LocalizedMessage(int severity, String messageText, Object targetObject) {
            super(null, severity, null);
            this.setLocalizedMessage(messageText);
            this.setTargetObject(targetObject);
        }

        public void setLocalizedMessage(String message) {
            this._message = message;
        }

        public String getLocalizedMessage() {
            return this._message;
        }

        public String getText() {
            return this.getLocalizedMessage();
        }

        public String getText(ClassLoader cl) {
            return this.getLocalizedMessage();
        }

        public String getText(Locale l) {
            return this.getLocalizedMessage();
        }

        public String getText(Locale l, ClassLoader cl) {
            return this.getLocalizedMessage();
        }
    }
}

